/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.sherpa.SHERPAResponse;
import org.dspace.core.ConfigurationManager;

public class SHERPAService {
    private CloseableHttpClient client = null;
    private int maxNumberOfTries;
    private long sleepBetweenTimeouts;
    private int timeout = 5000;
    private static final Logger log = LogManager.getLogger(SHERPAService.class);

    public SHERPAService() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        this.client = builder.disableAutomaticRetries().setMaxConnTotal(5).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SHERPAResponse searchByJournalISSN(String query) {
        String endpoint = ConfigurationManager.getProperty("sherpa.romeo.url");
        String apiKey = ConfigurationManager.getProperty("sherpa.romeo.apikey");
        HttpGet method = null;
        SHERPAResponse sherpaResponse = null;
        int numberOfTries = 0;
        while (numberOfTries < this.maxNumberOfTries && sherpaResponse == null) {
            ++numberOfTries;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Trying to contact SHERPA/RoMEO - attempt %d of %d; timeout is %d; sleep between timeouts is %d", numberOfTries, this.maxNumberOfTries, this.timeout, this.sleepBetweenTimeouts));
            }
            try {
                HttpEntity responseBody;
                Thread.sleep(this.sleepBetweenTimeouts);
                URIBuilder uriBuilder = new URIBuilder(endpoint);
                uriBuilder.addParameter("issn", query);
                uriBuilder.addParameter("versions", "all");
                if (StringUtils.isNotBlank((CharSequence)apiKey)) {
                    uriBuilder.addParameter("ak", apiKey);
                }
                method = new HttpGet(uriBuilder.build());
                method.setConfig(RequestConfig.custom().setConnectionRequestTimeout(this.timeout).setConnectTimeout(this.timeout).setSocketTimeout(this.timeout).build());
                CloseableHttpResponse response = this.client.execute((HttpUriRequest)method);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    sherpaResponse = new SHERPAResponse("SHERPA/RoMEO return not OK status: " + statusCode);
                }
                if (null != (responseBody = response.getEntity())) {
                    sherpaResponse = new SHERPAResponse(responseBody.getContent());
                    continue;
                }
                sherpaResponse = new SHERPAResponse("SHERPA/RoMEO returned no response");
            }
            catch (Exception e) {
                log.warn("Encountered exception while contacting SHERPA/RoMEO: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (method == null) continue;
                method.releaseConnection();
            }
        }
        if (sherpaResponse == null) {
            sherpaResponse = new SHERPAResponse("Error processing the SHERPA/RoMEO answer");
        }
        return sherpaResponse;
    }

    public void setMaxNumberOfTries(int maxNumberOfTries) {
        this.maxNumberOfTries = maxNumberOfTries;
    }

    public void setSleepBetweenTimeouts(long sleepBetweenTimeouts) {
        this.sleepBetweenTimeouts = sleepBetweenTimeouts;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

