/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.sherpa.SHERPAPublisher;
import org.dspace.app.sherpa.SHERPAResponse;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;

public class SherpaPublisherDataProvider
implements ExternalDataProvider {
    private static final Logger log = LogManager.getLogger(SherpaPublisherDataProvider.class);
    private String sourceIdentifier;
    private String url;
    private String apiKey;

    @Override
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        ArrayList<BasicNameValuePair> args = new ArrayList<BasicNameValuePair>();
        args.add(new BasicNameValuePair("id", id));
        args.add(new BasicNameValuePair("ak", this.apiKey));
        DefaultHttpClient hc = new DefaultHttpClient();
        String srUrl = this.url + "?" + URLEncodedUtils.format(args, (String)"UTF8");
        HttpGet get = new HttpGet(srUrl);
        try {
            SHERPAResponse sherpaResponse;
            List<SHERPAPublisher> list;
            HttpResponse response = hc.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200 && CollectionUtils.isNotEmpty(list = (sherpaResponse = new SHERPAResponse(response.getEntity().getContent())).getPublishers())) {
                Optional<ExternalDataObject> optional = Optional.of(this.constructExternalDataObjectFromSherpaPublisher(list.get(0)));
                return optional;
            }
        }
        catch (IOException e) {
            log.error("SHERPA/RoMEO query failed: ", (Throwable)e);
            Optional<ExternalDataObject> optional = null;
            return optional;
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExternalDataObject> searchExternalDataObjects(String query, int start, int limit) {
        HttpGet get = this.constructHttpGet(query);
        try {
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                SHERPAResponse sherpaResponse = new SHERPAResponse(response.getEntity().getContent());
                List list = sherpaResponse.getPublishers().stream().map(sherpaPublisher -> this.constructExternalDataObjectFromSherpaPublisher((SHERPAPublisher)sherpaPublisher)).collect(Collectors.toList());
                List<ExternalDataObject> list2 = list.subList(start, Math.min(start + limit, list.size()));
                return list2;
            }
        }
        catch (IOException e) {
            log.error("SHERPA/RoMEO query failed: ", (Throwable)e);
            List<ExternalDataObject> list = null;
            return list;
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    private HttpGet constructHttpGet(String query) {
        ArrayList<BasicNameValuePair> args = new ArrayList<BasicNameValuePair>();
        args.add(new BasicNameValuePair("pub", query));
        args.add(new BasicNameValuePair("qtype", "all"));
        args.add(new BasicNameValuePair("ak", this.apiKey));
        String srUrl = this.url + "?" + URLEncodedUtils.format(args, (String)"UTF8");
        return new HttpGet(srUrl);
    }

    private ExternalDataObject constructExternalDataObjectFromSherpaPublisher(SHERPAPublisher sherpaPublisher) {
        ExternalDataObject externalDataObject = new ExternalDataObject();
        externalDataObject.setSource(this.sourceIdentifier);
        externalDataObject.addMetadata(new MetadataValueDTO("dc", "title", null, null, sherpaPublisher.getName()));
        externalDataObject.setDisplayValue(sherpaPublisher.getName());
        externalDataObject.setValue(sherpaPublisher.getName());
        if (StringUtils.isNotBlank((CharSequence)sherpaPublisher.getId())) {
            externalDataObject.setId(sherpaPublisher.getId());
            externalDataObject.addMetadata(new MetadataValueDTO("dc", "identifier", "sherpaPublisher", null, sherpaPublisher.getId()));
        }
        externalDataObject.addMetadata(new MetadataValueDTO("dc", "identifier", "other", null, sherpaPublisher.getHomeurl()));
        return externalDataObject;
    }

    @Override
    public boolean supports(String source) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfResults(String query) {
        HttpGet get = this.constructHttpGet(query);
        try {
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                SHERPAResponse sherpaResponse = new SHERPAResponse(response.getEntity().getContent());
                int n = sherpaResponse.getNumHits();
                return n;
            }
        }
        catch (IOException e) {
            log.error("SHERPA/RoMEO query failed: ", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            get.releaseConnection();
        }
        return 0;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }
}

