/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts.handler.impl;

import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.scripts.handler.DSpaceRunnableHandler;

public class CommandLineDSpaceRunnableHandler
implements DSpaceRunnableHandler {
    private static final Logger log = LogManager.getLogger(CommandLineDSpaceRunnableHandler.class);

    @Override
    public void start() {
        System.out.println("The script has started");
    }

    @Override
    public void handleCompletion() {
        System.out.println("The script has completed");
    }

    @Override
    public void handleException(Exception e) {
        this.handleException(null, e);
    }

    @Override
    public void handleException(String message) {
        this.handleException(message, null);
    }

    @Override
    public void handleException(String message, Exception e) {
        if (message != null) {
            System.err.println(message);
            log.error(message);
        }
        if (e != null) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
        }
        System.exit(1);
    }

    @Override
    public void logDebug(String message) {
        log.debug(message);
    }

    @Override
    public void logInfo(String message) {
        System.out.println(message);
        log.info(message);
    }

    @Override
    public void logWarning(String message) {
        System.out.println(message);
        log.warn(message);
    }

    @Override
    public void logError(String message) {
        System.err.println(message);
        log.error(message);
    }

    @Override
    public void printHelp(Options options, String name) {
        if (options != null) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(name, options);
        }
    }
}

