/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpException;
import org.dspace.core.Context;
import org.dspace.submit.lookup.ArXivService;
import org.dspace.submit.lookup.NetworkSubmissionLookupDataLoader;

public class ArXivOnlineDataLoader
extends NetworkSubmissionLookupDataLoader {
    protected ArXivService arXivService = new ArXivService();
    protected boolean searchProvider = true;

    public void setArXivService(ArXivService arXivService) {
        this.arXivService = arXivService;
    }

    @Override
    public List<String> getSupportedIdentifiers() {
        return Arrays.asList("arxiv", "doi");
    }

    public void setSearchProvider(boolean searchProvider) {
        this.searchProvider = searchProvider;
    }

    @Override
    public boolean isSearchProvider() {
        return this.searchProvider;
    }

    @Override
    public List<Record> getByIdentifier(Context context, Map<String, Set<String>> keys) throws HttpException, IOException {
        ArrayList<Record> results = new ArrayList<Record>();
        if (keys != null) {
            Set<String> dois = keys.get("doi");
            Set<String> arxivids = keys.get("arxiv");
            ArrayList<Record> items = new ArrayList<Record>();
            if (dois != null && dois.size() > 0) {
                items.addAll(this.arXivService.getByDOIs(dois));
            }
            if (arxivids != null && arxivids.size() > 0) {
                for (String arxivid : arxivids) {
                    items.add(this.arXivService.getByArXivIDs(arxivid));
                }
            }
            for (Record item : items) {
                results.add(this.convertFields(item));
            }
        }
        return results;
    }

    @Override
    public List<Record> search(Context context, String title, String author, int year) throws HttpException, IOException {
        ArrayList<Record> results = new ArrayList<Record>();
        List<Record> items = this.arXivService.searchByTerm(title, author, year);
        for (Record item : items) {
            results.add(this.convertFields(item));
        }
        return results;
    }
}

