/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverFilterQuery;
import org.dspace.discovery.DiscoverHitHighlightingField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.FacetYearRange;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SolrSearchCore;
import org.dspace.discovery.SolrServiceSearchPlugin;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.discovery.configuration.DiscoveryMoreLikeThisConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.discovery.indexobject.factory.IndexObjectFactoryFactory;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SolrServiceImpl
implements SearchService,
IndexingService {
    private static final Logger log = LogManager.getLogger(SolrServiceImpl.class);
    @Autowired
    protected ContentServiceFactory contentServiceFactory;
    @Autowired
    protected GroupService groupService;
    @Autowired
    protected IndexObjectFactoryFactory indexObjectServiceFactory;
    @Autowired
    protected SolrSearchCore solrSearchCore;

    protected SolrServiceImpl() {
    }

    @Override
    public void indexContent(Context context, IndexableObject dso) throws SQLException {
        this.indexContent(context, dso, false);
    }

    @Override
    public void indexContent(Context context, IndexableObject indexableObject, boolean force) {
        try {
            IndexFactory indexableObjectFactory = this.indexObjectServiceFactory.getIndexableObjectFactory(indexableObject);
            if (force || this.requiresIndexing(indexableObject.getUniqueIndexID(), indexableObject.getLastModified())) {
                this.update(context, indexableObjectFactory, indexableObject);
                log.info(org.dspace.core.LogManager.getHeader(context, "indexed_object", indexableObject.getUniqueIndexID()));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void update(Context context, IndexFactory indexableObjectService, IndexableObject indexableObject) throws IOException, SQLException, SolrServerException {
        SolrInputDocument solrInputDocument = indexableObjectService.buildDocument(context, indexableObject);
        indexableObjectService.writeDocument(context, indexableObject, solrInputDocument);
    }

    @Override
    public void unIndexContent(Context context, IndexableObject dso) throws SQLException, IOException {
        this.unIndexContent(context, dso, false);
    }

    @Override
    public void unIndexContent(Context context, IndexableObject indexableObject, boolean commit) throws SQLException, IOException {
        try {
            if (indexableObject == null) {
                return;
            }
            String uniqueID = indexableObject.getUniqueIndexID();
            log.info("Try to delete uniqueID:" + uniqueID);
            this.indexObjectServiceFactory.getIndexableObjectFactory(indexableObject).delete(indexableObject);
            if (commit) {
                this.solrSearchCore.getSolr().commit();
            }
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            this.emailException(exception);
        }
    }

    @Override
    public void unIndexContent(Context context, String searchUniqueID) throws IOException {
        this.unIndexContent(context, searchUniqueID, false);
    }

    @Override
    public void unIndexContent(Context context, String searchUniqueID, boolean commit) throws IOException {
        try {
            if (this.solrSearchCore.getSolr() != null) {
                this.indexObjectServiceFactory.getIndexableObjectFactory(searchUniqueID).delete(searchUniqueID);
                if (commit) {
                    this.solrSearchCore.getSolr().commit();
                }
            }
        }
        catch (SolrServerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void reIndexContent(Context context, IndexableObject dso) throws SQLException, IOException {
        try {
            this.indexContent(context, dso);
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            this.emailException(exception);
        }
    }

    @Override
    public void createIndex(Context c) throws SQLException, IOException {
        this.updateIndex(c, true);
    }

    @Override
    public void updateIndex(Context context) {
        this.updateIndex(context, false);
    }

    @Override
    public void updateIndex(Context context, boolean force) {
        this.updateIndex(context, force, null);
    }

    @Override
    public void updateIndex(Context context, boolean force, String type) {
        try {
            List<IndexFactory> indexableObjectServices = this.indexObjectServiceFactory.getIndexFactories();
            for (IndexFactory indexableObjectService : indexableObjectServices) {
                if (type != null && !StringUtils.equals((CharSequence)indexableObjectService.getType(), (CharSequence)type)) continue;
                Iterator indexableObjects = indexableObjectService.findAll(context);
                while (indexableObjects.hasNext()) {
                    IndexableObject indexableObject = (IndexableObject)indexableObjects.next();
                    this.indexContent(context, indexableObject, force);
                    context.uncacheEntity(indexableObject.getIndexedObject());
                }
            }
            if (this.solrSearchCore.getSolr() != null) {
                this.solrSearchCore.getSolr().commit();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanIndex(boolean force) throws IOException, SQLException, SearchServiceException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return;
            }
            if (force) {
                List<IndexFactory> indexableObjectServices = this.indexObjectServiceFactory.getIndexFactories();
                for (IndexFactory indexableObjectService : indexableObjectServices) {
                    indexableObjectService.deleteAll();
                }
            } else {
                SolrQuery query = new SolrQuery();
                query.setFields(new String[]{"search.uniqueid"});
                query.addSort("search.uniqueid", SolrQuery.ORDER.asc);
                query.setQuery("*:*");
                QueryResponse totalResponse = this.solrSearchCore.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST);
                long total = totalResponse.getResults().getNumFound();
                int start = 0;
                int batch = 100;
                query.setRows(Integer.valueOf(batch));
                while ((long)start < total) {
                    query.setStart(Integer.valueOf(start));
                    QueryResponse rsp = this.solrSearchCore.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST);
                    SolrDocumentList docs = rsp.getResults();
                    for (SolrDocument doc : docs) {
                        String uniqueID = (String)doc.getFieldValue("search.uniqueid");
                        IndexableObject o = this.findIndexableObject(context, doc);
                        if (o == null) {
                            log.info("Deleting: " + uniqueID);
                            this.unIndexContent(context, uniqueID);
                            continue;
                        }
                        log.debug("Keeping: " + o.getUniqueIndexID());
                    }
                    start += batch;
                }
            }
        }
        catch (Exception e) {
            log.error("Error cleaning discovery index: " + e.getMessage(), (Throwable)e);
        }
        finally {
            context.abort();
        }
    }

    @Override
    public void optimize() {
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return;
            }
            long start = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Started:" + start);
            this.solrSearchCore.getSolr().optimize();
            long finish = System.currentTimeMillis();
            System.out.println("SOLR Search Optimize -- Process Finished:" + finish);
            System.out.println("SOLR Search Optimize -- Total time taken:" + (finish - start) + " (ms).");
        }
        catch (SolrServerException sse) {
            System.err.println(sse.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    @Override
    public void buildSpellCheck() throws SearchServiceException, IOException {
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return;
            }
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.set("spellcheck", true);
            solrQuery.set("spellcheck.build", true);
            this.solrSearchCore.getSolr().query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
        }
        catch (SolrServerException e) {
            log.error((Object)e, (Throwable)e);
            throw new SearchServiceException(e);
        }
    }

    protected void emailException(Exception exception) {
        try {
            String recipient = ConfigurationManager.getProperty("alert.recipient");
            if (StringUtils.isNotBlank((CharSequence)recipient)) {
                String stackTrace;
                Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "internal_error"));
                email.addRecipient(recipient);
                email.addArgument(ConfigurationManager.getProperty("dspace.ui.url"));
                email.addArgument(new Date());
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn("Unable to send email alert", (Throwable)e);
        }
    }

    protected boolean requiresIndexing(String uniqueId, Date lastModified) throws SQLException, IOException, SearchServiceException {
        QueryResponse rsp;
        if (lastModified == null) {
            return true;
        }
        boolean reindexItem = false;
        boolean inIndex = false;
        SolrQuery query = new SolrQuery();
        query.setQuery("search.uniqueid:" + uniqueId);
        query.setFields(new String[]{"SolrIndexer.lastIndexed"});
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return false;
            }
            rsp = this.solrSearchCore.getSolr().query((SolrParams)query, SolrRequest.METHOD.POST);
        }
        catch (SolrServerException e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
        for (SolrDocument doc : rsp.getResults()) {
            Date lastIndexed;
            inIndex = true;
            Object value = doc.getFieldValue("SolrIndexer.lastIndexed");
            if (!(value instanceof Date) || !(lastIndexed = (Date)value).before(lastModified)) continue;
            reindexItem = true;
        }
        return reindexItem || !inIndex;
    }

    @Override
    public String createLocationQueryForAdministrableItems(Context context) throws SQLException {
        StringBuilder locationQuery = new StringBuilder();
        if (context.getCurrentUser() != null) {
            List<Group> groupList = EPersonServiceFactory.getInstance().getGroupService().allMemberGroups(context, context.getCurrentUser());
            List<ResourcePolicy> communitiesPolicies = AuthorizeServiceFactory.getInstance().getResourcePolicyService().find(context, context.getCurrentUser(), groupList, 11, 4);
            List<ResourcePolicy> collectionsPolicies = AuthorizeServiceFactory.getInstance().getResourcePolicyService().find(context, context.getCurrentUser(), groupList, 11, 3);
            ArrayList<org.dspace.content.Collection> allCollections = new ArrayList<org.dspace.content.Collection>();
            for (ResourcePolicy rp : collectionsPolicies) {
                org.dspace.content.Collection collection = (org.dspace.content.Collection)ContentServiceFactory.getInstance().getCollectionService().find(context, rp.getdSpaceObject().getID());
                allCollections.add(collection);
            }
            if (CollectionUtils.isNotEmpty(communitiesPolicies) || CollectionUtils.isNotEmpty(allCollections)) {
                locationQuery.append("location:( ");
                for (int i = 0; i < communitiesPolicies.size(); ++i) {
                    ResourcePolicy rp;
                    rp = communitiesPolicies.get(i);
                    Community community = (Community)ContentServiceFactory.getInstance().getCommunityService().find(context, rp.getdSpaceObject().getID());
                    locationQuery.append("m").append(community.getID());
                    if (i != communitiesPolicies.size() - 1) {
                        locationQuery.append(" OR ");
                    }
                    allCollections.addAll(ContentServiceFactory.getInstance().getCommunityService().getAllCollections(context, community));
                }
                Iterator collIter = allCollections.iterator();
                if (communitiesPolicies.size() > 0 && allCollections.size() > 0) {
                    locationQuery.append(" OR ");
                }
                while (collIter.hasNext()) {
                    locationQuery.append("l").append(((org.dspace.content.Collection)collIter.next()).getID());
                    if (!collIter.hasNext()) continue;
                    locationQuery.append(" OR ");
                }
                locationQuery.append(")");
            } else {
                log.warn("We have a collection or community admin with ID: " + context.getCurrentUser().getID() + " without any administrable collection or community!");
            }
        }
        return locationQuery.toString();
    }

    public Date toDate(String t) {
        SimpleDateFormat[] dfArr;
        switch (((String)t).length()) {
            case 1: {
                t = "0" + (String)t;
            }
            case 2: {
                t = "0" + (String)t;
            }
            case 3: {
                t = "0" + (String)t;
            }
            case 4: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy")};
                break;
            }
            case 6: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMM")};
                break;
            }
            case 7: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM")};
                break;
            }
            case 8: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy MMM")};
                break;
            }
            case 10: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd")};
                break;
            }
            case 11: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy MMM dd")};
                break;
            }
            case 20: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")};
                break;
            }
            default: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")};
            }
        }
        for (SimpleDateFormat df : dfArr) {
            try {
                df.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                df.setLenient(false);
                return df.parse((String)t);
            }
            catch (ParseException pe) {
                log.error("Unable to parse date format", (Throwable)pe);
            }
        }
        return null;
    }

    public String locationToName(Context context, String field, String value) throws SQLException {
        if ("location.comm".equals(field) || "location.coll".equals(field)) {
            int type = "location.comm".equals(field) ? 4 : 3;
            DSpaceObject commColl = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                commColl = this.contentServiceFactory.getDSpaceObjectService(type).find(context, UUID.fromString(value));
            }
            if (commColl != null) {
                return commColl.getName();
            }
        }
        return value;
    }

    @Override
    public DiscoverResult search(Context context, IndexableObject dso, DiscoverQuery discoveryQuery) throws SearchServiceException {
        if (dso != null) {
            if (dso instanceof IndexableCommunity) {
                discoveryQuery.addFilterQueries("location:m" + dso.getID());
            } else if (dso instanceof IndexableCollection) {
                discoveryQuery.addFilterQueries("location:l" + dso.getID());
            } else if (dso instanceof IndexableItem) {
                discoveryQuery.addFilterQueries("search.uniqueid:" + dso.getUniqueIndexID());
            }
        }
        return this.search(context, discoveryQuery);
    }

    @Override
    public DiscoverResult search(Context context, DiscoverQuery discoveryQuery) throws SearchServiceException {
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return new DiscoverResult();
            }
            SolrQuery solrQuery = this.resolveToSolrQuery(context, discoveryQuery);
            QueryResponse queryResponse = this.solrSearchCore.getSolr().query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            return this.retrieveResult(context, discoveryQuery, queryResponse);
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
    }

    protected SolrQuery resolveToSolrQuery(Context context, DiscoverQuery discoveryQuery) throws SearchServiceException {
        int i;
        SolrQuery solrQuery = new SolrQuery();
        String query = "*:*";
        if (discoveryQuery.getQuery() != null) {
            query = discoveryQuery.getQuery();
        }
        solrQuery.setQuery(query);
        for (String string : discoveryQuery.getSearchFields()) {
            solrQuery.addField(string);
        }
        solrQuery.addField("search.resourcetype");
        solrQuery.addField("search.resourceid");
        if (discoveryQuery.isSpellCheck()) {
            solrQuery.setParam("spellcheck.q", new String[]{query});
            solrQuery.setParam("spellcheck.collate", Boolean.TRUE.booleanValue());
            solrQuery.setParam("spellcheck", Boolean.TRUE.booleanValue());
        }
        for (i = 0; i < discoveryQuery.getFilterQueries().size(); ++i) {
            String string = discoveryQuery.getFilterQueries().get(i);
            solrQuery.addFilterQuery(new String[]{string});
        }
        if (discoveryQuery.getDSpaceObjectFilter() != null) {
            solrQuery.addFilterQuery(new String[]{"search.resourcetype:" + discoveryQuery.getDSpaceObjectFilter()});
        }
        for (i = 0; i < discoveryQuery.getFieldPresentQueries().size(); ++i) {
            String string = discoveryQuery.getFieldPresentQueries().get(i);
            solrQuery.addFilterQuery(new String[]{string + ":[* TO *]"});
        }
        if (discoveryQuery.getStart() != -1) {
            solrQuery.setStart(Integer.valueOf(discoveryQuery.getStart()));
        }
        if (discoveryQuery.getMaxResults() != -1) {
            solrQuery.setRows(Integer.valueOf(discoveryQuery.getMaxResults()));
        }
        if (discoveryQuery.getSortField() != null) {
            SolrQuery.ORDER order = SolrQuery.ORDER.asc;
            if (discoveryQuery.getSortOrder().equals((Object)DiscoverQuery.SORT_ORDER.desc)) {
                order = SolrQuery.ORDER.desc;
            }
            solrQuery.addSort(discoveryQuery.getSortField(), order);
        }
        for (String string : discoveryQuery.getProperties().keySet()) {
            List<String> list = discoveryQuery.getProperties().get(string);
            solrQuery.add(string, list.toArray(new String[list.size()]));
        }
        List<DiscoverFacetField> facetFields = discoveryQuery.getFacetFields();
        if (0 < facetFields.size()) {
            for (DiscoverFacetField discoverFacetField : facetFields) {
                String field = this.transformFacetField(discoverFacetField, discoverFacetField.getField(), false);
                solrQuery.addFacetField(new String[]{field});
                solrQuery.add("f." + field + ".facet.limit", new String[]{String.valueOf(discoverFacetField.getLimit())});
                String facetSort = DiscoveryConfigurationParameters.SORT.COUNT.equals((Object)discoverFacetField.getSortOrder()) ? "count" : "index";
                solrQuery.add("f." + field + ".facet.sort", new String[]{facetSort});
                if (discoverFacetField.getOffset() != -1) {
                    solrQuery.setParam("f." + field + ".facet.offset", new String[]{String.valueOf(discoverFacetField.getOffset())});
                }
                if (discoverFacetField.getPrefix() == null) continue;
                solrQuery.setFacetPrefix(field, discoverFacetField.getPrefix());
            }
        }
        List<String> list = discoveryQuery.getFacetQueries();
        for (String facetQuery : list) {
            solrQuery.addFacetQuery(facetQuery);
        }
        if (discoveryQuery.getFacetMinCount() != -1) {
            solrQuery.setFacetMinCount(discoveryQuery.getFacetMinCount());
        }
        if (CollectionUtils.isNotEmpty(facetFields) || CollectionUtils.isNotEmpty(list)) {
            solrQuery.setParam("facet.offset", new String[]{String.valueOf(discoveryQuery.getFacetOffset())});
        }
        if (0 < discoveryQuery.getHitHighlightingFields().size()) {
            solrQuery.setHighlight(true);
            solrQuery.add("hl.usePhraseHighlighter", new String[]{Boolean.TRUE.toString()});
            for (DiscoverHitHighlightingField highlightingField : discoveryQuery.getHitHighlightingFields()) {
                solrQuery.addHighlightField(highlightingField.getField() + "_hl");
                solrQuery.add("f." + highlightingField.getField() + "_hl.hl.fragsize", new String[]{String.valueOf(highlightingField.getMaxChars())});
                solrQuery.add("f." + highlightingField.getField() + "_hl.hl.snippets", new String[]{String.valueOf(highlightingField.getMaxSnippets())});
            }
        }
        List list2 = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(SolrServiceSearchPlugin.class);
        for (SolrServiceSearchPlugin searchPlugin : list2) {
            searchPlugin.additionalSearchParameters(context, discoveryQuery, solrQuery);
        }
        return solrQuery;
    }

    protected DiscoverResult retrieveResult(Context context, DiscoverQuery query, QueryResponse solrQueryResponse) throws SQLException {
        DiscoverResult result = new DiscoverResult();
        if (solrQueryResponse != null) {
            String recommendedQuery;
            result.setSearchTime(solrQueryResponse.getQTime());
            result.setStart(query.getStart());
            result.setMaxResults(query.getMaxResults());
            result.setTotalSearchResults(solrQueryResponse.getResults().getNumFound());
            List<String> searchFields = query.getSearchFields();
            for (SolrDocument doc : solrQueryResponse.getResults()) {
                Map highlightedFields;
                IndexableObject indexableObject = this.findIndexableObject(context, doc);
                if (indexableObject == null) {
                    log.error(org.dspace.core.LogManager.getHeader(context, "Error while retrieving DSpace object from discovery index", "Unique identifier: " + doc.getFirstValue("search.uniqueid")));
                    continue;
                }
                result.addIndexableObject(indexableObject);
                DiscoverResult.SearchDocument resultDoc = new DiscoverResult.SearchDocument();
                for (String field : searchFields) {
                    ArrayList<String> valuesAsString = new ArrayList<String>();
                    for (Object o : doc.getFieldValues(field)) {
                        valuesAsString.add(String.valueOf(o));
                    }
                    resultDoc.addSearchField(field, valuesAsString.toArray(new String[valuesAsString.size()]));
                }
                result.addSearchDocument(indexableObject, resultDoc);
                if (solrQueryResponse.getHighlighting() == null || !MapUtils.isNotEmpty((Map)(highlightedFields = (Map)solrQueryResponse.getHighlighting().get(indexableObject.getUniqueIndexID())))) continue;
                HashMap resultMap = new HashMap();
                for (String key : highlightedFields.keySet()) {
                    List highlightOriginalValue = (List)highlightedFields.get(key);
                    ArrayList<String[]> resultHighlightOriginalValue = new ArrayList<String[]>();
                    for (String highlightValue : highlightOriginalValue) {
                        String[] splitted = highlightValue.split("###");
                        resultHighlightOriginalValue.add(splitted);
                    }
                    resultMap.put(key.substring(0, key.lastIndexOf("_hl")), (List)highlightedFields.get(key));
                }
                result.addHighlightedResult(indexableObject, new DiscoverResult.IndexableObjectHighlightResult(indexableObject, resultMap));
            }
            List facetFields = solrQueryResponse.getFacetFields();
            if (facetFields != null) {
                for (int i = 0; i < facetFields.size(); ++i) {
                    FacetField facetField = (FacetField)facetFields.get(i);
                    DiscoverFacetField facetFieldConfig = query.getFacetFields().get(i);
                    List facetValues = facetField.getValues();
                    if (facetValues == null) continue;
                    if (facetFieldConfig.getType().equals("date") && facetFieldConfig.getSortOrder().equals((Object)DiscoveryConfigurationParameters.SORT.VALUE)) {
                        Collections.reverse(facetValues);
                    }
                    for (FacetField.Count facetValue : facetValues) {
                        String displayedValue = this.transformDisplayedValue(context, facetField.getName(), facetValue.getName());
                        String field = this.transformFacetField(facetFieldConfig, facetField.getName(), true);
                        String authorityValue = this.transformAuthorityValue(context, facetField.getName(), facetValue.getName());
                        String sortValue = this.transformSortValue(context, facetField.getName(), facetValue.getName());
                        String filterValue = displayedValue;
                        if (StringUtils.isNotBlank((CharSequence)authorityValue)) {
                            filterValue = authorityValue;
                        }
                        result.addFacetResult(field, new DiscoverResult.FacetResult(filterValue, displayedValue, authorityValue, sortValue, facetValue.getCount(), facetFieldConfig.getType()));
                    }
                }
            }
            if (solrQueryResponse.getFacetQuery() != null) {
                LinkedHashMap sortedFacetQueries = new LinkedHashMap(solrQueryResponse.getFacetQuery());
                for (String facetQuery : sortedFacetQueries.keySet()) {
                    Integer count;
                    String facetField = facetQuery.substring(0, facetQuery.indexOf(":"));
                    String name = "";
                    String filter = "";
                    if (facetQuery.indexOf(91) > -1 && facetQuery.lastIndexOf(93) > -1) {
                        name = facetQuery.substring(facetQuery.indexOf(91) + 1);
                        name = name.substring(0, name.lastIndexOf(93)).replaceAll("TO", "-");
                        filter = facetQuery.substring(facetQuery.indexOf(91));
                        filter = filter.substring(0, filter.lastIndexOf(93) + 1);
                    }
                    if (0 >= (count = (Integer)sortedFacetQueries.get(facetQuery))) continue;
                    result.addFacetResult(facetField, new DiscoverResult.FacetResult(filter, name, null, name, count.intValue(), "date"));
                }
            }
            if (solrQueryResponse.getSpellCheckResponse() != null && StringUtils.isNotBlank((CharSequence)(recommendedQuery = solrQueryResponse.getSpellCheckResponse().getCollatedResult()))) {
                result.setSpellCheckQuery(recommendedQuery);
            }
        }
        return result;
    }

    protected IndexableObject findIndexableObject(Context context, SolrDocument doc) throws SQLException {
        String type = (String)doc.getFirstValue("search.resourcetype");
        String id = (String)doc.getFirstValue("search.resourceid");
        IndexFactory indexableObjectService = this.indexObjectServiceFactory.getIndexFactoryByType(type);
        Optional indexableObject = indexableObjectService.findIndexableObject(context, id);
        if (!indexableObject.isPresent()) {
            log.warn("Not able to retrieve object RESOURCE_ID:" + id + " - RESOURCE_TYPE_ID:" + type);
        }
        return indexableObject.orElse(null);
    }

    public List<IndexableObject> search(Context context, String query, int offset, int max, String ... filterquery) {
        return this.search(context, query, null, true, offset, max, filterquery);
    }

    @Override
    public List<IndexableObject> search(Context context, String query, String orderfield, boolean ascending, int offset, int max, String ... filterquery) {
        try {
            if (this.solrSearchCore.getSolr() == null) {
                return Collections.emptyList();
            }
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            solrQuery.setFields(new String[]{"search.resourceid", "search.resourcetype"});
            solrQuery.setStart(Integer.valueOf(offset));
            solrQuery.setRows(Integer.valueOf(max));
            if (orderfield != null) {
                solrQuery.addSort(orderfield, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            }
            if (filterquery != null) {
                solrQuery.addFilterQuery(filterquery);
            }
            QueryResponse rsp = this.solrSearchCore.getSolr().query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            SolrDocumentList docs = rsp.getResults();
            Iterator iter = docs.iterator();
            ArrayList<IndexableObject> result = new ArrayList<IndexableObject>();
            while (iter.hasNext()) {
                SolrDocument doc = (SolrDocument)iter.next();
                IndexableObject o = this.findIndexableObject(context, doc);
                if (o == null) continue;
                result.add(o);
            }
            return result;
        }
        catch (Exception e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while quering solr", "Query: " + query), (Throwable)e);
            return new ArrayList<IndexableObject>(0);
        }
    }

    @Override
    public DiscoverFilterQuery toFilterQuery(Context context, String field, String operator, String value) throws SQLException {
        DiscoverFilterQuery result = new DiscoverFilterQuery();
        StringBuilder filterQuery = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)field) && StringUtils.isNotBlank((CharSequence)value)) {
            filterQuery.append(field);
            if (operator.endsWith("equals")) {
                filterQuery.append("_keyword");
            } else if (operator.endsWith("authority")) {
                filterQuery.append("_authority");
            }
            if (operator.startsWith("not")) {
                filterQuery.insert(0, "-");
            }
            filterQuery.append(":");
            if ("equals".equals(operator) || "notequals".equals(operator)) {
                if (!((String)value).matches("\\[.*TO.*\\]")) {
                    value = ClientUtils.escapeQueryChars((String)value);
                    filterQuery.append((String)value);
                } else {
                    if (((String)value).matches("\\[\\d{1,4} TO \\d{1,4}\\]")) {
                        int minRange = Integer.parseInt(((String)value).substring(1, ((String)value).length() - 1).split(" TO ")[0]);
                        int maxRange = Integer.parseInt(((String)value).substring(1, ((String)value).length() - 1).split(" TO ")[1]);
                        value = "[" + String.format("%04d", minRange) + " TO " + String.format("%04d", maxRange) + "]";
                    }
                    filterQuery.append((String)value);
                }
            } else if (!((String)value).matches("\\[.*TO.*\\]")) {
                value = ClientUtils.escapeQueryChars((String)value);
                filterQuery.append("(").append((String)value).append(")");
            } else {
                filterQuery.append((String)value);
            }
            result.setDisplayedValue(this.transformDisplayedValue(context, field, (String)value));
        }
        result.setFilterQuery(filterQuery.toString());
        return result;
    }

    @Override
    public List<Item> getRelatedItems(Context context, Item item, DiscoveryMoreLikeThisConfiguration mltConfig) {
        ArrayList<Item> results = new ArrayList<Item>();
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery("search.uniqueid: " + new IndexableItem(item).getUniqueIndexID());
            solrQuery.setFields(new String[]{"search.resourcetype", "search.resourceid"});
            solrQuery.setParam("mlt", true);
            Collection similarityMetadataFields = CollectionUtils.collect(mltConfig.getSimilarityMetadataFields(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return input + "_mlt";
                }
            });
            solrQuery.setParam("mlt.fl", new String[]{StringUtils.join((Iterable)similarityMetadataFields, (char)',')});
            solrQuery.setParam("mlt.mintf", new String[]{String.valueOf(mltConfig.getMinTermFrequency())});
            solrQuery.setParam("mlt.count", new String[]{String.valueOf(mltConfig.getMax())});
            solrQuery.setParam("mlt.minwl", new String[]{String.valueOf(mltConfig.getMinWordLength())});
            if (this.solrSearchCore.getSolr() == null) {
                return Collections.emptyList();
            }
            QueryResponse rsp = this.solrSearchCore.getSolr().query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            NamedList mltResults = (NamedList)rsp.getResponse().get("moreLikeThis");
            if (mltResults != null && mltResults.get(item.getType() + "-" + item.getID()) != null) {
                SolrDocumentList relatedDocs = (SolrDocumentList)mltResults.get(item.getType() + "-" + item.getID());
                for (Object relatedDoc : relatedDocs) {
                    SolrDocument relatedDocument = (SolrDocument)relatedDoc;
                    IndexableObject relatedItem = this.findIndexableObject(context, relatedDocument);
                    if (!(relatedItem instanceof IndexableItem)) continue;
                    results.add((Item)((IndexableItem)relatedItem).getIndexedObject());
                }
            }
        }
        catch (Exception e) {
            log.error(org.dspace.core.LogManager.getHeader(context, "Error while retrieving related items", "Handle: " + item.getHandle()), (Throwable)e);
        }
        return results;
    }

    @Override
    public String toSortFieldIndex(String metadataField, String type) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"score", (CharSequence)metadataField)) {
            return "score";
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"date")) {
            return metadataField + "_dt";
        }
        return metadataField + "_sort";
    }

    protected String transformFacetField(DiscoverFacetField facetFieldConfig, String field, boolean removePostfix) {
        if (facetFieldConfig.getType().equals("text")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_filter"));
            }
            return field + "_filter";
        }
        if (facetFieldConfig.getType().equals("date")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf(".year"));
            }
            return field + ".year";
        }
        if (facetFieldConfig.getType().equals("ac")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_ac"));
            }
            return field + "_ac";
        }
        if (facetFieldConfig.getType().equals("hierarchical")) {
            if (removePostfix) {
                return StringUtils.substringBeforeLast((String)field, (String)"_tax_");
            }
            return field + "_tax_0_filter";
        }
        if (facetFieldConfig.getType().equals("authority")) {
            if (removePostfix) {
                return field.substring(0, field.lastIndexOf("_acid"));
            }
            return field + "_acid";
        }
        if (facetFieldConfig.getType().equals("standard")) {
            return field;
        }
        return field;
    }

    protected String transformDisplayedValue(Context context, String field, String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (field.equals("location.comm") || field.equals("location.coll")) {
            value = this.locationToName(context, field, value);
        } else if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            int start;
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer valueBuffer = new StringBuffer();
            for (int i = start = fqParts.length / 2; i < fqParts.length; ++i) {
                String[] split = fqParts[i].split("###", 2);
                valueBuffer.append(split[0]);
            }
            value = valueBuffer.toString();
        } else if (value.matches("\\((.*?)\\)")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected String transformAuthorityValue(Context context, String field, String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (field.equals("location.comm") || field.equals("location.coll")) {
            return value;
        }
        if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            int start;
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer authorityBuffer = new StringBuffer();
            for (int i = start = fqParts.length / 2; i < fqParts.length; ++i) {
                String[] split = fqParts[i].split("###", 2);
                if (split.length != 2) continue;
                authorityBuffer.append(split[1]);
            }
            if (authorityBuffer.length() > 0) {
                return authorityBuffer.toString();
            }
        }
        return null;
    }

    protected String transformSortValue(Context context, String field, String value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (field.equals("location.comm") || field.equals("location.coll")) {
            value = this.locationToName(context, field, value);
        } else if (field.endsWith("_filter") || field.endsWith("_ac") || field.endsWith("_acid")) {
            String separator = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.solr.facets.split.char");
            if (separator == null) {
                separator = "\n|||\n";
            }
            separator = Pattern.quote(separator);
            String[] fqParts = value.split(separator);
            StringBuffer valueBuffer = new StringBuffer();
            int end = fqParts.length / 2;
            for (int i = 0; i < end; ++i) {
                valueBuffer.append(fqParts[i]);
            }
            value = valueBuffer.toString();
        } else if (value.matches("\\((.*?)\\)")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    @Override
    public void indexContent(Context context, IndexableObject dso, boolean force, boolean commit) throws SearchServiceException, SQLException {
        this.indexContent(context, dso, force);
        if (commit) {
            this.commit();
        }
    }

    @Override
    public void commit() throws SearchServiceException {
        try {
            if (this.solrSearchCore.getSolr() != null) {
                this.solrSearchCore.getSolr().commit();
            }
        }
        catch (Exception e) {
            throw new SearchServiceException(e.getMessage(), e);
        }
    }

    @Override
    public String escapeQueryChars(String query) {
        return ClientUtils.escapeQueryChars((String)query);
    }

    @Override
    public FacetYearRange getFacetYearRange(Context context, IndexableObject scope, DiscoverySearchFilterFacet facet, List<String> filterQueries, DiscoverQuery parentQuery) throws SearchServiceException {
        FacetYearRange result = new FacetYearRange(facet);
        result.calculateRange(context, filterQueries, scope, this, parentQuery);
        return result;
    }

    @Override
    public String calculateExtremeValue(Context context, String valueField, String sortField, DiscoverQuery.SORT_ORDER sortOrder) throws SearchServiceException {
        List<DiscoverResult.SearchDocument> searchDocuments;
        DiscoverQuery maxQuery = new DiscoverQuery();
        maxQuery.setMaxResults(1);
        maxQuery.addFieldPresentQueries(valueField);
        maxQuery.setSortField(sortField, sortOrder);
        maxQuery.addSearchField(valueField);
        DiscoverResult maxResult = this.search(context, maxQuery);
        if (0 < maxResult.getIndexableObjects().size() && 0 < (searchDocuments = maxResult.getSearchDocument(maxResult.getIndexableObjects().get(0))).size() && 0 < searchDocuments.get(0).getSearchFieldValues(valueField).size()) {
            return searchDocuments.get(0).getSearchFieldValues(valueField).get(0);
        }
        return null;
    }
}

