/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightFieldConfiguration;
import org.dspace.discovery.configuration.DiscoveryHitHighlightingConfiguration;
import org.dspace.discovery.indexobject.DSpaceObjectIndexFactoryImpl;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.factory.CollectionIndexFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectionIndexFactoryImpl
extends DSpaceObjectIndexFactoryImpl<IndexableCollection, Collection>
implements CollectionIndexFactory {
    @Autowired
    protected CollectionService collectionService;
    @Autowired
    protected CommunityService communityService;

    @Override
    public Iterator<IndexableCollection> findAll(Context context) throws SQLException {
        final Iterator<Collection> collections = this.collectionService.findAll(context).iterator();
        return new Iterator<IndexableCollection>(){

            @Override
            public boolean hasNext() {
                return collections.hasNext();
            }

            @Override
            public IndexableCollection next() {
                return new IndexableCollection((Collection)collections.next());
            }
        };
    }

    @Override
    public String getType() {
        return IndexableCollection.TYPE;
    }

    @Override
    public SolrInputDocument buildDocument(Context context, IndexableCollection indexableCollection) throws IOException, SQLException {
        SolrInputDocument doc = super.buildDocument(context, indexableCollection);
        Collection collection = (Collection)indexableCollection.getIndexedObject();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration(collection);
        DiscoveryHitHighlightingConfiguration highlightingConfiguration = discoveryConfiguration.getHitHighlightingConfiguration();
        ArrayList<String> highlightedMetadataFields = new ArrayList<String>();
        if (highlightingConfiguration != null) {
            for (DiscoveryHitHighlightFieldConfiguration configuration : highlightingConfiguration.getMetadataFields()) {
                highlightedMetadataFields.add(configuration.getField());
            }
        }
        String description = this.collectionService.getMetadata(collection, "introductory_text");
        String description_abstract = this.collectionService.getMetadata(collection, "short_description");
        String description_table = this.collectionService.getMetadata(collection, "side_bar_text");
        String provenance = this.collectionService.getMetadata(collection, "provenance_description");
        String rights = this.collectionService.getMetadata(collection, "copyright_text");
        String rights_license = this.collectionService.getMetadata(collection, "license");
        String title = this.collectionService.getMetadata(collection, "name");
        List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(collection.getType());
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description", description);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.abstract", description_abstract);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.description.tableofcontents", description_table);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.provenance", provenance);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.rights", rights);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.rights.license", rights_license);
        this.addContainerMetadataField(doc, highlightedMetadataFields, toIgnoreMetadataFields, "dc.title", title);
        return doc;
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof Collection;
    }

    @Override
    public List getIndexableObjects(Context context, Collection object) {
        return Arrays.asList(new IndexableCollection(object));
    }

    @Override
    public Optional<IndexableCollection> findIndexableObject(Context context, String id) throws SQLException {
        Collection collection = (Collection)this.collectionService.find(context, UUID.fromString(id));
        return collection == null ? Optional.empty() : Optional.of(new IndexableCollection(collection));
    }

    @Override
    public List<String> getLocations(Context context, IndexableCollection indexableCollection) throws SQLException {
        return this.getCollectionLocations(context, (Collection)indexableCollection.getIndexedObject());
    }

    @Override
    public List<String> getCollectionLocations(Context context, Collection collection) throws SQLException {
        ArrayList<String> locations = new ArrayList<String>();
        List<Community> communities = ContentServiceFactory.getInstance().getCommunityService().getAllParents(context, collection);
        for (Community community : communities) {
            locations.add("m" + community.getID());
        }
        return locations;
    }
}

