/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.analytics.Analytics;
import java.io.File;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.services.factory.DSpaceServicesFactory;

public class GoogleAccount {
    private String applicationName = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("google-analytics.application.name");
    private String tableId = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("google-analytics.table.id");
    private String emailAddress = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("google-analytics.account.email");
    private String certificateLocation = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("google-analytics.certificate.location");
    private JsonFactory jsonFactory = JacksonFactory.getDefaultInstance();
    private HttpTransport httpTransport;
    private Credential credential;
    private Analytics client;
    private static volatile GoogleAccount uniqueInstance;
    private static Logger log;

    private GoogleAccount() {
        try {
            this.httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            this.credential = this.authorize();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initialising Google Analytics client", e);
        }
        this.client = new Analytics.Builder(this.httpTransport, this.jsonFactory, (HttpRequestInitializer)this.credential).setApplicationName(this.applicationName).build();
        log.info("Google Analytics client successfully initialised");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GoogleAccount getInstance() {
        if (uniqueInstance != null) return uniqueInstance;
        Class<GoogleAccount> clazz = GoogleAccount.class;
        synchronized (GoogleAccount.class) {
            if (uniqueInstance != null) return uniqueInstance;
            uniqueInstance = new GoogleAccount();
            // ** MonitorExit[var0] (shouldn't be in output)
            return uniqueInstance;
        }
    }

    private Credential authorize() throws Exception {
        HashSet<String> scopes = new HashSet<String>();
        scopes.add("https://www.googleapis.com/auth/analytics");
        scopes.add("https://www.googleapis.com/auth/analytics.edit");
        scopes.add("https://www.googleapis.com/auth/analytics.manage.users");
        scopes.add("https://www.googleapis.com/auth/analytics.provision");
        scopes.add("https://www.googleapis.com/auth/analytics.readonly");
        this.credential = new GoogleCredential.Builder().setTransport(this.httpTransport).setJsonFactory(this.jsonFactory).setServiceAccountId(this.emailAddress).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(new File(this.certificateLocation)).build();
        return this.credential;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getCertificateLocation() {
        return this.certificateLocation;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public Analytics getClient() {
        return this.client;
    }

    static {
        log = LogManager.getLogger(GoogleAccount.class);
    }
}

