/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.ProcessStatus;
import org.dspace.content.dao.ProcessDAO;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.Process;
import org.dspace.scripts.service.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessServiceImpl
implements ProcessService {
    private static final Logger log = LogManager.getLogger(ProcessService.class);
    @Autowired
    private ProcessDAO processDAO;
    @Autowired
    private BitstreamService bitstreamService;
    @Autowired
    private BitstreamFormatService bitstreamFormatService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private MetadataFieldService metadataFieldService;

    @Override
    public Process create(Context context, EPerson ePerson, String scriptName, List<DSpaceCommandLineParameter> parameters) throws SQLException {
        Process process = new Process();
        process.setEPerson(ePerson);
        process.setName(scriptName);
        process.setParameters(DSpaceCommandLineParameter.concatenate(parameters));
        process.setCreationTime(new Date());
        Process createdProcess = this.processDAO.create(context, process);
        log.info(org.dspace.core.LogManager.getHeader(context, "process_create", "Process has been created for eperson with email " + ePerson.getEmail() + " with ID " + createdProcess.getID() + " and scriptName " + scriptName + " and parameters " + parameters));
        return createdProcess;
    }

    @Override
    public Process find(Context context, int processId) throws SQLException {
        return (Process)this.processDAO.findByID(context, Process.class, processId);
    }

    @Override
    public List<Process> findAll(Context context) throws SQLException {
        return this.processDAO.findAll(context, Process.class);
    }

    @Override
    public List<Process> findAll(Context context, int limit, int offset) throws SQLException {
        return this.processDAO.findAll(context, limit, offset);
    }

    @Override
    public List<Process> findAllSortByScript(Context context) throws SQLException {
        return this.processDAO.findAllSortByScript(context);
    }

    @Override
    public List<Process> findAllSortByStartTime(Context context) throws SQLException {
        List<Process> processes = this.findAll(context);
        Comparator<Process> comparing = Comparator.comparing(Process::getStartTime, Comparator.nullsLast(Comparator.naturalOrder()));
        comparing = comparing.thenComparing(Process::getID);
        processes.sort(comparing);
        return processes;
    }

    @Override
    public void start(Context context, Process process) throws SQLException {
        process.setProcessStatus(ProcessStatus.RUNNING);
        process.setStartTime(new Date());
        this.update(context, process);
        log.info(org.dspace.core.LogManager.getHeader(context, "process_start", "Process with ID " + process.getID() + " and name " + process.getName() + " has started"));
    }

    @Override
    public void fail(Context context, Process process) throws SQLException {
        process.setProcessStatus(ProcessStatus.FAILED);
        process.setFinishedTime(new Date());
        this.update(context, process);
        log.info(org.dspace.core.LogManager.getHeader(context, "process_fail", "Process with ID " + process.getID() + " and name " + process.getName() + " has failed"));
    }

    @Override
    public void complete(Context context, Process process) throws SQLException {
        process.setProcessStatus(ProcessStatus.COMPLETED);
        process.setFinishedTime(new Date());
        this.update(context, process);
        log.info(org.dspace.core.LogManager.getHeader(context, "process_complete", "Process with ID " + process.getID() + " and name " + process.getName() + " has been completed"));
    }

    @Override
    public void appendFile(Context context, Process process, InputStream is, String type, String fileName) throws IOException, SQLException, AuthorizeException {
        Bitstream bitstream = this.bitstreamService.create(context, is);
        if (this.getBitstream(context, process, type) != null) {
            throw new IllegalArgumentException("Cannot create another file of type: " + type + " for this process with id: " + process.getID());
        }
        bitstream.setName(context, fileName);
        this.bitstreamService.setFormat(context, bitstream, this.bitstreamFormatService.guessFormat(context, bitstream));
        MetadataField dspaceProcessFileTypeField = this.metadataFieldService.findByString(context, "dspace.process.filetype", '.');
        this.bitstreamService.addMetadata(context, bitstream, dspaceProcessFileTypeField, null, type);
        this.authorizeService.addPolicy(context, (DSpaceObject)bitstream, 0, context.getCurrentUser());
        this.authorizeService.addPolicy(context, (DSpaceObject)bitstream, 1, context.getCurrentUser());
        this.authorizeService.addPolicy(context, (DSpaceObject)bitstream, 2, context.getCurrentUser());
        this.bitstreamService.update(context, bitstream);
        process.addBitstream(bitstream);
        this.update(context, process);
    }

    @Override
    public void delete(Context context, Process process) throws SQLException, IOException, AuthorizeException {
        for (Bitstream bitstream : ListUtils.emptyIfNull(process.getBitstreams())) {
            this.bitstreamService.delete(context, bitstream);
        }
        this.processDAO.delete(context, process);
        log.info(org.dspace.core.LogManager.getHeader(context, "process_delete", "Process with ID " + process.getID() + " and name " + process.getName() + " has been deleted"));
    }

    @Override
    public void update(Context context, Process process) throws SQLException {
        this.processDAO.save(context, process);
    }

    @Override
    public List<DSpaceCommandLineParameter> getParameters(Process process) {
        if (StringUtils.isBlank((CharSequence)process.getParameters())) {
            return Collections.emptyList();
        }
        String[] parameterArray = process.getParameters().split(Pattern.quote(DSpaceCommandLineParameter.SEPARATOR));
        ArrayList<DSpaceCommandLineParameter> parameterList = new ArrayList<DSpaceCommandLineParameter>();
        for (String parameter : parameterArray) {
            parameterList.add(new DSpaceCommandLineParameter(parameter));
        }
        return parameterList;
    }

    @Override
    public Bitstream getBitstreamByName(Context context, Process process, String bitstreamName) {
        for (Bitstream bitstream : this.getBitstreams(context, process)) {
            if (!StringUtils.equals((CharSequence)bitstream.getName(), (CharSequence)bitstreamName)) continue;
            return bitstream;
        }
        return null;
    }

    @Override
    public Bitstream getBitstream(Context context, Process process, String type) {
        List<Bitstream> allBitstreams = process.getBitstreams();
        if (type == null) {
            return null;
        }
        if (allBitstreams != null) {
            for (Bitstream bitstream : allBitstreams) {
                if (!StringUtils.equals((CharSequence)this.bitstreamService.getMetadata(bitstream, "dspace.process.filetype"), (CharSequence)type)) continue;
                return bitstream;
            }
        }
        return null;
    }

    @Override
    public List<Bitstream> getBitstreams(Context context, Process process) {
        return process.getBitstreams();
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.processDAO.countRows(context);
    }

    @Override
    public List<String> getFileTypesForProcessBitstreams(Context context, Process process) {
        List<Bitstream> list = this.getBitstreams(context, process);
        HashSet<String> fileTypesSet = new HashSet<String>();
        for (Bitstream bitstream : list) {
            List<MetadataValue> metadata = this.bitstreamService.getMetadata(bitstream, "dspace.process.filetype", "*");
            if (metadata == null || metadata.isEmpty()) continue;
            fileTypesSet.add(metadata.get(0).getValue());
        }
        return new ArrayList<String>(fileTypesSet);
    }
}

