/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.eperson.EPerson;
import org.dspace.services.model.Event;
import org.dspace.statistics.service.SolrLoggerService;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.dspace.usage.UsageSearchEvent;
import org.dspace.usage.UsageWorkflowEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrLoggerUsageEventListener
extends AbstractUsageEventListener {
    private static Logger log = LogManager.getLogger(SolrLoggerUsageEventListener.class);
    protected SolrLoggerService solrLoggerService;

    @Autowired
    public void setSolrLoggerService(SolrLoggerService solrLoggerService) {
        this.solrLoggerService = solrLoggerService;
    }

    public void receiveEvent(Event event) {
        if (event instanceof UsageEvent) {
            log.debug("Usage event received " + event.getName());
            try {
                EPerson currentUser;
                UsageEvent ue = (UsageEvent)event;
                EPerson ePerson = currentUser = ue.getContext() == null ? null : ue.getContext().getCurrentUser();
                if (UsageEvent.Action.VIEW == ue.getAction()) {
                    if (ue.getRequest() != null) {
                        this.solrLoggerService.postView(ue.getObject(), ue.getRequest(), currentUser);
                    } else {
                        this.solrLoggerService.postView(ue.getObject(), ue.getIp(), ue.getUserAgent(), ue.getXforwardedfor(), currentUser);
                    }
                } else if (UsageEvent.Action.SEARCH == ue.getAction()) {
                    UsageSearchEvent usageSearchEvent = (UsageSearchEvent)ue;
                    LinkedList<String> queries = new LinkedList<String>();
                    queries.add(usageSearchEvent.getQuery());
                    this.solrLoggerService.postSearch(usageSearchEvent.getObject(), usageSearchEvent.getRequest(), currentUser, queries, usageSearchEvent.getPage().getSize(), usageSearchEvent.getSort().getBy(), usageSearchEvent.getSort().getOrder(), usageSearchEvent.getPage().getNumber(), usageSearchEvent.getScope());
                } else if (UsageEvent.Action.WORKFLOW == ue.getAction()) {
                    UsageWorkflowEvent usageWorkflowEvent = (UsageWorkflowEvent)ue;
                    this.solrLoggerService.postWorkflow(usageWorkflowEvent);
                }
            }
            catch (Exception e) {
                log.error("Error processing/logging UsageEvent {}", (Object)event.getName(), (Object)e);
            }
        }
    }
}

