/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.util.XMLUtils;
import org.dspace.submit.util.SubmissionLookupPublication;
import org.w3c.dom.Element;

public class CrossRefUtils {
    private CrossRefUtils() {
    }

    public static Record convertCrossRefDomToRecord(Element dataRoot) {
        LinkedList<StringValue> values;
        String publicationType;
        String articleTitle;
        String volumeTitle;
        String journalTitle;
        String seriesTitle;
        String lastPage;
        String firstPage;
        String year;
        String issue;
        String volume;
        String itemType;
        SubmissionLookupPublication record = new SubmissionLookupPublication("");
        String status = dataRoot.getAttribute("status");
        if (!"resolved".equals(status)) {
            String msg = XMLUtils.getElementValue(dataRoot, "msg");
            String exMsg = status + " - " + msg;
            throw new RuntimeException(exMsg);
        }
        String doi = XMLUtils.getElementValue(dataRoot, "doi");
        if (doi != null) {
            record.addValue("doi", (Value)new StringValue(doi));
        }
        String string = itemType = doi != null ? XMLUtils.getElementAttribute(dataRoot, "doi", "type") : "unspecified";
        if (itemType != null) {
            record.addValue("doiType", (Value)new StringValue(itemType));
        }
        List<Element> identifier = XMLUtils.getElementList(dataRoot, "issn");
        for (Element element : identifier) {
            if ("print".equalsIgnoreCase(element.getAttribute("type")) || StringUtils.isNotBlank((CharSequence)element.getAttribute("type"))) {
                String issn = element.getTextContent().trim();
                if (issn == null) continue;
                record.addValue("printISSN", (Value)new StringValue(issn));
                continue;
            }
            String eissn = element.getTextContent().trim();
            if (eissn == null) continue;
            record.addValue("electronicISSN", (Value)new StringValue(eissn));
        }
        List<Element> identifierisbn = XMLUtils.getElementList(dataRoot, "isbn");
        for (Element ident : identifierisbn) {
            if ("print".equalsIgnoreCase(ident.getAttribute("type")) || StringUtils.isNotBlank((CharSequence)ident.getAttribute("type"))) {
                String issn = ident.getTextContent().trim();
                if (issn == null) continue;
                record.addValue("printISBN", (Value)new StringValue(issn));
                continue;
            }
            String eissn = ident.getTextContent().trim();
            if (eissn == null) continue;
            record.addValue("electronicISBN", (Value)new StringValue(eissn));
        }
        String string2 = XMLUtils.getElementValue(dataRoot, "editionNumber");
        if (string2 != null) {
            record.addValue("editionNumber", (Value)new StringValue(string2));
        }
        if ((volume = XMLUtils.getElementValue(dataRoot, "volume")) != null) {
            record.addValue("volume", (Value)new StringValue(volume));
        }
        if ((issue = XMLUtils.getElementValue(dataRoot, "issue")) != null) {
            record.addValue("issue", (Value)new StringValue(issue));
        }
        if ((year = XMLUtils.getElementValue(dataRoot, "year")) != null) {
            record.addValue("year", (Value)new StringValue(year));
        }
        if ((firstPage = XMLUtils.getElementValue(dataRoot, "first_page")) != null) {
            record.addValue("firstPage", (Value)new StringValue(firstPage));
        }
        if ((lastPage = XMLUtils.getElementValue(dataRoot, "last_page")) != null) {
            record.addValue("lastPage", (Value)new StringValue(lastPage));
        }
        if ((seriesTitle = XMLUtils.getElementValue(dataRoot, "series_title")) != null) {
            record.addValue("seriesTitle", (Value)new StringValue(seriesTitle));
        }
        if ((journalTitle = XMLUtils.getElementValue(dataRoot, "journal_title")) != null) {
            record.addValue("journalTitle", (Value)new StringValue(journalTitle));
        }
        if ((volumeTitle = XMLUtils.getElementValue(dataRoot, "volume_title")) != null) {
            record.addValue("volumeTitle", (Value)new StringValue(volumeTitle));
        }
        if ((articleTitle = XMLUtils.getElementValue(dataRoot, "article_title")) != null) {
            record.addValue("articleTitle", (Value)new StringValue(articleTitle));
        }
        if ((publicationType = XMLUtils.getElementValue(dataRoot, "pubblication_type")) != null) {
            record.addValue("publicationType", (Value)new StringValue(publicationType));
        }
        LinkedList<String[]> authors = new LinkedList<String[]>();
        LinkedList<String[]> editors = new LinkedList<String[]>();
        LinkedList<String[]> translators = new LinkedList<String[]>();
        LinkedList<String[]> chairs = new LinkedList<String[]>();
        List<Element> contributors = XMLUtils.getElementList(dataRoot, "contributors");
        List<Element> contributor = null;
        if (contributors != null && contributors.size() > 0) {
            contributor = XMLUtils.getElementList(contributors.get(0), "contributor");
            for (Element contrib : contributor) {
                String givenName = XMLUtils.getElementValue(contrib, "given_name");
                String surname = XMLUtils.getElementValue(contrib, "surname");
                if ("editor".equalsIgnoreCase(contrib.getAttribute("contributor_role"))) {
                    editors.add(new String[]{givenName, surname});
                    continue;
                }
                if ("chair".equalsIgnoreCase(contrib.getAttribute("contributor_role"))) {
                    chairs.add(new String[]{givenName, surname});
                    continue;
                }
                if ("translator".equalsIgnoreCase(contrib.getAttribute("contributor_role"))) {
                    translators.add(new String[]{givenName, surname});
                    continue;
                }
                authors.add(new String[]{givenName, surname});
            }
        }
        if (authors.size() > 0) {
            values = new LinkedList<StringValue>();
            for (String[] sArray : authors) {
                values.add(new StringValue(sArray[1] + ", " + sArray[0]));
            }
            record.addField("authors", values);
        }
        if (editors.size() > 0) {
            values = new LinkedList();
            for (String[] sArray : editors) {
                values.add(new StringValue(sArray[1] + ", " + sArray[0]));
            }
            record.addField("editors", values);
        }
        if (translators.size() > 0) {
            values = new LinkedList();
            for (String[] sArray : translators) {
                values.add(new StringValue(sArray[1] + ", " + sArray[0]));
            }
            record.addField("translators", values);
        }
        if (chairs.size() > 0) {
            values = new LinkedList();
            for (String[] sArray : chairs) {
                values.add(new StringValue(sArray[1] + ", " + sArray[0]));
            }
            record.addField("chairs", values);
        }
        return record;
    }
}

