/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.mail.MessagingException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.curate.service.WorkflowCuratorService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageWorkflowEvent;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.TaskListItem;
import org.dspace.workflowbasic.service.BasicWorkflowItemService;
import org.dspace.workflowbasic.service.BasicWorkflowService;
import org.dspace.workflowbasic.service.TaskListItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class BasicWorkflowServiceImpl
implements BasicWorkflowService {
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected InstallItemService installItemService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected TaskListItemService taskListItemService;
    @Autowired(required=true)
    protected WorkflowCuratorService workflowCuratorService;
    @Autowired(required=true)
    protected BasicWorkflowItemService workflowItemService;
    @Autowired(required=true)
    protected WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    protected final String[] workflowText = new String[]{"SUBMIT", "STEP1POOL", "STEP1", "STEP2POOL", "STEP2", "STEP3POOL", "STEP3", "ARCHIVE"};
    protected Map<UUID, Boolean> noEMail = new HashMap<UUID, Boolean>();
    private final Logger log = LogManager.getLogger(BasicWorkflowServiceImpl.class);

    protected BasicWorkflowServiceImpl() {
    }

    @Override
    public int getWorkflowID(String state) {
        for (int i = 0; i < this.workflowText.length; ++i) {
            if (!state.equalsIgnoreCase(this.workflowText[i])) continue;
            return i;
        }
        return -1;
    }

    protected void grantReviewerPolicies(Context context, BasicWorkflowItem wfi, EPerson reviewer) throws SQLException, AuthorizeException {
        Bundle originalBundle;
        if (reviewer == null) {
            return;
        }
        Item item = wfi.getItem();
        try {
            originalBundle = this.itemService.getBundles(item, "ORIGINAL").get(0);
        }
        catch (IndexOutOfBoundsException ex) {
            originalBundle = null;
        }
        for (int action : new int[]{0, 1, 3, 4, 2}) {
            this.authorizeService.addPolicy(context, (DSpaceObject)item, action, reviewer, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (originalBundle != null) {
            this.authorizeService.addPolicy(context, (DSpaceObject)originalBundle, 0, reviewer, ResourcePolicy.TYPE_WORKFLOW);
            boolean editFiles = this.configurationService.getBooleanProperty("workflow.reviewer.file-edit", false);
            if (editFiles) {
                this.authorizeService.addPolicy(context, (DSpaceObject)originalBundle, 3, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                this.authorizeService.addPolicy(context, (DSpaceObject)originalBundle, 4, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                this.authorizeService.addPolicy(context, (DSpaceObject)originalBundle, 1, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                this.authorizeService.addPolicy(context, (DSpaceObject)originalBundle, 2, reviewer, ResourcePolicy.TYPE_WORKFLOW);
            }
            for (Bitstream bitstream : originalBundle.getBitstreams()) {
                this.authorizeService.addPolicy(context, (DSpaceObject)bitstream, 0, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                if (!editFiles) continue;
                this.authorizeService.addPolicy(context, (DSpaceObject)bitstream, 1, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                this.authorizeService.addPolicy(context, (DSpaceObject)bitstream, 2, reviewer, ResourcePolicy.TYPE_WORKFLOW);
            }
        }
    }

    protected void revokeReviewerPolicies(Context context, Item item) throws SQLException, AuthorizeException {
        Bundle originalBundle;
        try {
            originalBundle = this.itemService.getBundles(item, "ORIGINAL").get(0);
        }
        catch (IndexOutOfBoundsException ex) {
            originalBundle = null;
        }
        if (originalBundle != null) {
            for (Bitstream bitstream : originalBundle.getBitstreams()) {
                this.authorizeService.removeAllPoliciesByDSOAndType(context, bitstream, ResourcePolicy.TYPE_WORKFLOW);
            }
            this.authorizeService.removeAllPoliciesByDSOAndType(context, originalBundle, ResourcePolicy.TYPE_WORKFLOW);
        }
        this.authorizeService.removeAllPoliciesByDSOAndType(context, item, ResourcePolicy.TYPE_WORKFLOW);
    }

    @Override
    public BasicWorkflowItem start(Context context, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException {
        Item myitem = wsi.getItem();
        Collection collection = wsi.getCollection();
        this.log.info(org.dspace.core.LogManager.getHeader(context, "start_workflow", "workspace_item_id=" + wsi.getID() + "item_id=" + myitem.getID() + "collection_id=" + collection.getID()));
        this.recordStart(context, myitem);
        BasicWorkflowItem wfi = (BasicWorkflowItem)this.workflowItemService.create(context, myitem, collection);
        wfi.setMultipleFiles(wsi.hasMultipleFiles());
        wfi.setMultipleTitles(wsi.hasMultipleTitles());
        wfi.setPublishedBefore(wsi.isPublishedBefore());
        this.workspaceItemService.deleteWrapper(context, wsi);
        wfi.setState(0);
        this.advance(context, wfi, null);
        return wfi;
    }

    @Override
    public BasicWorkflowItem startWithoutNotify(Context c, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException {
        this.noEMail.put(wsi.getItem().getID(), Boolean.TRUE);
        return this.start(c, wsi);
    }

    @Override
    public List<BasicWorkflowItem> getOwnedTasks(Context context, EPerson e) throws SQLException {
        return this.workflowItemService.findByOwner(context, e);
    }

    @Override
    public List<BasicWorkflowItem> getPooledTasks(Context context, EPerson e) throws SQLException {
        return this.workflowItemService.findPooledTasks(context, e);
    }

    @Override
    public void claim(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, IOException, AuthorizeException {
        int taskstate = workflowItem.getState();
        switch (taskstate) {
            case 1: {
                this.authorizeService.authorizeAction(context, e, workflowItem.getCollection(), 5, true);
                this.doState(context, workflowItem, 2, e);
                break;
            }
            case 3: {
                this.authorizeService.authorizeAction(context, e, workflowItem.getCollection(), 6, true);
                this.doState(context, workflowItem, 4, e);
                break;
            }
            case 5: {
                this.authorizeService.authorizeAction(context, e, workflowItem.getCollection(), 7, true);
                this.doState(context, workflowItem, 6, e);
                break;
            }
            default: {
                throw new IllegalArgumentException("Workflow Step " + taskstate + " is out of range.");
            }
        }
        this.log.info(org.dspace.core.LogManager.getHeader(context, "claim_task", "workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID() + "newowner_id=" + workflowItem.getOwner().getID() + "old_state=" + taskstate + "new_state=" + workflowItem.getState()));
    }

    @Override
    public void advance(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, IOException, AuthorizeException {
        this.advance(context, workflowItem, e, true, true);
    }

    @Override
    public boolean advance(Context context, BasicWorkflowItem workflowItem, EPerson e, boolean curate, boolean record) throws SQLException, IOException, AuthorizeException {
        int taskstate = workflowItem.getState();
        boolean archived = false;
        if (curate && this.workflowCuratorService.needsCuration(workflowItem) && !this.workflowCuratorService.doCuration(context, workflowItem)) {
            this.log.info(org.dspace.core.LogManager.getHeader(context, "advance_workflow", "workflow_item_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID() + ",collection_id=" + workflowItem.getCollection().getID() + ",old_state=" + taskstate + ",doCuration=false"));
            return false;
        }
        switch (taskstate) {
            case 0: {
                archived = this.doState(context, workflowItem, 1, e);
                break;
            }
            case 2: {
                if (workflowItem.getCollection().getWorkflowStep1(context) != null && e != null) {
                    this.authorizeService.authorizeAction(context, e, workflowItem.getCollection(), 5, true);
                }
                if (record) {
                    this.recordApproval(context, workflowItem, e);
                }
                archived = this.doState(context, workflowItem, 3, e);
                break;
            }
            case 4: {
                if (workflowItem.getCollection().getWorkflowStep2(context) != null && e != null) {
                    this.authorizeService.authorizeAction(context, e, workflowItem.getCollection(), 6, true);
                }
                if (record) {
                    this.recordApproval(context, workflowItem, e);
                }
                archived = this.doState(context, workflowItem, 5, e);
                break;
            }
            case 6: {
                if (workflowItem.getCollection().getWorkflowStep3(context) != null && e != null) {
                    this.authorizeService.authorizeAction(context, e, workflowItem.getCollection(), 7, true);
                }
                archived = this.doState(context, workflowItem, 7, e);
                break;
            }
        }
        this.log.info(org.dspace.core.LogManager.getHeader(context, "advance_workflow", "workflow_item_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID() + ",collection_id=" + workflowItem.getCollection().getID() + ",old_state=" + taskstate + ",new_state=" + workflowItem.getState()));
        return archived;
    }

    @Override
    public void unclaim(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, IOException, AuthorizeException {
        int taskstate = workflowItem.getState();
        switch (taskstate) {
            case 2: {
                this.doState(context, workflowItem, 1, e);
                break;
            }
            case 4: {
                this.doState(context, workflowItem, 3, e);
                break;
            }
            case 6: {
                this.doState(context, workflowItem, 5, e);
                break;
            }
            default: {
                throw new IllegalStateException("WorkflowItem reach an unknown state.");
            }
        }
        this.log.info(org.dspace.core.LogManager.getHeader(context, "unclaim_workflow", "workflow_item_id=" + workflowItem.getID() + ",item_id=" + workflowItem.getItem().getID() + ",collection_id=" + workflowItem.getCollection().getID() + ",old_state=" + taskstate + ",new_state=" + workflowItem.getState()));
    }

    @Override
    public WorkspaceItem abort(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, AuthorizeException, IOException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to abort a workflow");
        }
        this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
        this.log.info(org.dspace.core.LogManager.getHeader(context, "abort_workflow", "workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID() + "eperson_id=" + e.getID()));
        return this.returnToWorkspace(context, workflowItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doState(Context context, BasicWorkflowItem workflowItem, int newstate, EPerson newowner) throws SQLException, IOException, AuthorizeException {
        Collection collection = workflowItem.getCollection();
        int oldState = workflowItem.getState();
        EPerson oldOwner = workflowItem.getOwner();
        switch (newstate) {
            case 1: {
                return this.pool(context, workflowItem, 1);
            }
            case 2: {
                this.assignToReviewer(context, workflowItem, 1, newowner);
                return false;
            }
            case 3: {
                return this.pool(context, workflowItem, 2);
            }
            case 4: {
                this.assignToReviewer(context, workflowItem, 2, newowner);
                return false;
            }
            case 5: {
                return this.pool(context, workflowItem, 3);
            }
            case 6: {
                this.assignToReviewer(context, workflowItem, 3, newowner);
                return false;
            }
            case 7: {
                this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
                collection = workflowItem.getCollection();
                Item myitem = this.archive(context, workflowItem);
                this.notifyOfArchive(context, myitem, collection);
                try {
                    context.turnOffAuthorisationSystem();
                    this.revokeReviewerPolicies(context, myitem);
                }
                finally {
                    context.restoreAuthSystemState();
                }
                this.logWorkflowEvent(context, workflowItem.getItem(), workflowItem, context.getCurrentUser(), newstate, newowner, collection, oldState, null);
                return true;
            }
        }
        throw new IllegalArgumentException("BasicWorkflowService cannot handle workflowItemState " + newstate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assignToReviewer(Context context, BasicWorkflowItem workflowItem, int step, EPerson newowner) throws AuthorizeException, SQLException {
        int correspondingAction;
        int newState;
        Collection collection = workflowItem.getCollection();
        if (step == 1) {
            newState = 2;
            correspondingAction = 5;
        } else if (step == 2) {
            newState = 4;
            correspondingAction = 6;
        } else if (step == 3) {
            newState = 6;
            correspondingAction = 7;
        } else {
            throw new IllegalArgumentException("Got a task to pool with an improperly or unknown state.");
        }
        int oldState = workflowItem.getState();
        if (this.collectionService.getWorkflowGroup(context, collection, step) != null && !this.groupService.isEmpty(this.collectionService.getWorkflowGroup(context, collection, step)) && newowner != null) {
            this.authorizeService.authorizeAction(context, newowner, collection, correspondingAction, true);
        }
        try {
            context.turnOffAuthorisationSystem();
            this.revokeReviewerPolicies(context, workflowItem.getItem());
            this.grantReviewerPolicies(context, workflowItem, newowner);
        }
        finally {
            context.restoreAuthSystemState();
        }
        this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
        workflowItem.setState(newState);
        workflowItem.setOwner(newowner);
        this.logWorkflowEvent(context, workflowItem.getItem(), workflowItem, context.getCurrentUser(), newState, newowner, collection, oldState, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pool(Context context, BasicWorkflowItem workflowItem, int step) throws SQLException, AuthorizeException, IOException {
        int correspondingState;
        int newState;
        Collection collection = workflowItem.getCollection();
        if (step == 1) {
            newState = 1;
            correspondingState = 2;
        } else if (step == 2) {
            newState = 3;
            correspondingState = 4;
        } else if (step == 3) {
            newState = 5;
            correspondingState = 6;
        } else {
            throw new IllegalArgumentException("Got a task to pool with an improperly or unknown state.");
        }
        int oldState = workflowItem.getState();
        EPerson oldOwner = workflowItem.getOwner();
        workflowItem.setOwner(null);
        Group workflowStepGroup = this.collectionService.getWorkflowGroup(context, collection, step);
        if (workflowStepGroup != null && !this.groupService.isEmpty(workflowStepGroup)) {
            workflowItem.setState(newState);
            try {
                Bundle originalBundle;
                context.turnOffAuthorisationSystem();
                this.revokeReviewerPolicies(context, workflowItem.getItem());
                this.authorizeService.addPolicy(context, (DSpaceObject)workflowItem.getItem(), 0, workflowStepGroup, ResourcePolicy.TYPE_WORKFLOW);
                try {
                    originalBundle = this.itemService.getBundles(workflowItem.getItem(), "ORIGINAL").get(0);
                }
                catch (IndexOutOfBoundsException ex) {
                    originalBundle = null;
                }
                if (originalBundle != null) {
                    this.authorizeService.addPolicy(context, (DSpaceObject)originalBundle, 0, workflowStepGroup, ResourcePolicy.TYPE_WORKFLOW);
                    for (Bitstream bitstream : originalBundle.getBitstreams()) {
                        this.authorizeService.addPolicy(context, (DSpaceObject)bitstream, 0, workflowStepGroup, ResourcePolicy.TYPE_WORKFLOW);
                    }
                }
            }
            finally {
                context.restoreAuthSystemState();
            }
            List<EPerson> epa = this.groupService.allMembers(context, workflowStepGroup);
            this.createTasks(context, workflowItem, epa);
            if (this.configurationService.getBooleanProperty("workflow.notify.returned.tasks", true) || oldState != correspondingState || oldOwner == null) {
                this.notifyGroupOfTask(context, workflowItem, workflowStepGroup, epa);
            }
            this.logWorkflowEvent(context, workflowItem.getItem(), workflowItem, context.getCurrentUser(), newState, null, collection, oldState, workflowStepGroup);
            return false;
        }
        workflowItem.setState(correspondingState);
        boolean archived = this.advance(context, workflowItem, null, true, false);
        if (archived) {
            try {
                context.turnOffAuthorisationSystem();
                this.revokeReviewerPolicies(context, workflowItem.getItem());
            }
            finally {
                context.restoreAuthSystemState();
            }
        }
        return archived;
    }

    protected void logWorkflowEvent(Context context, Item item, BasicWorkflowItem workflowItem, EPerson actor, int newstate, EPerson newOwner, Collection mycollection, int oldState, Group newOwnerGroup) {
        if (newstate == 7 || newstate == 1 || newstate == 3 || newstate == 5) {
            newOwner = null;
        }
        UsageWorkflowEvent usageWorkflowEvent = new UsageWorkflowEvent(context, item, workflowItem, this.workflowText[newstate], this.workflowText[oldState], mycollection, actor);
        if (newOwner != null) {
            usageWorkflowEvent.setEpersonOwners(newOwner);
        }
        if (newOwnerGroup != null) {
            usageWorkflowEvent.setGroupOwners(newOwnerGroup);
        }
        DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)usageWorkflowEvent);
    }

    @Override
    public String getWorkflowText(int state) {
        if (state > -1 && state < this.workflowText.length) {
            return this.workflowText[state];
        }
        throw new IllegalArgumentException("Invalid workflow state passed");
    }

    protected Item archive(Context context, BasicWorkflowItem workflowItem) throws SQLException, IOException, AuthorizeException {
        Item item = workflowItem.getItem();
        Collection collection = workflowItem.getCollection();
        this.log.info(org.dspace.core.LogManager.getHeader(context, "archive_item", "workflow_item_id=" + workflowItem.getID() + "item_id=" + item.getID() + "collection_id=" + collection.getID()));
        this.installItemService.installItem(context, workflowItem);
        this.log.info(org.dspace.core.LogManager.getHeader(context, "install_item", "workflow_id=" + workflowItem.getID() + ", item_id=" + item.getID() + "handle=FIXME"));
        return item;
    }

    protected void notifyOfArchive(Context context, Item item, Collection coll) throws SQLException, IOException {
        try {
            EPerson ep = item.getSubmitter();
            Locale supportedLocale = I18nUtil.getEPersonLocale(ep);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_archive"));
            String handle = this.handleService.findHandle(context, item);
            String title = item.getName();
            if (StringUtils.isBlank((CharSequence)title)) {
                try {
                    title = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
                }
                catch (MissingResourceException e) {
                    title = "Untitled";
                }
            }
            email.addRecipient(ep.getEmail());
            email.addArgument(title);
            email.addArgument(coll.getName());
            email.addArgument(this.handleService.getCanonicalForm(handle));
            email.send();
        }
        catch (MessagingException e) {
            this.log.warn(org.dspace.core.LogManager.getHeader(context, "notifyOfArchive", "cannot email user; item_id=" + item.getID() + ":  " + e.getMessage()));
        }
    }

    protected WorkspaceItem returnToWorkspace(Context c, BasicWorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        WorkspaceItem workspaceItem = this.workspaceItemService.create(c, wfi);
        workspaceItem.setMultipleFiles(wfi.hasMultipleFiles());
        workspaceItem.setMultipleTitles(wfi.hasMultipleTitles());
        workspaceItem.setPublishedBefore(wfi.isPublishedBefore());
        this.workspaceItemService.update(c, workspaceItem);
        this.log.info(org.dspace.core.LogManager.getHeader(c, "return_to_workspace", "workflow_item_id=" + wfi.getID() + "workspace_item_id=" + workspaceItem.getID()));
        this.workflowItemService.deleteWrapper(c, wfi);
        return workspaceItem;
    }

    @Override
    public WorkspaceItem sendWorkflowItemBackSubmission(Context context, BasicWorkflowItem workflowItem, EPerson ePerson, String provenancePrefix, String rejection_message) throws SQLException, AuthorizeException, IOException {
        int oldState = workflowItem.getState();
        switch (oldState) {
            case 2: {
                this.authorizeService.authorizeActionBoolean(context, ePerson, workflowItem.getItem(), 5, true);
                break;
            }
            case 4: {
                this.authorizeService.authorizeActionBoolean(context, ePerson, workflowItem.getItem(), 6, true);
                break;
            }
            case 6: {
                this.authorizeService.authorizeActionBoolean(context, ePerson, workflowItem.getItem(), 7, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Workflow Step " + oldState + " is out of range.");
            }
        }
        this.taskListItemService.deleteByWorkflowItem(context, workflowItem);
        Item myitem = workflowItem.getItem();
        String now = DCDate.getCurrent().toString();
        String usersName = this.getEPersonName(ePerson);
        String provDescription = "Rejected by " + usersName + ", reason: " + rejection_message + " on " + now + " (GMT) ";
        this.itemService.addMetadata(context, myitem, MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provDescription);
        this.itemService.update(context, myitem);
        WorkspaceItem wsi = this.returnToWorkspace(context, workflowItem);
        this.notifyOfReject(context, workflowItem, ePerson, rejection_message);
        this.log.info(org.dspace.core.LogManager.getHeader(context, "reject_workflow", "workflow_item_id=" + workflowItem.getID() + "item_id=" + workflowItem.getItem().getID() + "collection_id=" + workflowItem.getCollection().getID() + "eperson_id=" + ePerson.getID()));
        this.logWorkflowEvent(context, wsi.getItem(), workflowItem, ePerson, 0, null, wsi.getCollection(), oldState, null);
        return wsi;
    }

    protected void createTasks(Context c, BasicWorkflowItem wi, List<EPerson> epa) throws SQLException {
        for (EPerson anEpa : epa) {
            this.taskListItemService.create(c, wi, anEpa);
        }
    }

    @Override
    public void notifyOfCuration(Context c, BasicWorkflowItem wi, List<EPerson> ePeople, String taskName, String action, String message) throws SQLException, IOException {
        try {
            String title = this.getItemTitle(wi);
            String submitter = this.getSubmitterName(wi);
            Collection coll = wi.getCollection();
            for (EPerson epa : ePeople) {
                Locale supportedLocale = I18nUtil.getEPersonLocale(epa);
                Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "flowtask_notify"));
                email.addArgument(title);
                email.addArgument(coll.getName());
                email.addArgument(submitter);
                email.addArgument(taskName);
                email.addArgument(message);
                email.addArgument(action);
                email.addRecipient(epa.getEmail());
                email.send();
            }
        }
        catch (MessagingException e) {
            this.log.warn(org.dspace.core.LogManager.getHeader(c, "notifyOfCuration", "cannot email users of workflow_item_id " + wi.getID() + ":  " + e.getMessage()));
        }
    }

    protected void notifyGroupOfTask(Context c, BasicWorkflowItem wi, Group mygroup, List<EPerson> epa) throws SQLException, IOException {
        UUID myID = wi.getItem().getID();
        if (this.noEMail.containsKey(myID)) {
            this.noEMail.remove(myID);
        } else {
            try {
                String title = this.getItemTitle(wi);
                String submitter = this.getSubmitterName(wi);
                Collection coll = wi.getCollection();
                String message = "";
                for (EPerson anEpa : epa) {
                    Locale supportedLocale = I18nUtil.getEPersonLocale(anEpa);
                    Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_task"));
                    email.addArgument(title);
                    email.addArgument(coll.getName());
                    email.addArgument(submitter);
                    ResourceBundle messages = ResourceBundle.getBundle("Messages", supportedLocale);
                    switch (wi.getState()) {
                        case 1: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step1");
                            break;
                        }
                        case 3: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step2");
                            break;
                        }
                        case 5: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step3");
                            break;
                        }
                    }
                    email.addArgument(message);
                    email.addArgument(this.getMyDSpaceLink());
                    email.addRecipient(anEpa.getEmail());
                    email.send();
                }
            }
            catch (MessagingException e) {
                String gid = mygroup != null ? String.valueOf(mygroup.getID()) : "none";
                this.log.warn(org.dspace.core.LogManager.getHeader(c, "notifyGroupofTask", "cannot email user group_id=" + gid + " workflow_item_id=" + wi.getID() + ":  " + e.getMessage()));
            }
        }
    }

    @Override
    public String getMyDSpaceLink() {
        return this.configurationService.getProperty("dspace.ui.url") + "/mydspace";
    }

    protected void notifyOfReject(Context context, BasicWorkflowItem workflowItem, EPerson e, String reason) {
        try {
            String title = this.getItemTitle(workflowItem);
            Collection coll = workflowItem.getCollection();
            String rejector = this.getEPersonName(e);
            Locale supportedLocale = I18nUtil.getEPersonLocale(e);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_reject"));
            email.addRecipient(workflowItem.getSubmitter().getEmail());
            email.addArgument(title);
            email.addArgument(coll.getName());
            email.addArgument(rejector);
            email.addArgument(reason);
            email.addArgument(this.getMyDSpaceLink());
            email.send();
        }
        catch (RuntimeException re) {
            this.log.warn(org.dspace.core.LogManager.getHeader(context, "notify_of_reject", "cannot email user eperson_id=" + e.getID() + " eperson_email=" + e.getEmail() + " workflow_item_id=" + workflowItem.getID() + ":  " + re.getMessage()));
            throw re;
        }
        catch (Exception ex) {
            this.log.warn(org.dspace.core.LogManager.getHeader(context, "notify_of_reject", "cannot email user eperson_id=" + e.getID() + " eperson_email=" + e.getEmail() + " workflow_item_id=" + workflowItem.getID() + ":  " + ex.getMessage()));
        }
    }

    @Override
    public String getItemTitle(BasicWorkflowItem wi) throws SQLException {
        Item myitem = wi.getItem();
        String title = myitem.getName();
        if (StringUtils.isNotBlank((CharSequence)title)) {
            return title;
        }
        return I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled ");
    }

    @Override
    public String getSubmitterName(BasicWorkflowItem wi) throws SQLException {
        EPerson e = wi.getSubmitter();
        return this.getEPersonName(e);
    }

    protected String getEPersonName(EPerson e) throws SQLException {
        if (e == null) {
            return "Unknown";
        }
        Object submitter = e.getFullName();
        submitter = (String)submitter + " (" + e.getEmail() + ")";
        return submitter;
    }

    protected void recordApproval(Context context, BasicWorkflowItem workflowItem, EPerson e) throws SQLException, IOException, AuthorizeException {
        Item item = workflowItem.getItem();
        String usersName = this.getEPersonName(e);
        String now = DCDate.getCurrent().toString();
        String provDescription = "Approved for entry into archive by " + usersName + " on " + now + " (GMT) ";
        provDescription = provDescription + this.installItemService.getBitstreamProvenanceMessage(context, item);
        this.itemService.addMetadata(context, item, MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provDescription);
        this.itemService.update(context, item);
    }

    protected void recordStart(Context context, Item myitem) throws SQLException, IOException, AuthorizeException {
        DCDate now = DCDate.getCurrent();
        String provmessage = myitem.getSubmitter() != null ? "Submitted by " + myitem.getSubmitter().getFullName() + " (" + myitem.getSubmitter().getEmail() + ") on " + now.toString() + "\n" : "Submitted by unknown (probably automated) on" + now.toString() + "\n";
        provmessage = provmessage + this.installItemService.getBitstreamProvenanceMessage(context, myitem);
        this.itemService.addMetadata(context, myitem, MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provmessage);
        this.itemService.update(context, myitem);
    }

    @Override
    public void deleteCollection(Context context, Collection collection) throws SQLException, IOException, AuthorizeException {
        this.authorizeService.authorizeAction(context, collection, 1);
        collection.setWorkflowGroup(context, 1, null);
        collection.setWorkflowGroup(context, 2, null);
        collection.setWorkflowGroup(context, 3, null);
        this.workflowItemService.deleteByCollection(context, collection);
    }

    @Override
    public List<String> getEPersonDeleteConstraints(Context context, EPerson ePerson) throws SQLException {
        List<TaskListItem> taskListItems;
        ArrayList<String> resultList = new ArrayList<String>();
        List<BasicWorkflowItem> workflowItems = this.workflowItemService.findByOwner(context, ePerson);
        if (CollectionUtils.isNotEmpty(workflowItems)) {
            resultList.add("workflowitem");
        }
        if (CollectionUtils.isNotEmpty(taskListItems = this.taskListItemService.findByEPerson(context, ePerson))) {
            resultList.add("tasklistitem");
        }
        return resultList;
    }

    @Override
    public Group getWorkflowRoleGroup(Context context, Collection collection, String roleName, Group roleGroup) throws SQLException, AuthorizeException {
        if ("WF_STEP1".equals(roleName)) {
            roleGroup = collection.getWorkflowStep1(context);
            if (roleGroup == null) {
                roleGroup = this.collectionService.createWorkflowGroup(context, collection, 1);
            }
        } else if ("WF_STEP2".equals(roleName)) {
            roleGroup = collection.getWorkflowStep2(context);
            if (roleGroup == null) {
                roleGroup = this.collectionService.createWorkflowGroup(context, collection, 2);
            }
        } else if ("WF_STEP3".equals(roleName) && (roleGroup = collection.getWorkflowStep3(context)) == null) {
            roleGroup = this.collectionService.createWorkflowGroup(context, collection, 3);
        }
        return roleGroup;
    }

    @Override
    public Group createWorkflowRoleGroup(Context context, Collection collection, String roleName) throws AuthorizeException, SQLException {
        return this.getWorkflowRoleGroup(context, collection, roleName, null);
    }

    @Override
    public List<String> getFlywayMigrationLocations() {
        return Collections.emptyList();
    }
}

