/*
 * Decompiled with CFR 0.152.
 */
package org.dspace;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractDSpaceIntegrationTest;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.authority.MockAuthoritySolrServiceImpl;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.discovery.MockSolrSearchCore;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.kernel.ServiceManager;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.MockSolrLoggerServiceImpl;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.jdom.Document;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public class AbstractIntegrationTestWithDatabase
extends AbstractDSpaceIntegrationTest {
    private static final Logger log = LogManager.getLogger(AbstractIntegrationTestWithDatabase.class);
    protected Context context;
    protected EPerson eperson;
    protected EPerson admin;
    protected String password = "mySuperS3cretP4ssW0rd";
    protected Community parentCommunity = null;

    @BeforeClass
    public static void initDatabase() {
        try {
            DatabaseUtils.updateDatabase();
        }
        catch (SQLException se) {
            log.error("Error initializing database", (Throwable)se);
            Assert.fail((String)("Error initializing database: " + se.getMessage() + (String)(se.getCause() == null ? "" : ": " + se.getCause().getMessage())));
        }
    }

    @Before
    public void setUp() throws Exception {
        try {
            this.context = new Context(Context.Mode.BATCH_EDIT);
            this.context.turnOffAuthorisationSystem();
            EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
            this.eperson = ePersonService.findByEmail(this.context, "test@email.com");
            if (this.eperson == null) {
                log.info("Creating initial EPerson (email=test@email.com) for Unit Tests");
                this.eperson = ePersonService.create(this.context);
                this.eperson.setFirstName(this.context, "first");
                this.eperson.setLastName(this.context, "last");
                this.eperson.setEmail("test@email.com");
                this.eperson.setCanLogIn(true);
                this.eperson.setLanguage(this.context, I18nUtil.getDefaultLocale().getLanguage());
                ePersonService.setPassword(this.eperson, this.password);
                ePersonService.update(this.context, (DSpaceObject)this.eperson);
            }
            this.context.setCurrentUser(this.eperson);
            EPersonServiceFactory.getInstance().getGroupService().initDefaultGroupNames(this.context);
            this.admin = ePersonService.findByEmail(this.context, "admin@email.com");
            if (this.admin == null) {
                log.info("Creating initial EPerson (email=admin@email.com) for Unit Tests");
                this.admin = ePersonService.create(this.context);
                this.admin.setFirstName(this.context, "first (admin)");
                this.admin.setLastName(this.context, "last (admin)");
                this.admin.setEmail("admin@email.com");
                this.admin.setCanLogIn(true);
                this.admin.setLanguage(this.context, I18nUtil.getDefaultLocale().getLanguage());
                ePersonService.setPassword(this.admin, this.password);
                ePersonService.update(this.context, (DSpaceObject)this.admin);
                GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
                Group adminGroup = groupService.findByName(this.context, "Administrator");
                groupService.addMember(this.context, adminGroup, this.admin);
            }
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Error creating initial eperson or default groups", (Throwable)ex);
            Assert.fail((String)"Error creating initial eperson or default groups in AbstractUnitTest init()");
        }
        catch (SQLException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            Assert.fail((String)"SQL Error on AbstractUnitTest init()");
        }
    }

    @After
    public void destroy() throws Exception {
        try {
            AbstractBuilder.cleanupObjects();
            this.parentCommunity = null;
            this.cleanupContext();
            ServiceManager serviceManager = DSpaceServicesFactory.getInstance().getServiceManager();
            MockSolrSearchCore searchService = (MockSolrSearchCore)((Object)serviceManager.getServiceByName(null, MockSolrSearchCore.class));
            searchService.reset();
            MockSolrLoggerServiceImpl statisticsService = (MockSolrLoggerServiceImpl)((Object)serviceManager.getServiceByName(null, MockSolrLoggerServiceImpl.class));
            statisticsService.reset();
            MockAuthoritySolrServiceImpl authorityService = (MockAuthoritySolrServiceImpl)((Object)serviceManager.getServiceByName(null, MockAuthoritySolrServiceImpl.class));
            authorityService.reset();
            DSpaceServicesFactory.getInstance().getConfigurationService().reloadConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void cleanupContext() throws SQLException {
        if (this.context != null && this.context.isValid()) {
            this.context.complete();
        }
        if (this.context != null) {
            this.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runDSpaceScript(String ... args) throws Exception {
        try {
            Document commandConfigs = ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl);
            if (args.length < 1) {
                log.error("You must provide at least one command argument");
            }
            TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
            int status = ScriptLauncher.handleScript((String[])args, (Document)commandConfigs, (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
            if (testDSpaceRunnableHandler.getException() != null) {
                throw testDSpaceRunnableHandler.getException();
            }
            int n = status;
            return n;
        }
        finally {
            if (!this.context.isValid()) {
                this.setUp();
            }
        }
    }
}

