/*
 * Decompiled with CFR 0.152.
 */
package org.dspace;

import java.sql.SQLException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractDSpaceTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;

@Ignore
public class AbstractUnitTest
extends AbstractDSpaceTest {
    private static final Logger log = LogManager.getLogger(AbstractUnitTest.class);
    protected Context context;
    protected EPerson eperson;
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    @BeforeClass
    public static void initDatabase() {
        try {
            DatabaseUtils.updateDatabase();
        }
        catch (SQLException se) {
            log.error("Error initializing database", (Throwable)se);
            Assert.fail((String)("Error initializing database: " + se.getMessage() + (String)(se.getCause() == null ? "" : ": " + se.getCause().getMessage())));
        }
    }

    @Before
    public void init() {
        try {
            this.context = new Context(Context.Mode.BATCH_EDIT);
            this.context.turnOffAuthorisationSystem();
            EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
            this.eperson = ePersonService.findByEmail(this.context, "test@email.com");
            if (this.eperson == null) {
                log.info("Creating initial EPerson (email=test@email.com) for Unit Tests");
                this.eperson = ePersonService.create(this.context);
                this.eperson.setFirstName(this.context, "first");
                this.eperson.setLastName(this.context, "last");
                this.eperson.setEmail("test@email.com");
                this.eperson.setCanLogIn(true);
                this.eperson.setLanguage(this.context, I18nUtil.getDefaultLocale().getLanguage());
                ePersonService.update(this.context, (DSpaceObject)this.eperson);
            }
            this.context.setCurrentUser(this.eperson);
            EPersonServiceFactory.getInstance().getGroupService().initDefaultGroupNames(this.context);
            this.context.restoreAuthSystemState();
            AbstractUnitTest.disableSolrIndexing();
        }
        catch (AuthorizeException ex) {
            log.error("Error creating initial eperson or default groups", (Throwable)ex);
            Assert.fail((String)"Error creating initial eperson or default groups in AbstractUnitTest init()");
        }
        catch (SQLException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            Assert.fail((String)"SQL Error on AbstractUnitTest init()");
        }
    }

    @After
    public void destroy() {
        try {
            this.cleanupContext(this.context);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void cleanupContext(Context c) throws SQLException {
        if (c != null && c.isValid()) {
            c.abort();
        }
        if (c != null) {
            c = null;
        }
    }

    protected static void disableSolrIndexing() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        Object[] consumers = configurationService.getArrayProperty("event.dispatcher.default.consumers");
        if (ArrayUtils.contains((Object[])consumers, (Object)"discovery")) {
            consumers = (String[])ArrayUtils.removeElement((Object[])consumers, (Object)"discovery");
            configurationService.setProperty("event.dispatcher.default.consumers", (Object)consumers);
        }
    }
}

