/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.dspace.AbstractIntegrationTest;
import org.dspace.administer.StructBuilder;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;

public class StructBuilderIT
extends AbstractIntegrationTest {
    private static final Logger log = LoggerFactory.getLogger(StructBuilderIT.class);
    private static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private static final String IMPORT_DOCUMENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<import_structure>\n  <community>\n    <name>Top Community 0</name>\n    <description/><intro/><copyright/><sidebar/>    <community>\n      <name>Sub Community 0.0</name>\n      <description/><intro/><copyright/><sidebar/>      <collection>\n        <name>Collection 0.0.0</name>\n        <description/><intro/><copyright/><sidebar/><license/><provenance/>      </collection>\n    </community>\n    <collection>\n      <name>Collection 0.1</name>\n      <description/><intro/><copyright/><sidebar/><license/><provenance/>    </collection>\n  </community>\n</import_structure>\n";
    private static final String EXPORT_DOCUMENT = "<?xml version='1.0' encoding='UTF-8'?>\n<import_structure>\n  <community>\n    <name>Top Community 0</name>    <description/><intro/><copyright/><sidebar/>    <collection>\n      <name>Collection 0.0</name>      <description/><intro/><copyright/><sidebar/><license/>    </collection>\n  </community>\n</import_structure>\n";

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        for (Community community : communityService.findAllTop(this.context)) {
            this.deleteSubCommunities(community);
            communityService.delete(this.context, (DSpaceObject)community);
        }
        this.context.restoreAuthSystemState();
    }

    @After
    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportStructure() throws Exception {
        System.out.println("importStructure");
        ByteArrayOutputStream outputDocument = new ByteArrayOutputStream(IMPORT_DOCUMENT.length() * 2 * 2);
        byte[] inputBytes = IMPORT_DOCUMENT.getBytes(StandardCharsets.UTF_8);
        this.context.turnOffAuthorisationSystem();
        try (ByteArrayInputStream input = new ByteArrayInputStream(inputBytes);){
            StructBuilder.importStructure((Context)this.context, (InputStream)input, (OutputStream)outputDocument);
        }
        catch (IOException | SQLException | ParserConfigurationException | TransformerException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        StreamSource output = new StreamSource(new ByteArrayInputStream(outputDocument.toByteArray()));
        StreamSource reference = new StreamSource(new ByteArrayInputStream(IMPORT_DOCUMENT.getBytes(StandardCharsets.UTF_8)));
        Diff myDiff = DiffBuilder.compare((Object)reference).withTest((Object)output).normalizeWhitespace().withAttributeFilter(attr -> !attr.getName().equals("identifier")).checkForIdentical().build();
        DefaultComparisonFormatter formatter = new DefaultComparisonFormatter();
        for (Difference difference : myDiff.getDifferences()) {
            System.err.println(difference.toString((ComparisonFormatter)formatter));
        }
        Assert.assertFalse((String)"Output does not match input.", (boolean)this.isDifferent(myDiff));
    }

    @Test
    public void testExportStructure() throws ParserConfigurationException, SAXException, IOException, SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Community community0 = communityService.create(null, this.context);
        communityService.setMetadataSingleValue(this.context, (DSpaceObject)community0, MetadataSchemaEnum.DC.getName(), "title", null, null, "Top Community 0");
        Collection collection0_0 = collectionService.create(this.context, community0);
        collectionService.setMetadataSingleValue(this.context, (DSpaceObject)collection0_0, MetadataSchemaEnum.DC.getName(), "title", null, null, "Collection 0.0");
        System.out.println("exportStructure");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StructBuilder.exportStructure((Context)this.context, (OutputStream)outputStream);
        this.context.restoreAuthSystemState();
        StreamSource output = new StreamSource(new ByteArrayInputStream(outputStream.toByteArray()));
        StreamSource reference = new StreamSource(new ByteArrayInputStream(EXPORT_DOCUMENT.getBytes(StandardCharsets.UTF_8)));
        Diff myDiff = DiffBuilder.compare((Object)reference).withTest((Object)output).normalizeWhitespace().withAttributeFilter(attr -> !attr.getName().equals("identifier")).checkForIdentical().build();
        DefaultComparisonFormatter formatter = new DefaultComparisonFormatter();
        for (Difference difference : myDiff.getDifferences()) {
            System.err.println(difference.toString((ComparisonFormatter)formatter));
        }
        Assert.assertFalse((String)"Output does not match input.", (boolean)myDiff.hasDifferences());
    }

    private void deleteSubCommunities(Community c) throws SQLException, AuthorizeException, IOException {
        for (Community subCommunity : c.getSubcommunities()) {
            this.deleteSubCommunities(subCommunity);
            communityService.delete(this.context, (DSpaceObject)subCommunity);
        }
        for (Collection collection : c.getCollections()) {
            collectionService.delete(this.context, (DSpaceObject)collection);
        }
    }

    private boolean isDifferent(Diff diff) {
        Iterator diffIterator = diff.getDifferences().iterator();
        if (!diffIterator.hasNext()) {
            log.error("Not enough differences.");
            return true;
        }
        Comparison comparison = ((Difference)diffIterator.next()).getComparison();
        Node controlNode = comparison.getControlDetails().getTarget();
        Node testNode = comparison.getTestDetails().getTarget();
        if (!controlNode.getNodeName().equals("import_structure") || !testNode.getNodeName().equals("imported_structure")) {
            log.error("controlNode name:  {}", (Object)controlNode.getNodeName());
            log.error("test node name:  {}", (Object)testNode.getNodeName());
            return true;
        }
        if (controlNode.getParentNode().getNodeType() != 9 || testNode.getParentNode().getNodeType() != 9) {
            log.error("control node's parent type is {}", (Object)controlNode.getParentNode().getNodeType());
            log.error("test node's parent type is {}", (Object)testNode.getParentNode().getNodeType());
            return true;
        }
        return diffIterator.hasNext();
    }
}

