/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom.Document;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MetadataExportIT
extends AbstractIntegrationTestWithDatabase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Test
    public void metadataExportToCsvTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).withAuthor("Donald, Smith").build();
        this.context.restoreAuthSystemState();
        String fileLocation = this.configurationService.getProperty("dspace.dir") + testProps.get("test.exportcsv").toString();
        String[] args = new String[]{"metadata-export", "-i", String.valueOf(item.getHandle()), "-f", fileLocation};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        File file = new File(fileLocation);
        String fileContent = IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8);
        TestCase.assertTrue((boolean)fileContent.contains("Donald, Smith"));
        TestCase.assertTrue((boolean)fileContent.contains(String.valueOf(item.getID())));
    }

    @Test(expected=ParseException.class)
    public void metadataExportWithoutFileParameter() throws IllegalAccessException, InstantiationException, ParseException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).withAuthor("Donald, Smith").build();
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"metadata-export", "-i", String.valueOf(item.getHandle())};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();
        ScriptConfiguration scriptConfiguration = scriptService.getScriptConfiguration(args[0]);
        DSpaceRunnable script = null;
        if (scriptConfiguration != null) {
            script = scriptService.createDSpaceRunnableForScriptConfiguration(scriptConfiguration);
        }
        if (script != null) {
            script.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, null);
            script.run();
        }
    }
}

