/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.AbstractIntegrationTest;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.jdom.Document;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MetadataImportTest
extends AbstractIntegrationTest {
    private final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void metadataImportTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = this.communityService.create(null, this.context);
        Collection collection = this.collectionService.create(this.context, community);
        this.context.restoreAuthSystemState();
        String fileLocation = new File(testProps.get("test.importcsv").toString()).getAbsolutePath();
        String[] args = new String[]{"metadata-import", "-f", fileLocation, "-e", this.eperson.getEmail(), "-s"};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        Item importedItem = (Item)this.itemService.findAll(this.context).next();
        TestCase.assertTrue((boolean)StringUtils.equals((CharSequence)((MetadataValue)this.itemService.getMetadata((DSpaceObject)importedItem, "dc", "contributor", "author", "*").get(0)).getValue(), (CharSequence)"Donald, SmithImported"));
        TestCase.assertEquals((Object)importedItem.getSubmitter(), (Object)this.eperson);
        this.context.turnOffAuthorisationSystem();
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.itemService.find(this.context, importedItem.getID())));
        this.collectionService.delete(this.context, (DSpaceObject)((Collection)this.collectionService.find(this.context, collection.getID())));
        this.communityService.delete(this.context, (DSpaceObject)((Community)this.communityService.find(this.context, community.getID())));
        this.context.restoreAuthSystemState();
    }

    @Test(expected=ParseException.class)
    public void metadataImportWithoutEPersonParameterTest() throws IllegalAccessException, InstantiationException, ParseException {
        String fileLocation = new File(testProps.get("test.importcsv").toString()).getAbsolutePath();
        String[] args = new String[]{"metadata-import", "-f", fileLocation, "-s"};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();
        ScriptConfiguration scriptConfiguration = scriptService.getScriptConfiguration(args[0]);
        DSpaceRunnable script = null;
        if (scriptConfiguration != null) {
            script = scriptService.createDSpaceRunnableForScriptConfiguration(scriptConfiguration);
        }
        if (script != null) {
            script.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, null);
            script.run();
        }
    }
}

