/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.dspace.AbstractUnitTest;
import org.dspace.app.util.GoogleBitstreamComparator;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.core.Context;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public class GoogleBitstreamComparatorTest
extends AbstractUnitTest {
    @Mock
    private Bundle bundle;
    @Mock
    private Bitstream bitstream1;
    @Mock
    private Bitstream bitstream2;
    @Mock
    private Bitstream bitstream3;
    @Mock
    private BitstreamFormat bitstreamFormat1;
    @Mock
    private BitstreamFormat bitstreamFormat2;
    @Mock
    private BitstreamFormat bitstreamFormat3;
    private HashMap<String, String> settings = new HashMap();

    @Override
    @Before
    public void init() {
        super.init();
        Mockito.when((Object)this.bitstream1.getName()).thenReturn((Object)"bitstream1");
        Mockito.when((Object)this.bitstream2.getName()).thenReturn((Object)"bitstream2");
        Mockito.when((Object)this.bitstream3.getName()).thenReturn((Object)"bitstream3");
        this.settings.put("citation.prioritized_types", "Adobe PDF, Microsoft Word, RTF, Postscript");
        ArrayList<Bitstream> bitstreams = new ArrayList<Bitstream>();
        bitstreams.add(this.bitstream1);
        bitstreams.add(this.bitstream2);
        bitstreams.add(this.bitstream3);
        Mockito.when((Object)this.bundle.getBitstreams()).thenReturn(bitstreams);
        try {
            Mockito.when((Object)this.bitstream1.getFormat((Context)ArgumentMatchers.any(Context.class))).thenReturn((Object)this.bitstreamFormat1);
            Mockito.when((Object)this.bitstream2.getFormat((Context)ArgumentMatchers.any(Context.class))).thenReturn((Object)this.bitstreamFormat2);
            Mockito.when((Object)this.bitstream3.getFormat((Context)ArgumentMatchers.any(Context.class))).thenReturn((Object)this.bitstreamFormat3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPDFDifferentSize() throws Exception {
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"application/pdf");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"application/pdf");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"application/pdf");
        Mockito.when((Object)this.bitstream1.getSizeBytes()).thenReturn((Object)100L);
        Mockito.when((Object)this.bitstream2.getSizeBytes()).thenReturn((Object)200L);
        Mockito.when((Object)this.bitstream3.getSizeBytes()).thenReturn((Object)300L);
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((Object)"bitstream3", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((Object)"bitstream2", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((Object)"bitstream1", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testDifferentMimeTypes() throws Exception {
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"application/msword");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"application/postscript");
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((String)"WORD should be first as its type has the highest priority", (Object)"bitstream2", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((String)"RTF should be second as its type priority is right after Word", (Object)"bitstream1", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((String)"PS should be last as it has the lowest type priority", (Object)"bitstream3", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testMimeTypesDifferentSizes() throws Exception {
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"application/postscript");
        Mockito.when((Object)this.bitstream1.getSizeBytes()).thenReturn((Object)100L);
        Mockito.when((Object)this.bitstream2.getSizeBytes()).thenReturn((Object)200L);
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((Object)"bitstream2", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((Object)"bitstream1", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((Object)"bitstream3", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testSameMimeTypeSameSize() throws Exception {
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"application/pdf");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"application/pdf");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"application/pdf");
        Mockito.when((Object)this.bitstream1.getSizeBytes()).thenReturn((Object)200L);
        Mockito.when((Object)this.bitstream2.getSizeBytes()).thenReturn((Object)200L);
        Mockito.when((Object)this.bitstream3.getSizeBytes()).thenReturn((Object)200L);
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((String)"Bitstreams have same size and type, so order should remain unchanged", (Object)"bitstream1", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((String)"Bitstreams have same size and type, so order should remain unchanged", (Object)"bitstream2", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((String)"Bitstreams have same size and type, so order should remain unchanged", (Object)"bitstream3", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testUnknownMimeType() throws Exception {
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"unknown");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstream2.getSizeBytes()).thenReturn((Object)200L);
        Mockito.when((Object)this.bitstream3.getSizeBytes()).thenReturn((Object)300L);
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((Object)"bitstream3", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((Object)"bitstream2", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((String)"Unknown mime-types should always have the lowest priority", (Object)"bitstream1", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testAllUnknown() throws Exception {
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"unknown");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"unknown");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"unknown");
        Mockito.when((Object)this.bitstream1.getSizeBytes()).thenReturn((Object)200L);
        Mockito.when((Object)this.bitstream2.getSizeBytes()).thenReturn((Object)300L);
        Mockito.when((Object)this.bitstream3.getSizeBytes()).thenReturn((Object)100L);
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((String)"bitstream2 should come first as it is the largest and all types are equal", (Object)"bitstream2", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((String)"bitstream1 should come second as it is the second largest and all types are equal", (Object)"bitstream1", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((String)"bitstream3 should come last as it is the smallest and all types are equal", (Object)"bitstream3", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testChangePriority() throws Exception {
        this.settings.put("citation.prioritized_types", "Postscript, RTF, Microsoft Word, Adobe PDF");
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"application/msword");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"application/postscript");
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((String)"According to the updated type prioritization, PS should be first", (Object)"bitstream3", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((String)"According to the updated type prioritization, RTF should come second", (Object)"bitstream1", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((String)"According to the updated type prioritization, Word has to be last", (Object)"bitstream2", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testNoMimeType() throws Exception {
        Mockito.when((Object)this.bitstream1.getSizeBytes()).thenReturn((Object)200L);
        Mockito.when((Object)this.bitstream2.getSizeBytes()).thenReturn((Object)300L);
        Mockito.when((Object)this.bitstream3.getSizeBytes()).thenReturn((Object)100L);
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((String)"bitstream2 should come first as it is the largest and there are no types", (Object)"bitstream2", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((String)"bitstream1 should come second as it is the second largest and there are no types", (Object)"bitstream1", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((String)"bitstream3 should come last as it is the smallest and there are no types", (Object)"bitstream3", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testNoSize() throws Exception {
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"unknown");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"unknown");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"unknown");
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((Object)"bitstream1", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((Object)"bitstream2", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((Object)"bitstream3", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testNoMimeTypeNoSize() throws Exception {
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((Object)"bitstream1", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((Object)"bitstream2", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((Object)"bitstream3", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testNoPrioritizedTypes() throws Exception {
        this.settings.put("citation.prioritized_types", "");
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"application/msword");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"application/postscript");
        Mockito.when((Object)this.bitstream1.getSizeBytes()).thenReturn((Object)100L);
        Mockito.when((Object)this.bitstream2.getSizeBytes()).thenReturn((Object)200L);
        Mockito.when((Object)this.bitstream3.getSizeBytes()).thenReturn((Object)300L);
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((String)"PS should be first because it is the largest one and there is no type prioritization", (Object)"bitstream3", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((String)"RTF should come second because it is the second largest and there is no type prioritization", (Object)"bitstream2", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((String)"Word has to be last (third) as it is the smallest one and there is no type prioritization", (Object)"bitstream1", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testNoConfig() throws Exception {
        this.settings.remove("citation.prioritized_types");
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"application/msword");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"application/postscript");
        Mockito.when((Object)this.bitstream1.getSizeBytes()).thenReturn((Object)100L);
        Mockito.when((Object)this.bitstream2.getSizeBytes()).thenReturn((Object)200L);
        Mockito.when((Object)this.bitstream3.getSizeBytes()).thenReturn((Object)300L);
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((String)"bitstream3 should come first as it is the largest and there is no type prioritization configured", (Object)"bitstream3", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((String)"bitstream2 should come second as it is the second largest and there is no type prioritization configured", (Object)"bitstream2", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((String)"bitstream1 should come last as it is the smallest and there is no type prioritization configured", (Object)"bitstream1", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testUndefinedShortDescription() {
        this.settings.put("citation.prioritized_types", "Postscript, RTF, Undefined Type, Microsoft Word, Adobe PDF");
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"application/msword");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"application/postscript");
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((Object)"bitstream3", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((Object)"bitstream1", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((Object)"bitstream2", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Test
    public void testAddingNewFormat() {
        this.settings.put("citation.prioritized_types", "WAV, Adobe PDF, Microsoft Word, RTF, Postscript");
        Mockito.when((Object)this.bitstreamFormat1.getMIMEType()).thenReturn((Object)"text/richtext");
        Mockito.when((Object)this.bitstreamFormat2.getMIMEType()).thenReturn((Object)"application/msword");
        Mockito.when((Object)this.bitstreamFormat3.getMIMEType()).thenReturn((Object)"audio/x-wav");
        List toSort = this.bundle.getBitstreams();
        Collections.sort(toSort, new GoogleBitstreamComparator(this.context, this.settings));
        Assert.assertEquals((String)"bitstream3 has the type with the highest priority (thus ignoring its size) and should come first", (Object)"bitstream3", (Object)((Bitstream)toSort.get(0)).getName());
        Assert.assertEquals((String)"bitstream2 has a type with a priority higher than bitstream1 (size is ignored) and should come second", (Object)"bitstream2", (Object)((Bitstream)toSort.get(1)).getName());
        Assert.assertEquals((String)"bitstream1 has a type with the lowest priority in this bundle eventhough it is the largest bitstream and should come last", (Object)"bitstream1", (Object)((Bitstream)toSort.get(2)).getName());
    }

    @Override
    @After
    public void destroy() {
        this.settings = null;
        super.destroy();
    }
}

