/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.junit.Assert;
import org.junit.Test;

public class AuthorizeServiceTest
extends AbstractUnitTest {
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();

    @Test
    public void testauthorizeMethodDoesNotConfuseEPersonWithCurrentUser() {
        Community dso;
        EPerson eperson2;
        EPerson eperson1;
        try {
            this.context.turnOffAuthorisationSystem();
            eperson1 = this.ePersonService.create(this.context);
            eperson2 = this.ePersonService.create(this.context);
            Group group = this.groupService.create(this.context);
            this.groupService.setName(group, "My test group");
            this.groupService.addMember(this.context, group, eperson1);
            this.groupService.update(this.context, (DSpaceObject)group);
            dso = this.communityService.create(null, this.context);
            this.authorizeService.addPolicy(this.context, (DSpaceObject)dso, 1, group);
            this.context.commit();
            this.context.setCurrentUser(eperson2);
        }
        catch (SQLException | AuthorizeException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            Assert.assertTrue((boolean)this.authorizeService.authorizeActionBoolean(this.context, eperson1, (DSpaceObject)dso, 1, true));
            Assert.assertFalse((boolean)this.authorizeService.authorizeActionBoolean(this.context, eperson2, (DSpaceObject)dso, 1, true));
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Test
    public void testauthorizeMethodRespectSpecialGroups() {
        Community dso;
        EPerson eperson;
        try {
            this.context.turnOffAuthorisationSystem();
            eperson = this.ePersonService.create(this.context);
            Group group1 = this.groupService.create(this.context);
            this.groupService.setName(group1, "My test group 2");
            dso = this.communityService.create(null, this.context);
            this.authorizeService.addPolicy(this.context, (DSpaceObject)dso, 3, group1);
            this.context.setCurrentUser(eperson);
            this.context.setSpecialGroup(group1.getID());
            this.context.commit();
        }
        catch (SQLException | AuthorizeException ex) {
            throw new AssertionError((Object)ex);
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        try {
            Assert.assertTrue((boolean)this.authorizeService.authorizeActionBoolean(this.context, eperson, (DSpaceObject)dso, 3, true));
        }
        catch (SQLException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

