/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.WorkspaceItemService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataValueTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(MetadataValueTest.class);
    private MetadataValue mv = null;
    private Collection collection;
    private Community owningCommunity;
    private Item it;
    private MetadataField mf;
    private String element = "contributor";
    private String qualifier = "author";
    private MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            WorkspaceItem workspaceItem = this.workspaceItemService.create(this.context, this.collection, false);
            this.it = this.installItemService.installItem(this.context, (InProgressSubmission)workspaceItem);
            this.mf = this.metadataFieldService.findByElement(this.context, MetadataSchemaEnum.DC.getName(), this.element, this.qualifier);
            this.mv = this.metadataValueService.create(this.context, (DSpaceObject)this.it, this.mf);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorize Error in init", (Throwable)ex);
            Assert.fail((String)("Authorize Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("Error in destroy", ex);
            Assert.fail((String)("Error in destroy: " + ex.getMessage()));
        }
        finally {
            this.context.restoreAuthSystemState();
        }
        this.mf = null;
        this.mv = null;
        super.destroy();
    }

    @Test
    public void testGetFieldId() {
        MetadataValue instance = new MetadataValue();
        Assert.assertThat((String)"testGetFieldId 0", (Object)instance.getID(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((String)"testGetFieldId 1", (Object)this.mv.getMetadataField().getID(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getID()));
    }

    @Test
    public void testGetDSpaceObject() {
        Assert.assertTrue((String)"testGetItemId 0", (boolean)this.mv.getDSpaceObject().equals(this.it));
    }

    @Test
    public void testGetLanguage() {
        Assert.assertThat((String)"testGetLanguage 0", (Object)this.mv.getLanguage(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLanguage() {
        String language = "eng";
        this.mv.setLanguage(language);
        Assert.assertThat((String)"testSetLanguage 0", (Object)this.mv.getLanguage(), (Matcher)CoreMatchers.equalTo((Object)language));
    }

    @Test
    public void testGetPlace() {
        Assert.assertThat((String)"testGetPlace 0", (Object)this.mv.getPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testSetPlace() {
        int place = 5;
        this.mv.setPlace(place);
        Assert.assertThat((String)"testSetPlace 0", (Object)this.mv.getPlace(), (Matcher)CoreMatchers.equalTo((Object)place));
    }

    @Test
    public void testGetValueId() {
        Assert.assertThat((String)"testGetValueId 0", (Object)this.mv.getID(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetValue() {
        Assert.assertThat((String)"testGetValue 0", (Object)this.mv.getValue(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetValue() {
        String value = "value";
        this.mv.setValue(value);
        Assert.assertThat((String)"testSetValue 0", (Object)this.mv.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
    }

    @Test
    public void testGetAuthority() {
        Assert.assertThat((String)"testGetAuthority 0", (Object)this.mv.getAuthority(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetAuthority() {
        String value = "auth_val";
        this.mv.setAuthority(value);
        Assert.assertThat((String)"testSetAuthority 0", (Object)this.mv.getAuthority(), (Matcher)CoreMatchers.equalTo((Object)value));
    }

    @Test
    public void testGetConfidence() {
        Assert.assertThat((String)"testGetConfidence 0", (Object)this.mv.getConfidence(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testSetConfidence() {
        int value = 5;
        this.mv.setConfidence(value);
        Assert.assertThat((String)"testSetConfidence 0", (Object)this.mv.getConfidence(), (Matcher)CoreMatchers.equalTo((Object)value));
    }

    @Test
    public void testCreate() throws Exception {
        this.metadataValueService.create(this.context, (DSpaceObject)this.it, this.mf);
    }

    @Test
    public void testFind() throws Exception {
        this.metadataValueService.create(this.context, (DSpaceObject)this.it, this.mf);
        int id = this.mv.getID();
        MetadataValue found = this.metadataValueService.find(this.context, id);
        Assert.assertThat((String)"testFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
    }

    @Test
    public void testFindByField() throws Exception {
        this.metadataValueService.create(this.context, (DSpaceObject)this.it, this.mf);
        List found = this.metadataValueService.findByField(this.context, this.mf);
        Assert.assertThat((String)"testFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFind 1", (found.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdate() throws Exception {
        this.metadataValueService.create(this.context, (DSpaceObject)this.it, this.mf);
        this.metadataValueService.update(this.context, this.mv);
    }
}

