/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import org.dspace.AbstractDSpaceTest;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.DCInputAuthority;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.junit.Assert;
import org.junit.Test;

public class PluginServiceTest
extends AbstractDSpaceTest {
    private PluginService pluginService = CoreServiceFactory.getInstance().getPluginService();

    @Test
    public void testGetAllPluginNames() {
        String[] names = this.pluginService.getAllPluginNames(List.class);
        Assert.assertEquals((String)"Plugin count", (long)3L, (long)names.length);
    }

    @Test
    public void testGetNamedPlugin() {
        Object plugin = this.pluginService.getNamedPlugin(List.class, "MyArrayList");
        Assert.assertNotNull((String)"Plugin exists", (Object)plugin);
        Assert.assertTrue((String)"Plugin is List", (boolean)(plugin instanceof List));
        Assert.assertTrue((String)"Plugin is ArrayList", (boolean)(plugin instanceof ArrayList));
        plugin = this.pluginService.getNamedPlugin(List.class, "MyOtherList");
        Assert.assertNull((String)"Plugin 2 doesn't exist", (Object)plugin);
        plugin = this.pluginService.getNamedPlugin(ChoiceAuthority.class, "common_types");
        Assert.assertNotNull((String)"Plugin 3 exists", (Object)plugin);
        Assert.assertTrue((String)"Plugin 3 is ChoiceAuthority", (boolean)(plugin instanceof ChoiceAuthority));
        Assert.assertTrue((String)"Plugin 3 is DCInputAuthority", (boolean)(plugin instanceof DCInputAuthority));
    }

    @Test
    public void testHasNamedPlugin() {
        Assert.assertTrue((boolean)this.pluginService.hasNamedPlugin(List.class, "MyLinkedList"));
        Assert.assertFalse((boolean)this.pluginService.hasNamedPlugin(List.class, "MyList"));
        Assert.assertTrue((boolean)this.pluginService.hasNamedPlugin(ChoiceAuthority.class, "common_types"));
    }

    @Test
    public void testGetSinglePlugin() {
        Object plugin = this.pluginService.getSinglePlugin(Map.class);
        Assert.assertNotNull((String)"Plugin exists", (Object)plugin);
        Assert.assertTrue((String)"Plugin is Map", (boolean)(plugin instanceof Map));
        Assert.assertTrue((String)"Plugin is HashMap", (boolean)(plugin instanceof HashMap));
    }

    @Test
    public void testGetPluginSequence() {
        Object[] plugins = this.pluginService.getPluginSequence(Collection.class);
        Assert.assertEquals((String)"Plugin count", (long)4L, (long)plugins.length);
        Assert.assertTrue((String)"Plugin 0 is ArrayList", (boolean)(plugins[0] instanceof ArrayList));
        Assert.assertTrue((String)"Plugin 1 is LinkedList", (boolean)(plugins[1] instanceof LinkedList));
        Assert.assertTrue((String)"Plugin 2 is Stack", (boolean)(plugins[2] instanceof Stack));
        Assert.assertTrue((String)"Plugin 3 is TreeSet", (boolean)(plugins[3] instanceof TreeSet));
    }
}

