/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(GroupTest.class);
    private Group topGroup;
    private Group level1Group;
    private Group level2Group;
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.topGroup = this.createGroup("topGroup");
            this.level1Group = this.createGroup("level1Group");
            this.groupService.addMember(this.context, this.topGroup, this.level1Group);
            this.level2Group = this.createGroup("level2Group");
            this.groupService.addMember(this.context, this.level1Group, this.level2Group);
            this.groupService.update(this.context, (DSpaceObject)this.topGroup);
            this.groupService.update(this.context, (DSpaceObject)this.level1Group);
            this.groupService.update(this.context, (DSpaceObject)this.level2Group);
            this.context.restoreAuthSystemState();
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            if (this.level2Group != null) {
                this.groupService.delete(this.context, (DSpaceObject)this.level2Group);
                this.level2Group = null;
            }
            if (this.level1Group != null) {
                this.groupService.delete(this.context, (DSpaceObject)this.level1Group);
                this.level1Group = null;
            }
            if (this.topGroup != null) {
                this.groupService.delete(this.context, (DSpaceObject)this.topGroup);
                this.topGroup = null;
            }
            this.context.restoreAuthSystemState();
            super.destroy();
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (IOException ex) {
            log.error("IO Error in init", (Throwable)ex);
            Assert.fail((String)("IO Error in init: " + ex.getMessage()));
        }
    }

    @Test
    public void createGroup() throws SQLException, AuthorizeException, IOException {
        Group group = null;
        try {
            this.context.turnOffAuthorisationSystem();
            group = this.groupService.create(this.context);
            Assert.assertThat((String)"testCreateGroup", (Object)group, (Matcher)CoreMatchers.notNullValue());
        }
        finally {
            if (group != null) {
                this.groupService.delete(this.context, (DSpaceObject)group);
            }
            this.context.restoreAuthSystemState();
        }
    }

    @Test(expected=AuthorizeException.class)
    public void createGroupUnAuthorized() throws SQLException, AuthorizeException {
        this.context.setCurrentUser(null);
        this.groupService.create(this.context);
    }

    @Test
    public void setGroupName() throws SQLException, AuthorizeException {
        this.topGroup.setName("new name");
        this.groupService.update(this.context, (DSpaceObject)this.topGroup);
        Assert.assertThat((String)"setGroupName 1", (Object)this.topGroup.getName(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"setGroupName 2", (Object)this.topGroup.getName(), (Matcher)CoreMatchers.equalTo((Object)"new name"));
    }

    @Test
    public void setGroupNameOnPermanentGroup() throws SQLException, AuthorizeException {
        this.topGroup.setPermanent(true);
        this.topGroup.setName("new name");
        this.groupService.update(this.context, (DSpaceObject)this.topGroup);
        Assert.assertThat((String)"setGroupName 1", (Object)this.topGroup.getName(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"setGroupName 2", (Object)this.topGroup.getName(), (Matcher)CoreMatchers.equalTo((Object)"topGroup"));
        this.topGroup.setPermanent(false);
        this.groupService.update(this.context, (DSpaceObject)this.topGroup);
    }

    @Test
    public void findByName() throws SQLException {
        Group group = this.groupService.findByName(this.context, "topGroup");
        Assert.assertThat((String)"findByName 1", (Object)group, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"findByName 2", (Object)group.getName(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"findByName 2", (Object)group.getName(), (Matcher)CoreMatchers.equalTo((Object)"topGroup"));
    }

    @Test
    public void findAll() throws SQLException {
        List groups = this.groupService.findAll(this.context, null);
        Assert.assertThat((String)"findAll 1", (Object)groups, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"findAll 2", (0 < groups.size() ? 1 : 0) != 0);
    }

    @Test
    public void findAllNameSort() throws SQLException {
        List groups = this.groupService.findAll(this.context, null);
        Assert.assertThat((String)"findAllNameSort 1", (Object)groups, (Matcher)CoreMatchers.notNullValue());
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> sortedNames = new ArrayList<String>();
        for (Group group : groups) {
            if (group.getName() == null) continue;
            names.add(group.getName());
            sortedNames.add(group.getName());
        }
        Collections.sort(sortedNames);
        Assert.assertThat((String)"findAllNameSort compareLists", names, (Matcher)CoreMatchers.equalTo(sortedNames));
    }

    @Test
    public void searchByName() throws SQLException {
        List groups = this.groupService.search(this.context, "level", 0, 1);
        Assert.assertThat((String)"search 1", (Object)groups, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"search 2", (Object)groups.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        String firstGroupName = ((Group)groups.iterator().next()).getName();
        Assert.assertTrue((String)"search 3", (firstGroupName.equals("level1Group") || firstGroupName.equals("level2Group") ? 1 : 0) != 0);
        groups = this.groupService.search(this.context, "level", 1, 2);
        Assert.assertThat((String)"search 1", (Object)groups, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"search 2", (Object)groups.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        String secondGroupName = ((Group)groups.iterator().next()).getName();
        Assert.assertTrue((String)"search 3", (secondGroupName.equals("level1Group") || secondGroupName.equals("level2Group") ? 1 : 0) != 0);
    }

    @Test
    public void searchByID() throws SQLException {
        List searchResult = this.groupService.search(this.context, String.valueOf(this.topGroup.getID()), 0, 10);
        Assert.assertThat((String)"searchID 1", (Object)searchResult.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((String)"searchID 2", (Object)((Group)searchResult.iterator().next()), (Matcher)CoreMatchers.equalTo((Object)this.topGroup));
    }

    @Test
    public void searchResultCount() throws SQLException {
        Assert.assertThat((String)"searchResultCount", (Object)this.groupService.searchResultCount(this.context, "level"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void addMemberEPerson() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        EPerson ePerson = null;
        try {
            ePerson = this.createEPersonAndAddToGroup("addMemberEPerson@dspace.org", this.topGroup);
            this.groupService.update(this.context, (DSpaceObject)this.topGroup);
            Assert.assertThat((String)"addMemberEPerson 1", (Object)this.topGroup.getMembers().size(), (Matcher)CoreMatchers.equalTo((Object)1));
            Assert.assertTrue((String)"addMemberEPerson 2", (boolean)this.topGroup.getMembers().contains(ePerson));
        }
        finally {
            if (ePerson != null) {
                this.context.turnOffAuthorisationSystem();
                this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
                this.context.restoreAuthSystemState();
            }
        }
    }

    @Test
    public void addMemberGroup() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        this.context.turnOffAuthorisationSystem();
        Group parentGroup = this.createGroup("parentGroup");
        Group childGroup = this.createGroup("childGroup");
        this.groupService.addMember(this.context, parentGroup, childGroup);
        this.groupService.update(this.context, (DSpaceObject)parentGroup);
        this.groupService.update(this.context, (DSpaceObject)childGroup);
        this.groupService.delete(this.context, (DSpaceObject)parentGroup);
        this.groupService.delete(this.context, (DSpaceObject)childGroup);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void deleteGroupEPersonMembers() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        EPerson ePerson = null;
        this.context.turnOffAuthorisationSystem();
        try {
            Group toDeleteGroup = this.createGroup("toDelete");
            ePerson = this.createEPerson("deleteGroupEPersonMembers@dspace.org");
            this.groupService.addMember(this.context, toDeleteGroup, ePerson);
            this.groupService.update(this.context, (DSpaceObject)toDeleteGroup);
            this.groupService.delete(this.context, (DSpaceObject)toDeleteGroup);
            Assert.assertThat((String)"deleteGroupEPersonMembers", (Object)ePerson.getGroups().size(), (Matcher)CoreMatchers.equalTo((Object)0));
        }
        finally {
            if (ePerson != null) {
                this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            }
            this.context.restoreAuthSystemState();
        }
    }

    @Test
    public void deleteGroupGroupMembers() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        Group parentGroup = this.createGroup("toDeleteParent");
        Group childGroup = this.createGroup("toDeleteChild");
        this.groupService.addMember(this.context, parentGroup, childGroup);
        this.groupService.update(this.context, (DSpaceObject)parentGroup);
        this.groupService.update(this.context, (DSpaceObject)childGroup);
        this.groupService.delete(this.context, (DSpaceObject)parentGroup);
        this.groupService.delete(this.context, (DSpaceObject)childGroup);
        parentGroup = this.createGroup("toDeleteParent");
        childGroup = this.createGroup("toDeleteChild");
        this.groupService.addMember(this.context, parentGroup, childGroup);
        this.groupService.update(this.context, (DSpaceObject)parentGroup);
        this.groupService.update(this.context, (DSpaceObject)childGroup);
        this.groupService.delete(this.context, (DSpaceObject)childGroup);
        this.groupService.delete(this.context, (DSpaceObject)parentGroup);
    }

    @Test
    public void isMemberGroup() throws SQLException {
        Assert.assertTrue((String)"isMemberGroup 1", (boolean)this.groupService.isMember(this.topGroup, this.level1Group));
        Assert.assertTrue((String)"isMemberGroup 2", (boolean)this.groupService.isMember(this.level1Group, this.level2Group));
        Assert.assertFalse((String)"isMemberGroup 3", (boolean)this.groupService.isMember(this.level1Group, this.topGroup));
        Assert.assertFalse((String)"isMemberGroup 4", (boolean)this.groupService.isMember(this.level2Group, this.level1Group));
    }

    @Test
    public void isSubgroupOf() throws SQLException {
        Assert.assertTrue((String)"isMemberGroup 1", (boolean)this.groupService.isParentOf(this.context, this.topGroup, this.level1Group));
        Assert.assertTrue((String)"isMemberGroup 2", (boolean)this.groupService.isParentOf(this.context, this.level1Group, this.level2Group));
        Assert.assertFalse((String)"isMemberGroup 3", (boolean)this.groupService.isParentOf(this.context, this.level1Group, this.topGroup));
        Assert.assertFalse((String)"isMemberGroup 4", (boolean)this.groupService.isParentOf(this.context, this.level2Group, this.level1Group));
        Assert.assertTrue((String)"isMemberGroup 5", (boolean)this.groupService.isParentOf(this.context, this.topGroup, this.level2Group));
        Assert.assertFalse((String)"isMemberGroup 6", (boolean)this.groupService.isParentOf(this.context, this.level2Group, this.topGroup));
    }

    @Test
    public void isMemberEPerson() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        EPerson ePerson = null;
        try {
            this.context.turnOffAuthorisationSystem();
            ePerson = this.createEPersonAndAddToGroup("isMemberEPerson@dspace.org", this.level1Group);
            Assert.assertTrue((boolean)this.groupService.isDirectMember(this.level1Group, ePerson));
            Assert.assertFalse((boolean)this.groupService.isDirectMember(this.topGroup, ePerson));
        }
        finally {
            if (ePerson != null) {
                this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            }
            this.context.restoreAuthSystemState();
        }
    }

    @Test
    public void isMemberContext() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        EPerson ePerson = null;
        try {
            ePerson = this.createEPersonAndAddToGroup("isMemberContext@dspace.org", this.level2Group);
            this.context.setCurrentUser(ePerson);
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson, this.topGroup));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson, this.level1Group));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson, this.level2Group));
        }
        finally {
            if (ePerson != null) {
                this.context.turnOffAuthorisationSystem();
                this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            }
        }
    }

    @Test
    public void isMemberContextGroupId() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        EPerson ePerson = null;
        try {
            ePerson = this.createEPersonAndAddToGroup("isMemberContextGroupId@dspace.org", this.level2Group);
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson, this.topGroup.getName()));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson, this.level1Group.getName()));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson, this.level2Group.getName()));
        }
        finally {
            if (ePerson != null) {
                this.context.turnOffAuthorisationSystem();
                this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            }
        }
    }

    @Test
    public void isMemberContextSpecialGroup() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        Group specialGroup;
        block5: {
            EPerson ePerson = null;
            specialGroup = null;
            try {
                specialGroup = this.createGroup("specialGroup");
                this.groupService.addMember(this.context, this.level1Group, specialGroup);
                this.groupService.update(this.context, (DSpaceObject)this.level1Group);
                ePerson = this.createEPerson("isMemberContextGroupSpecial@dspace.org");
                this.context.setCurrentUser(ePerson);
                this.context.setSpecialGroup(specialGroup.getID());
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.topGroup));
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.level1Group));
                Assert.assertFalse((boolean)this.groupService.isMember(this.context, this.level2Group));
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, specialGroup));
                if (ePerson == null) break block5;
            }
            catch (Throwable throwable) {
                if (ePerson != null) {
                    this.context.turnOffAuthorisationSystem();
                    this.ePersonService.delete(this.context, ePerson);
                }
                if (specialGroup != null) {
                    this.context.turnOffAuthorisationSystem();
                    this.groupService.delete(this.context, (DSpaceObject)specialGroup);
                }
                throw throwable;
            }
            this.context.turnOffAuthorisationSystem();
            this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
        }
        if (specialGroup != null) {
            this.context.turnOffAuthorisationSystem();
            this.groupService.delete(this.context, (DSpaceObject)specialGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void isMemberContextSpecialGroupOtherUser() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        Group specialGroup;
        EPerson ePerson2;
        block7: {
            EPerson ePerson1 = null;
            ePerson2 = null;
            specialGroup = null;
            try {
                specialGroup = this.createGroup("specialGroup");
                this.groupService.addMember(this.context, this.level2Group, specialGroup);
                this.groupService.update(this.context, (DSpaceObject)this.level2Group);
                ePerson1 = this.createEPerson("isMemberContextGroupSpecial@dspace.org");
                this.context.setCurrentUser(ePerson1);
                this.context.setSpecialGroup(specialGroup.getID());
                ePerson2 = this.createEPersonAndAddToGroup("isMemberContextSpecialGroupOtherUser@dspace.org", this.level1Group);
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson2, this.topGroup));
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson2, this.level1Group));
                Assert.assertFalse((boolean)this.groupService.isMember(this.context, ePerson2, this.level2Group));
                Assert.assertFalse((boolean)this.groupService.isMember(this.context, ePerson2, specialGroup));
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson1, this.level2Group));
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, ePerson1, specialGroup));
                if (ePerson1 == null) break block7;
            }
            catch (Throwable throwable) {
                if (ePerson1 != null) {
                    this.context.turnOffAuthorisationSystem();
                    this.ePersonService.delete(this.context, ePerson1);
                }
                if (ePerson2 != null) {
                    this.context.turnOffAuthorisationSystem();
                    this.ePersonService.delete(this.context, ePerson2);
                }
                if (specialGroup != null) {
                    this.context.turnOffAuthorisationSystem();
                    this.groupService.delete(this.context, (DSpaceObject)specialGroup);
                }
                throw throwable;
            }
            this.context.turnOffAuthorisationSystem();
            this.ePersonService.delete(this.context, (DSpaceObject)ePerson1);
        }
        if (ePerson2 != null) {
            this.context.turnOffAuthorisationSystem();
            this.ePersonService.delete(this.context, (DSpaceObject)ePerson2);
        }
        if (specialGroup != null) {
            this.context.turnOffAuthorisationSystem();
            this.groupService.delete(this.context, (DSpaceObject)specialGroup);
        }
    }

    @Test
    public void isMemberContextSpecialGroupDbMembership() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        Group specialGroup;
        block5: {
            EPerson ePerson = null;
            specialGroup = null;
            try {
                specialGroup = this.createGroup("specialGroup");
                this.groupService.addMember(this.context, this.level1Group, specialGroup);
                this.groupService.update(this.context, (DSpaceObject)this.level1Group);
                ePerson = this.createEPersonAndAddToGroup("isMemberContextGroupSpecialDbMembership@dspace.org", this.level2Group);
                this.context.setCurrentUser(ePerson);
                this.context.setSpecialGroup(specialGroup.getID());
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.topGroup));
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.level1Group));
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.level2Group));
                Assert.assertTrue((boolean)this.groupService.isMember(this.context, specialGroup));
                if (ePerson == null) break block5;
            }
            catch (Throwable throwable) {
                if (ePerson != null) {
                    this.context.turnOffAuthorisationSystem();
                    this.ePersonService.delete(this.context, ePerson);
                }
                if (specialGroup != null) {
                    this.context.turnOffAuthorisationSystem();
                    this.groupService.delete(this.context, (DSpaceObject)specialGroup);
                }
                throw throwable;
            }
            this.context.turnOffAuthorisationSystem();
            this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
        }
        if (specialGroup != null) {
            this.context.turnOffAuthorisationSystem();
            this.groupService.delete(this.context, (DSpaceObject)specialGroup);
        }
    }

    @Test
    public void isPermanent() throws SQLException {
        Group anonymousGroup = this.groupService.findByName(this.context, "Anonymous");
        Assert.assertTrue((String)"Anonymous group should be 'permanent'", (boolean)anonymousGroup.isPermanent());
        Assert.assertFalse((String)"topGroup should *not* be 'permanent'", (boolean)this.topGroup.isPermanent());
    }

    @Test
    public void setPermanent() throws SQLException, AuthorizeException, IOException {
        Group permaGroup = new Group();
        permaGroup.setPermanent(true);
        Assert.assertTrue((String)"setPermanent(true) should be reflected in the group's state", (boolean)permaGroup.isPermanent());
        permaGroup.setPermanent(false);
        Assert.assertFalse((String)"setPermanent(false) should be reflected in the group's state", (boolean)permaGroup.isPermanent());
    }

    @Test
    public void removeMemberEPerson() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        EPerson ePerson = null;
        try {
            ePerson = this.createEPersonAndAddToGroup("removeMemberEPerson@dspace.org", this.level2Group);
            this.context.setCurrentUser(ePerson);
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.topGroup));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.level1Group));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.level2Group));
            this.groupService.removeMember(this.context, this.level2Group, ePerson);
            Assert.assertFalse((boolean)this.groupService.isMember(this.context, this.topGroup));
            Assert.assertFalse((boolean)this.groupService.isMember(this.context, this.level1Group));
            Assert.assertFalse((boolean)this.groupService.isMember(this.context, this.level2Group));
            this.groupService.addMember(this.context, this.level2Group, ePerson);
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.topGroup));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.level1Group));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.level2Group));
            this.groupService.removeMember(this.context, this.topGroup, ePerson);
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.topGroup));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.level1Group));
            Assert.assertTrue((boolean)this.groupService.isMember(this.context, this.level2Group));
        }
        finally {
            if (ePerson != null) {
                this.context.turnOffAuthorisationSystem();
                this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            }
        }
    }

    @Test
    public void removeMemberGroup() throws SQLException, AuthorizeException {
        Assert.assertTrue((boolean)this.groupService.isMember(this.topGroup, this.level1Group));
        Assert.assertTrue((boolean)this.groupService.isParentOf(this.context, this.topGroup, this.level1Group));
        this.groupService.removeMember(this.context, this.topGroup, this.level1Group);
        this.groupService.update(this.context, (DSpaceObject)this.topGroup);
        Assert.assertFalse((boolean)this.groupService.isMember(this.topGroup, this.level1Group));
        Assert.assertFalse((boolean)this.groupService.isParentOf(this.context, this.topGroup, this.level1Group));
    }

    @Test
    public void allMemberGroups() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        EPerson ePerson = this.createEPersonAndAddToGroup("allMemberGroups@dspace.org", this.level1Group);
        try {
            Assert.assertTrue((boolean)this.groupService.allMemberGroups(this.context, ePerson).containsAll(Arrays.asList(this.topGroup, this.level1Group)));
        }
        finally {
            this.context.turnOffAuthorisationSystem();
            this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            this.context.restoreAuthSystemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void allMembers() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        ArrayList<EPerson> allEPeopleAdded = new ArrayList<EPerson>();
        try {
            this.context.turnOffAuthorisationSystem();
            allEPeopleAdded.add(this.createEPersonAndAddToGroup("allMemberGroups1@dspace.org", this.topGroup));
            allEPeopleAdded.add(this.createEPersonAndAddToGroup("allMemberGroups2@dspace.org", this.level1Group));
            allEPeopleAdded.add(this.createEPersonAndAddToGroup("allMemberGroups3@dspace.org", this.level2Group));
            Assert.assertTrue((boolean)this.groupService.allMembers(this.context, this.topGroup).containsAll(allEPeopleAdded));
            Assert.assertTrue((boolean)this.groupService.allMembers(this.context, this.level1Group).containsAll(allEPeopleAdded.subList(1, 2)));
            Assert.assertTrue((boolean)this.groupService.allMembers(this.context, this.level2Group).containsAll(allEPeopleAdded.subList(2, 2)));
        }
        finally {
            for (EPerson ePerson : allEPeopleAdded) {
                this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            }
            this.context.restoreAuthSystemState();
        }
    }

    @Test
    public void isEmpty() throws SQLException, AuthorizeException, EPersonDeletionException, IOException {
        Assert.assertTrue((boolean)this.groupService.isEmpty(this.topGroup));
        Assert.assertTrue((boolean)this.groupService.isEmpty(this.level1Group));
        Assert.assertTrue((boolean)this.groupService.isEmpty(this.level2Group));
        EPerson person = this.createEPersonAndAddToGroup("isEmpty@dspace.org", this.level2Group);
        Assert.assertFalse((boolean)this.groupService.isEmpty(this.topGroup));
        Assert.assertFalse((boolean)this.groupService.isEmpty(this.level1Group));
        Assert.assertFalse((boolean)this.groupService.isEmpty(this.level2Group));
        this.context.turnOffAuthorisationSystem();
        this.ePersonService.delete(this.context, (DSpaceObject)person);
        this.context.restoreAuthSystemState();
        Assert.assertTrue((boolean)this.groupService.isEmpty(this.level2Group));
    }

    protected Group createGroup(String name) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Group group = this.groupService.create(this.context);
        group.setName(name);
        this.groupService.update(this.context, (DSpaceObject)group);
        this.context.restoreAuthSystemState();
        return group;
    }

    protected EPerson createEPersonAndAddToGroup(String email, Group group) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = this.createEPerson(email);
        this.groupService.addMember(this.context, group, ePerson);
        this.groupService.update(this.context, (DSpaceObject)group);
        this.ePersonService.update(this.context, (DSpaceObject)ePerson);
        this.context.restoreAuthSystemState();
        return ePerson;
    }

    protected EPerson createEPerson(String email) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        EPerson ePerson = this.ePersonService.create(this.context);
        ePerson.setEmail(email);
        this.ePersonService.update(this.context, (DSpaceObject)ePerson);
        this.context.restoreAuthSystemState();
        return ePerson;
    }
}

