/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.InputStream;
import java.util.Locale;
import org.dspace.builder.AbstractBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.LicenseUtils;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.event.Event;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;

public class ClaimedTaskBuilder
extends AbstractBuilder<ClaimedTask, ClaimedTaskService> {
    private WorkspaceItem workspaceItem;
    private XmlWorkflowItem workflowItem;
    private ClaimedTask claimedTask;
    private EPerson user;

    protected ClaimedTaskBuilder(Context context) {
        super(context);
    }

    public static ClaimedTaskBuilder createClaimedTask(Context context, Collection col, EPerson user) {
        ClaimedTaskBuilder builder = new ClaimedTaskBuilder(context);
        return builder.create(context, col, user);
    }

    private ClaimedTaskBuilder create(Context context, Collection col, EPerson user) {
        this.context = context;
        this.user = user;
        try {
            this.workspaceItem = workspaceItemService.create(context, col, false);
        }
        catch (Exception e) {
            return (ClaimedTaskBuilder)this.handleException(e);
        }
        return this;
    }

    @Override
    public ClaimedTask build() {
        try {
            this.workflowItem = (XmlWorkflowItem)workflowService.start(this.context, this.workspaceItem);
            this.workspaceItem = null;
            PoolTask task = poolTaskService.findByWorkflowIdAndEPerson(this.context, this.workflowItem, this.user);
            EPerson submitter = this.context.getCurrentUser();
            this.context.setCurrentUser(this.user);
            XmlWorkflowServiceFactory factory = XmlWorkflowServiceFactory.getInstance();
            Workflow workflow = factory.getWorkflowFactory().getWorkflow(task.getWorkflowItem().getCollection());
            Step step = workflow.getStep(task.getStepID());
            WorkflowActionConfig currentActionConfig = step.getActionConfig(task.getActionID());
            workflowService.doState(this.context, this.user, null, task.getWorkflowItem().getID().intValue(), workflow, currentActionConfig);
            this.context.addEvent(new Event(2, 2, task.getWorkflowItem().getItem().getID(), null, itemService.getIdentifiers(this.context, (DSpaceObject)task.getWorkflowItem().getItem())));
            this.claimedTask = this.getService().findByWorkflowIdAndEPerson(this.context, this.workflowItem, this.user);
            this.context.setCurrentUser(submitter);
            this.context.dispatchEvents();
            indexingService.commit();
            return this.claimedTask;
        }
        catch (Exception e) {
            return (ClaimedTask)this.handleException(e);
        }
    }

    @Override
    public void delete(Context c, ClaimedTask claimedTask) throws Exception {
        if (claimedTask != null) {
            WorkflowItemBuilder.deleteWorkflowItem(claimedTask.getWorkflowItem().getID());
        }
    }

    private void deleteWsi(Context c, WorkspaceItem dso) throws Exception {
        if (dso != null) {
            workspaceItemService.deleteAll(c, dso);
        }
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.workspaceItem = (WorkspaceItem)c.reloadEntity((ReloadableEntity)this.workspaceItem);
            this.workflowItem = (XmlWorkflowItem)c.reloadEntity((ReloadableEntity)this.workflowItem);
            if (this.workspaceItem != null) {
                this.deleteWsi(c, this.workspaceItem);
            }
            if (this.workflowItem != null) {
                WorkflowItemBuilder.deleteWorkflowItem(this.workflowItem.getID());
            }
        }
    }

    @Override
    protected ClaimedTaskService getService() {
        return claimedTaskService;
    }

    protected ClaimedTaskBuilder addMetadataValue(String schema, String element, String qualifier, String value) {
        try {
            itemService.addMetadata(this.context, (DSpaceObject)this.workspaceItem.getItem(), schema, element, qualifier, "*", value);
        }
        catch (Exception e) {
            return (ClaimedTaskBuilder)this.handleException(e);
        }
        return this;
    }

    protected ClaimedTaskBuilder setMetadataSingleValue(String schema, String element, String qualifier, String value) {
        try {
            itemService.setMetadataSingleValue(this.context, (DSpaceObject)this.workspaceItem.getItem(), schema, element, qualifier, "*", value);
        }
        catch (Exception e) {
            return (ClaimedTaskBuilder)this.handleException(e);
        }
        return this;
    }

    public ClaimedTaskBuilder withTitle(String title) {
        return this.setMetadataSingleValue(MetadataSchemaEnum.DC.getName(), "title", null, title);
    }

    public ClaimedTaskBuilder withIssueDate(String issueDate) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "date", "issued", new DCDate(issueDate).toString());
    }

    public ClaimedTaskBuilder withAuthor(String authorName) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "contributor", "author", authorName);
    }

    public ClaimedTaskBuilder withSubject(String subject) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "subject", null, subject);
    }

    public ClaimedTaskBuilder grantLicense() {
        Item item = this.workspaceItem.getItem();
        try {
            EPerson submitter = this.workspaceItem.getSubmitter();
            submitter = (EPerson)this.context.reloadEntity((ReloadableEntity)submitter);
            String license = LicenseUtils.getLicenseText((Locale)this.context.getCurrentLocale(), (Collection)this.workspaceItem.getCollection(), (Item)item, (EPerson)submitter);
            LicenseUtils.grantLicense((Context)this.context, (Item)item, (String)license, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }

    public ClaimedTaskBuilder withFulltext(String name, String source, InputStream is) {
        try {
            Item item = this.workspaceItem.getItem();
            Bitstream b = itemService.createSingleBitstream(this.context, is, item);
            b.setName(this.context, name);
            b.setSource(this.context, source);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }
}

