/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.EntityType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;

public class EntityTypeBuilder
extends AbstractBuilder<EntityType, EntityTypeService> {
    private static final Logger log = Logger.getLogger(EntityTypeBuilder.class);
    private EntityType entityType;

    protected EntityTypeBuilder(Context context) {
        super(context);
    }

    @Override
    protected EntityTypeService getService() {
        return entityTypeService;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.entityType = (EntityType)c.reloadEntity((ReloadableEntity)this.entityType);
            if (this.entityType != null) {
                this.delete(this.entityType);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, EntityType dso) throws Exception {
        if (dso != null) {
            this.getService().delete(c, (Object)dso);
        }
    }

    @Override
    public EntityType build() {
        try {
            entityTypeService.update(this.context, (Object)this.entityType);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (SQLException | AuthorizeException | SearchServiceException e) {
            log.error((Object)e);
        }
        return this.entityType;
    }

    public void delete(EntityType entityType) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            EntityType attachedEntityType = (EntityType)c.reloadEntity((ReloadableEntity)entityType);
            if (attachedEntityType != null) {
                this.getService().delete(c, (Object)attachedEntityType);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static EntityTypeBuilder createEntityTypeBuilder(Context context, String entityType) {
        EntityTypeBuilder entityTypeBuilder = new EntityTypeBuilder(context);
        return entityTypeBuilder.create(context, entityType);
    }

    private EntityTypeBuilder create(Context context, String entityType) {
        try {
            this.context = context;
            this.entityType = entityTypeService.create(context, entityType);
        }
        catch (SQLException | AuthorizeException e) {
            log.warn((Object)"Failed to create the EntityType", e);
        }
        return this;
    }
}

