/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class ResourcePolicyBuilder
extends AbstractBuilder<ResourcePolicy, ResourcePolicyService> {
    private static final Logger log = Logger.getLogger(ResourcePolicyBuilder.class);
    private ResourcePolicy resourcePolicy;

    protected ResourcePolicyBuilder(Context context) {
        super(context);
    }

    @Override
    protected ResourcePolicyService getService() {
        return resourcePolicyService;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.resourcePolicy = (ResourcePolicy)c.reloadEntity((ReloadableEntity)this.resourcePolicy);
            if (this.resourcePolicy != null) {
                this.delete(c, this.resourcePolicy);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, ResourcePolicy dso) throws Exception {
        if (dso != null) {
            this.getService().delete(c, (Object)dso);
        }
    }

    @Override
    public ResourcePolicy build() {
        try {
            resourcePolicyService.update(this.context, (Object)this.resourcePolicy);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (SearchServiceException e) {
            log.error((Object)e);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        catch (AuthorizeException e) {
            log.error((Object)e);
        }
        return this.resourcePolicy;
    }

    public void delete(ResourcePolicy rp) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            ResourcePolicy attachedDso = (ResourcePolicy)c.reloadEntity((ReloadableEntity)rp);
            if (attachedDso != null) {
                this.getService().delete(c, (Object)attachedDso);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static void delete(Integer id) throws SQLException, IOException, SearchServiceException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            ResourcePolicy rp = (ResourcePolicy)resourcePolicyService.find(c, id.intValue());
            if (rp != null) {
                try {
                    resourcePolicyService.delete(c, (Object)rp);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static ResourcePolicyBuilder createResourcePolicy(Context context) throws SQLException, AuthorizeException {
        ResourcePolicyBuilder resourcePolicyBuilder = new ResourcePolicyBuilder(context);
        return resourcePolicyBuilder.create(context);
    }

    private ResourcePolicyBuilder create(Context context) throws SQLException, AuthorizeException {
        this.context = context;
        this.resourcePolicy = (ResourcePolicy)resourcePolicyService.create(context);
        return this;
    }

    public ResourcePolicyBuilder withUser(EPerson ePerson) throws SQLException {
        this.resourcePolicy.setEPerson(ePerson);
        return this;
    }

    public ResourcePolicyBuilder withGroup(Group epersonGroup) throws SQLException {
        this.resourcePolicy.setGroup(epersonGroup);
        return this;
    }

    public ResourcePolicyBuilder withAction(int action) throws SQLException {
        this.resourcePolicy.setAction(action);
        return this;
    }

    public ResourcePolicyBuilder withDspaceObject(DSpaceObject dspaceObject) throws SQLException {
        this.resourcePolicy.setdSpaceObject(dspaceObject);
        return this;
    }

    public ResourcePolicyBuilder withPolicyType(String policyType) {
        this.resourcePolicy.setRpType(policyType);
        return this;
    }

    public ResourcePolicyBuilder withStartDate(Date data) throws SQLException {
        this.resourcePolicy.setStartDate(data);
        return this;
    }

    public ResourcePolicyBuilder withEndDate(Date data) throws SQLException {
        this.resourcePolicy.setEndDate(data);
        return this;
    }

    public ResourcePolicyBuilder withDescription(String description) throws SQLException {
        this.resourcePolicy.setRpDescription(description);
        return this;
    }

    public ResourcePolicyBuilder withName(String name) throws SQLException {
        this.resourcePolicy.setRpName(name);
        return this;
    }
}

