/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.test.util.ReflectionTestUtils;

public class MetadataFieldTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(MetadataFieldTest.class);
    private MetadataField mf;
    private MetadataSchema dcSchema;
    private String element = "contributor";
    private String qualifier = "author";
    private String scopeNote = "scope note";
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private AuthorizeService authorizeServiceSpy;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.dcSchema = this.metadataSchemaService.find(this.context, MetadataSchemaEnum.DC.getName());
            this.mf = this.metadataFieldService.findByElement(this.context, MetadataSchemaEnum.DC.getName(), this.element, this.qualifier);
            if (this.mf == null) {
                this.context.turnOffAuthorisationSystem();
                this.mf = this.metadataFieldService.create(this.context, this.metadataSchemaService.find(this.context, MetadataSchemaEnum.DC.getName()), this.element, this.qualifier, this.scopeNote);
                this.context.restoreAuthSystemState();
            }
            this.mf.setScopeNote(this.scopeNote);
            this.authorizeServiceSpy = (AuthorizeService)Mockito.spy((Object)this.authorizeService);
            ReflectionTestUtils.setField((Object)this.metadataFieldService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
            ReflectionTestUtils.setField((Object)this.metadataSchemaService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (NonUniqueMetadataException ex) {
            log.error("NonUniqueMetadataException Error in init", (Throwable)ex);
            Assert.fail((String)("NonUniqueMetadataException Error in init: " + ex.getMessage()));
        }
        catch (AuthorizeException ex) {
            log.error("AuthorizeException Error in init", (Throwable)ex);
            Assert.fail((String)("AuthorizeException Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.mf = null;
        super.destroy();
    }

    @Test
    public void testGetElement() {
        Assert.assertThat((String)"testGetElement 0", (Object)this.mf.getElement(), (Matcher)CoreMatchers.equalTo((Object)this.element));
    }

    @Test
    public void testSetElement() {
        String elem = "newelem";
        this.mf.setElement(elem);
        Assert.assertThat((String)"testSetElement 0", (Object)this.mf.getElement(), (Matcher)CoreMatchers.equalTo((Object)elem));
    }

    @Test
    public void testGetFieldID() {
        Assert.assertTrue((String)"testGetFieldID 0", (this.mf.getID() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetQualifier() {
        Assert.assertThat((String)"testGetQualifier 0", (Object)this.mf.getQualifier(), (Matcher)CoreMatchers.equalTo((Object)this.qualifier));
    }

    @Test
    public void testSetQualifier() {
        String qual = "qualif";
        this.mf.setQualifier(qual);
        Assert.assertThat((String)"testSetQualifier 0", (Object)this.mf.getQualifier(), (Matcher)CoreMatchers.equalTo((Object)qual));
    }

    @Test
    public void testGetSchema() {
        Assert.assertThat((String)"testGetSchemaID 0", (Object)this.mf.getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.DC.getName()));
    }

    @Test
    public void testSetSchema() throws NonUniqueMetadataException, SQLException, AuthorizeException {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        MetadataSchema newSchema = this.metadataSchemaService.create(this.context, "testSetSchema", "testSetSchemaNS");
        this.mf.setMetadataSchema(newSchema);
        Assert.assertThat((String)"testSetSchemaID 0", (Object)this.mf.getMetadataSchema(), (Matcher)CoreMatchers.equalTo((Object)newSchema));
    }

    @Test
    public void testGetScopeNote() {
        Assert.assertThat((String)"testGetScopeNote 0", (Object)this.mf.getScopeNote(), (Matcher)CoreMatchers.equalTo((Object)this.scopeNote));
    }

    @Test
    public void testSetScopeNote() {
        String scn = "new scope note";
        this.mf.setScopeNote(scn);
        Assert.assertThat((String)"testSetScopeNote 0", (Object)this.mf.getScopeNote(), (Matcher)CoreMatchers.equalTo((Object)scn));
    }

    @Test
    public void testCreateAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String elem = "elem1";
        String qual = "qual1";
        MetadataField m = this.metadataFieldService.create(this.context, this.dcSchema, elem, qual, null);
        MetadataField found = this.metadataFieldService.findByElement(this.context, this.dcSchema, elem, qual);
        Assert.assertThat((String)"testCreateAuth 0", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)m.getID()));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth() throws Exception {
        String elem = "elem1";
        String qual = "qual1";
        this.metadataFieldService.create(this.context, this.dcSchema, elem, qual, null);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=NonUniqueMetadataException.class)
    public void testCreateRepeated() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String elem = this.element;
        String qual = this.qualifier;
        this.metadataFieldService.create(this.context, this.dcSchema, elem, qual, null);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindByElement() throws Exception {
        MetadataField found = this.metadataFieldService.findByElement(this.context, MetadataSchemaEnum.DC.getName(), this.element, this.qualifier);
        Assert.assertThat((String)"testFindByElement 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFindByElement 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getID()));
        Assert.assertThat((String)"testFindByElement 2", (Object)found.getElement(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getElement()));
        Assert.assertThat((String)"testFindByElement 3", (Object)found.getQualifier(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getQualifier()));
    }

    @Test
    public void testFindAll() throws Exception {
        List found = this.metadataFieldService.findAll(this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (found.size() >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (MetadataField mdf : found) {
            if (!mdf.equals((Object)this.mf)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testFindAllInSchema() throws Exception {
        List found = this.metadataFieldService.findAllInSchema(this.context, this.metadataSchemaService.find(this.context, MetadataSchemaEnum.DC.getName()));
        Assert.assertThat((String)"testFindAllInSchema 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAllInSchema 1", (found.size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testFindAllInSchema 2", (found.size() <= this.metadataFieldService.findAll(this.context).size() ? 1 : 0) != 0);
        boolean added = false;
        for (MetadataField mdf : found) {
            if (!mdf.equals((Object)this.mf)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAllInSchema 3", (boolean)added);
    }

    @Test
    public void testUpdateAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String elem = "elem2";
        String qual = "qual2";
        MetadataField m = this.metadataFieldService.create(this.context, this.dcSchema, elem, qual, null);
        this.metadataFieldService.update(this.context, m);
        MetadataField found = this.metadataFieldService.findByElement(this.context, MetadataSchemaEnum.DC.getName(), elem, qual);
        Assert.assertThat((String)"testUpdateAuth 0", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)m.getID()));
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        String elem = "elem2";
        String qual = "qual2";
        MetadataField m = this.metadataFieldService.create(this.context, this.dcSchema, elem, qual, null);
        this.metadataFieldService.update(this.context, m);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=NonUniqueMetadataException.class)
    public void testUpdateRepeated() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String elem = this.element;
        String qual = this.qualifier;
        MetadataField m = this.metadataFieldService.create(this.context, this.dcSchema, elem, qual, null);
        m.setElement(elem);
        m.setQualifier(qual);
        this.metadataFieldService.update(this.context, m);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDeleteAuth() throws Exception {
        Mockito.when((Object)this.authorizeServiceSpy.isAdmin(this.context)).thenReturn((Object)true);
        String elem = "elem3";
        String qual = "qual3";
        MetadataField m = this.metadataFieldService.create(this.context, this.dcSchema, elem, qual, null);
        this.metadataFieldService.delete(this.context, m);
        MetadataField found = this.metadataFieldService.findByElement(this.context, MetadataSchemaEnum.DC.getName(), elem, qual);
        Assert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        String elem = "elem3";
        String qual = "qual3";
        MetadataField m = this.metadataFieldService.create(this.context, this.dcSchema, elem, qual, null);
        this.metadataFieldService.delete(this.context, m);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFind() throws Exception {
        int id = this.mf.getID();
        MetadataField found = this.metadataFieldService.find(this.context, id);
        Assert.assertThat((String)"testFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)this.mf.getID()));
    }
}

