/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataService;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.EntityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RelationshipMetadataServiceTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(RelationshipMetadataServiceTest.class);
    protected RelationshipMetadataService relationshipMetadataService = ContentServiceFactory.getInstance().getRelationshipMetadataService();
    protected RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    protected RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
    protected EntityService entityService = ContentServiceFactory.getInstance().getEntityService();
    protected EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    Item leftItem;
    Item rightItem;
    Relationship relationship;
    RelationshipType isAuthorOfPublicationRelationshipType;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            Community community = this.communityService.create(null, this.context);
            Collection col = this.collectionService.create(this.context, community);
            WorkspaceItem leftIs = this.workspaceItemService.create(this.context, col, false);
            WorkspaceItem rightIs = this.workspaceItemService.create(this.context, col, false);
            this.leftItem = this.installItemService.installItem(this.context, (InProgressSubmission)leftIs);
            this.rightItem = this.installItemService.installItem(this.context, (InProgressSubmission)rightIs);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.abort();
        super.destroy();
    }

    private void initPublicationAuthor() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.leftItem, "relationship", "type", null, null, "Publication");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.rightItem, "relationship", "type", null, null, "Author");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.rightItem, "person", "familyName", null, null, "familyName");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.rightItem, "person", "givenName", null, null, "firstName");
        EntityType publicationEntityType = this.entityTypeService.create(this.context, "Publication");
        EntityType authorEntityType = this.entityTypeService.create(this.context, "Author");
        this.isAuthorOfPublicationRelationshipType = this.relationshipTypeService.create(this.context, publicationEntityType, authorEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null);
        this.relationship = this.relationshipService.create(this.context, this.leftItem, this.rightItem, this.isAuthorOfPublicationRelationshipType, 0, 0);
        this.context.restoreAuthSystemState();
    }

    private void initPublicationAuthorWithCopyParams(boolean copyToLeft, boolean copyToRight) throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.leftItem, "relationship", "type", null, null, "Publication");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.rightItem, "relationship", "type", null, null, "Author");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.rightItem, "person", "familyName", null, null, "familyName");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.rightItem, "person", "givenName", null, null, "firstName");
        EntityType publicationEntityType = this.entityTypeService.create(this.context, "Publication");
        EntityType authorEntityType = this.entityTypeService.create(this.context, "Author");
        RelationshipType isAuthorOfPublication = this.relationshipTypeService.create(this.context, publicationEntityType, authorEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null, Boolean.valueOf(copyToLeft), Boolean.valueOf(copyToRight));
        this.relationship = this.relationshipService.create(this.context, this.leftItem, this.rightItem, isAuthorOfPublication, 0, 0);
        this.context.restoreAuthSystemState();
    }

    private void initJournalVolumeIssue() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.leftItem, "relationship", "type", null, null, "JournalIssue");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.rightItem, "relationship", "type", null, null, "JournalVolume");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.leftItem, "publicationissue", "issueNumber", null, null, "2");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.rightItem, "publicationvolume", "volumeNumber", null, null, "30");
        EntityType journalIssueEntityType = this.entityTypeService.create(this.context, "JournalIssue");
        EntityType publicationVolumeEntityType = this.entityTypeService.create(this.context, "JournalVolume");
        RelationshipType isIssueOfVolume = this.relationshipTypeService.create(this.context, journalIssueEntityType, publicationVolumeEntityType, "isJournalVolumeOfIssue", "isIssueOfJournalVolume", null, null, null, null);
        this.relationship = this.relationshipService.create(this.context, this.leftItem, this.rightItem, isIssueOfVolume, 0, 0);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testGetAuthorRelationshipMetadata() throws SQLException, AuthorizeException {
        this.initPublicationAuthor();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)relationshipMetadataList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.rightItem.getID())));
        List list = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((RelationshipMetadataValue)list.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        Assert.assertThat((Object)((RelationshipMetadataValue)list.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        Assert.assertThat((Object)((RelationshipMetadataValue)list.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        Assert.assertThat((Object)((RelationshipMetadataValue)list.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertThat((Object)((RelationshipMetadataValue)list.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        Assert.assertThat((Object)((RelationshipMetadataValue)list.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.rightItem.getID())));
        Assert.assertThat((Object)((RelationshipMetadataValue)list.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        Assert.assertThat((Object)((RelationshipMetadataValue)list.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isAuthorOfPublication"));
        Assert.assertThat((Object)((RelationshipMetadataValue)list.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToLeftItem() throws Exception {
        this.initPublicationAuthor();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, true, false);
        this.context.restoreAuthSystemState();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List list = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testAuthorDeleteRelationshipCopyToRightItem() throws Exception {
        this.initPublicationAuthor();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, false, true);
        this.context.restoreAuthSystemState();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToBothItems() throws Exception {
        this.initPublicationAuthor();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, true, true);
        this.context.restoreAuthSystemState();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testGetJournalRelationshipMetadata() throws SQLException, AuthorizeException {
        this.initJournalVolumeIssue();
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        Assert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)volumeList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        Assert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)issueList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        List issueRelList = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        Assert.assertThat((Object)issueRelList.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        Assert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"publicationvolume"));
        Assert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"volumeNumber"));
        Assert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        Assert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.rightItem.getID())));
        Assert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        Assert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isJournalVolumeOfIssue"));
        Assert.assertThat((Object)((RelationshipMetadataValue)issueRelList.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        List volumeRelList = this.relationshipMetadataService.getRelationshipMetadata(this.rightItem, true);
        Assert.assertThat((Object)volumeRelList.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        Assert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"publicationissue"));
        Assert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"issueNumber"));
        Assert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo(null));
        Assert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        Assert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.leftItem.getID())));
        Assert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        Assert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isIssueOfJournalVolume"));
        Assert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
    }

    @Test
    public void testDeleteJournalRelationshipCopyToLeftItem() throws SQLException, AuthorizeException {
        this.initJournalVolumeIssue();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, true, false);
        this.context.restoreAuthSystemState();
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        Assert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)volumeList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        Assert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testJournalDeleteRelationshipCopyToRightItem() throws SQLException, AuthorizeException {
        this.initJournalVolumeIssue();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, false, true);
        this.context.restoreAuthSystemState();
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        Assert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        Assert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)issueList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
    }

    @Test
    public void testDeleteJournalRelationshipCopyToBothItems() throws SQLException, AuthorizeException {
        this.initJournalVolumeIssue();
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, this.relationship, true, true);
        this.context.restoreAuthSystemState();
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        Assert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)volumeList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"30"));
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        Assert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)issueList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToLeftItemFromDefaultInDb() throws Exception {
        this.initPublicationAuthorWithCopyParams(true, false);
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, (Object)this.relationship);
        this.context.restoreAuthSystemState();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List list = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testAuthorDeleteRelationshipCopyToRightItemFromDefaultInDb() throws Exception {
        this.initPublicationAuthorWithCopyParams(false, true);
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, (Object)this.relationship);
        this.context.restoreAuthSystemState();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testDeleteAuthorRelationshipCopyToBothItemsFromDefaultsInDb() throws Exception {
        this.initPublicationAuthorWithCopyParams(true, true);
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, (Object)this.relationship);
        this.context.restoreAuthSystemState();
        List authorList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "dc", "contributor", "author", "*");
        Assert.assertThat((Object)authorList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"familyName, firstName"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"dc"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"contributor"));
        Assert.assertThat((Object)((MetadataValue)authorList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)"author"));
        Assert.assertNull((Object)((MetadataValue)authorList.get(0)).getAuthority());
        List relationshipMetadataList = this.itemService.getMetadata((DSpaceObject)this.leftItem, MetadataSchemaEnum.RELATION.getName(), "isAuthorOfPublication", null, "*");
        Assert.assertThat((Object)relationshipMetadataList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testGetNextRightPlace() throws Exception {
        Assert.assertThat((Object)this.relationshipService.findNextRightPlaceByRightItem(this.context, this.rightItem), (Matcher)CoreMatchers.equalTo((Object)0));
        this.initPublicationAuthor();
        Assert.assertThat((Object)this.relationshipService.findNextRightPlaceByRightItem(this.context, this.rightItem), (Matcher)CoreMatchers.equalTo((Object)1));
        this.context.turnOffAuthorisationSystem();
        Community community = this.communityService.create(null, this.context);
        Collection col = this.collectionService.create(this.context, community);
        WorkspaceItem is = this.workspaceItemService.create(this.context, col, false);
        Item secondItem = this.installItemService.installItem(this.context, (InProgressSubmission)is);
        this.itemService.addMetadata(this.context, (DSpaceObject)secondItem, "relationship", "type", null, null, "Publication");
        this.relationshipService.create(this.context, secondItem, this.rightItem, this.isAuthorOfPublicationRelationshipType, 0, 0);
        this.context.restoreAuthSystemState();
        Assert.assertThat((Object)this.relationshipService.findNextRightPlaceByRightItem(this.context, this.rightItem), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testGetNextLeftPlace() throws Exception {
        Assert.assertThat((Object)this.relationshipService.findNextLeftPlaceByLeftItem(this.context, this.leftItem), (Matcher)CoreMatchers.equalTo((Object)0));
        this.initPublicationAuthor();
        Assert.assertThat((Object)this.relationshipService.findNextLeftPlaceByLeftItem(this.context, this.leftItem), (Matcher)CoreMatchers.equalTo((Object)1));
        this.context.turnOffAuthorisationSystem();
        Community community = this.communityService.create(null, this.context);
        Collection col = this.collectionService.create(this.context, community);
        WorkspaceItem is = this.workspaceItemService.create(this.context, col, false);
        Item secondAuthor = this.installItemService.installItem(this.context, (InProgressSubmission)is);
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthor, "relationship", "type", null, null, "Author");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthor, "person", "familyName", null, null, "familyName");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthor, "person", "givenName", null, null, "firstName");
        this.relationshipService.create(this.context, this.leftItem, secondAuthor, this.isAuthorOfPublicationRelationshipType, 0, 0);
        this.context.restoreAuthSystemState();
        Assert.assertThat((Object)this.relationshipService.findNextLeftPlaceByLeftItem(this.context, this.leftItem), (Matcher)CoreMatchers.equalTo((Object)2));
    }
}

