/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.util.Locale;
import org.dspace.AbstractDSpaceTest;
import org.dspace.core.I18nUtil;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class I18nUtilTest
extends AbstractDSpaceTest {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetMessage_String() {
        System.out.println("getMessage");
        ConfigurationService configService = DSpaceServicesFactory.getInstance().getConfigurationService();
        configService.setProperty("default.locale", (Object)"en_US.UTF-8");
        Assert.assertEquals((String)"Default locale", (Object)new Locale("en", "US", "UTF-8"), (Object)I18nUtil.getDefaultLocale());
        String key = "jsp.general.home";
        String expResult = "DSpace Home";
        String result = I18nUtil.getMessage((String)key);
        Assert.assertEquals((String)"Returns the translation of the key if it is defined", (Object)expResult, (Object)result);
        expResult = "bogus key";
        key = "bogus key";
        result = I18nUtil.getMessage((String)key);
        Assert.assertEquals((String)"Returns the key if it is not defined", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetMessage_String_Locale() {
        System.out.println("getMessage");
        Locale locale = Locale.US;
        String key = "jsp.general.home";
        String expResult = "DSpace Home";
        String result = I18nUtil.getMessage((String)key, (Locale)locale);
        Assert.assertEquals((String)"Returns the translation of the key if it is defined", (Object)expResult, (Object)result);
        expResult = "bogus key";
        key = "bogus key";
        result = I18nUtil.getMessage((String)key, (Locale)locale);
        Assert.assertEquals((String)"Returns the key if it is not defined", (Object)expResult, (Object)result);
    }
}

