/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.util.HashMap;
import org.dspace.AbstractUnitTest;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.SiteService;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.ctask.general.NoOpCurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.DummyTask;
import org.dspace.services.ConfigurationService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CuratorTest
extends AbstractUnitTest {
    private static final SiteService SITE_SERVICE = ContentServiceFactory.getInstance().getSiteService();
    static final String RUN_PARAMETER_NAME = "runParameter";
    static final String RUN_PARAMETER_VALUE = "a parameter";
    static final String TASK_PROPERTY_NAME = "taskProperty";
    static final String TASK_PROPERTY_VALUE = "a property";
    static String runParameter;
    static String taskProperty;

    @Test
    public void testCurate_DSpaceObject() throws Exception {
        CoreServiceFactory.getInstance().getPluginService().clearNamedPluginClasses();
        String TASK_NAME = "dummyTask";
        ConfigurationService cfg = kernelImpl.getConfigurationService();
        cfg.setProperty("plugin.named.org.dspace.curate.CurationTask", (Object)(DummyTask.class.getName() + " = dummyTask"));
        cfg.setProperty("dummyTask.taskProperty", (Object)TASK_PROPERTY_VALUE);
        Curator instance = new Curator();
        instance.setReporter((Appendable)System.out);
        instance.addTask("dummyTask");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(RUN_PARAMETER_NAME, RUN_PARAMETER_VALUE);
        instance.addParameters(parameters);
        Site dso = SITE_SERVICE.findSite(this.context);
        instance.curate(this.context, (DSpaceObject)dso);
        System.out.format("Task %s result was '%s'%n", "dummyTask", instance.getResult("dummyTask"));
        System.out.format("Task %s status was %d%n", "dummyTask", instance.getStatus("dummyTask"));
        Assert.assertEquals((String)"Unexpected task status", (long)0L, (long)instance.getStatus("dummyTask"));
        Assert.assertEquals((String)"Wrong run parameter", (Object)RUN_PARAMETER_VALUE, (Object)runParameter);
        Assert.assertEquals((String)"Wrong task property", (Object)TASK_PROPERTY_VALUE, (Object)taskProperty);
    }

    @Test
    public void testCurate_NoOpTask() throws Exception {
        CoreServiceFactory.getInstance().getPluginService().clearNamedPluginClasses();
        String TASK_NAME = "noop";
        ConfigurationService cfg = kernelImpl.getConfigurationService();
        cfg.setProperty("plugin.named.org.dspace.curate.CurationTask", (Object)(NoOpCurationTask.class.getName() + " = noop"));
        Curator curator = new Curator();
        StringBuilder reporterOutput = new StringBuilder();
        curator.setReporter((Appendable)reporterOutput);
        curator.addTask("noop");
        Item item = (Item)Mockito.mock(Item.class);
        Mockito.when((Object)item.getType()).thenReturn((Object)2);
        Mockito.when((Object)item.getHandle()).thenReturn((Object)"testHandle");
        curator.curate(this.context, (DSpaceObject)item);
        Assert.assertEquals((long)0L, (long)curator.getStatus("noop"));
        Assert.assertEquals((Object)"No operation performed on testHandle", (Object)reporterOutput.toString());
    }
}

