/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Curator;
import org.dspace.services.ConfigurationService;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITCurator
extends AbstractUnitTest {
    Logger LOG = LoggerFactory.getLogger(ITCurator.class);

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCurate_Reporting() throws SQLException, IOException, AuthorizeException {
        ConfigurationService cfg = kernelImpl.getConfigurationService();
        cfg.setProperty("plugin.named.org.dspace.curate.CurationTask", (Object)(Task1.class.getName() + " = task1"));
        cfg.addPropertyValue("plugin.named.org.dspace.curate.CurationTask", (Object)(Task2.class.getName() + " = task2"));
        this.context.turnOffAuthorisationSystem();
        Site site = ContentServiceFactory.getInstance().getSiteService().findSite(this.context);
        Community community = ContentServiceFactory.getInstance().getCommunityService().create(null, this.context);
        ListReporter reporter = new ListReporter();
        Curator curator = new Curator();
        curator.setReporter((Appendable)reporter);
        curator.addTask("task1");
        curator.addTask("task2");
        curator.curate(this.context, (DSpaceObject)site);
        List<String> report = reporter.getReport();
        for (String aReport : report) {
            this.LOG.info("Report:  {}", (Object)aReport);
        }
        Pattern pattern = Pattern.compile(String.format("task1.*%s", site.getHandle()));
        Assert.assertTrue((String)"A report should mention 'task1' and site's handle", (boolean)this.reportMatcher(report, pattern));
        pattern = Pattern.compile(String.format("task1.*%s", community.getHandle()));
        Assert.assertTrue((String)"A report should mention 'task1' and the community's handle", (boolean)this.reportMatcher(report, pattern));
        pattern = Pattern.compile(String.format("task2.*%s", site.getHandle()));
        Assert.assertTrue((String)"A report should mention 'task2' and the Site's handle", (boolean)this.reportMatcher(report, pattern));
        pattern = Pattern.compile(String.format("task2.*%s", community.getHandle()));
        Assert.assertTrue((String)"A report should mention 'task2' and the community's handle", (boolean)this.reportMatcher(report, pattern));
    }

    private boolean reportMatcher(List<String> reports, Pattern pattern) {
        for (String aReport : reports) {
            if (!pattern.matcher(aReport).find()) continue;
            return true;
        }
        return false;
    }

    static class ListReporter
    implements Appendable {
        private final List<String> report = new ArrayList<String>();

        ListReporter() {
        }

        List<String> getReport() {
            return this.report;
        }

        @Override
        public Appendable append(CharSequence cs) throws IOException {
            this.report.add(cs.toString());
            return this;
        }

        @Override
        public Appendable append(CharSequence cs, int i, int i1) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Appendable append(char c) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class Task2
    extends AbstractCurationTask {
        public int perform(DSpaceObject dso) throws IOException {
            this.curator.report(String.format("Task2 received 'perform' on taskId '%s' for object '%s'%n", this.taskId, dso.getHandle()));
            return 0;
        }
    }

    public static class Task1
    extends AbstractCurationTask {
        public int perform(DSpaceObject dso) throws IOException {
            this.curator.report(String.format("Task1 received 'perform' on taskId '%s' for object '%s'%n", this.taskId, dso.getHandle()));
            return 0;
        }
    }
}

