/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.doi.DOIConnector;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DOIIdentifierProviderTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(DOIIdentifierProviderTest.class);
    private static final String PREFIX = "10.5072";
    private static final String NAMESPACE_SEPARATOR = "dspaceUnitTests-";
    private static ConfigurationService config = null;
    protected DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    private static Community community;
    private static Collection collection;
    private static DOIConnector connector;
    private DOIIdentifierProvider provider;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            community = this.communityService.create(null, this.context);
            this.communityService.setMetadata(this.context, community, "name", "A Test Community");
            this.communityService.update(this.context, (DSpaceObject)community);
            collection = this.collectionService.create(this.context, community);
            this.collectionService.setMetadata(this.context, collection, "name", "A Test Collection");
            this.collectionService.update(this.context, (DSpaceObject)collection);
            this.context.restoreAuthSystemState();
            config = DSpaceServicesFactory.getInstance().getConfigurationService();
            config.setProperty("identifier.doi.prefix", (Object)PREFIX);
            config.setProperty("identifier.doi.namespaceseparator", (Object)NAMESPACE_SEPARATOR);
            connector = (DOIConnector)Mockito.mock(DOIConnector.class);
            this.provider = (DOIIdentifierProvider)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(DOIIdentifierProvider.class.getName(), DOIIdentifierProvider.class);
            this.provider.setConfigurationService(config);
            this.provider.setDOIConnector(connector);
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        community = null;
        collection = null;
        connector = null;
        this.provider = null;
        super.destroy();
    }

    private Item newItem() throws SQLException, AuthorizeException, IOException, IllegalAccessException, IdentifierException, WorkflowException {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wsItem = this.workspaceItemService.create(this.context, collection, false);
        WorkflowItem wfItem = WorkflowServiceFactory.getInstance().getWorkflowService().start(this.context, wsItem);
        Item item = wfItem.getItem();
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "contributor", "author", null, "Author, A. N.");
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "title", null, null, "A Test Object");
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "publisher", null, null, "DSpace Test Harness");
        this.provider.delete(this.context, (DSpaceObject)item);
        List metadata = this.itemService.getMetadata((DSpaceObject)item, "dc", "identifier", "uri", null);
        ArrayList<String> remainder = new ArrayList<String>();
        for (MetadataValue id : metadata) {
            if (id.getValue().startsWith("http://dx.doi.org")) continue;
            remainder.add(id.getValue());
        }
        this.itemService.clearMetadata(this.context, (DSpaceObject)item, "dc", "identifier", "uri", null);
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "identifier", "uri", null, remainder);
        this.itemService.update(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
        return item;
    }

    public String createDOI(Item item, Integer status, boolean metadata) throws SQLException, IdentifierException, AuthorizeException {
        return this.createDOI(item, status, metadata, null);
    }

    public String createDOI(Item item, Integer status, boolean metadata, String doi) throws SQLException, IdentifierException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Random random = new Random();
        if (null == doi) {
            doi = "doi:10.5072/dspaceUnitTests-" + Long.toHexString(new Date().getTime()) + "-" + random.nextInt(997);
        }
        DOI doiRow = this.doiService.create(this.context);
        doiRow.setDoi(((String)doi).substring("doi:".length()));
        doiRow.setDSpaceObject((DSpaceObject)item);
        doiRow.setStatus(status);
        this.doiService.update(this.context, doiRow);
        if (metadata) {
            this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "identifier", "uri", null, this.doiService.DOIToExternalForm((String)doi));
            this.itemService.update(this.context, (DSpaceObject)item);
        }
        this.context.restoreAuthSystemState();
        return doi;
    }

    @Test
    public void testSupports_Class() {
        Class<DOI> identifier = DOI.class;
        Assert.assertTrue((String)"DOI should be supported", (boolean)this.provider.supports(identifier));
    }

    @Test
    public void testSupports_valid_String() {
        String[] validDOIs;
        for (String doi : validDOIs = new String[]{"10.5072/123abc-lkj/kljl", "10.5072/dspaceUnitTests-lkjljasd1234", "doi:10.5072/123abc-lkj/kljl", "http://dx.doi.org/10.5072/123abc-lkj/kljl", "http://dx.doi.org/10.5072/123abc-lkj/kljl"}) {
            Assert.assertTrue((String)"DOI should be supported", (boolean)this.provider.supports(doi));
        }
    }

    @Test
    public void testDoes_not_support_invalid_String() {
        String[] invalidDOIs;
        for (String notADoi : invalidDOIs = new String[]{"11.5072/123abc-lkj/kljl", "http://hdl.handle.net/handle/10.5072/123abc-lkj/kljl", "", null}) {
            Assert.assertFalse((String)"Invalid DOIs shouldn't be supported", (boolean)this.provider.supports(notADoi));
        }
    }

    @Test
    public void testStore_DOI_as_item_metadata() throws SQLException, AuthorizeException, IOException, IdentifierException, IllegalAccessException, WorkflowException {
        Item item = this.newItem();
        String doi = "doi:10.5072/dspaceUnitTests-" + Long.toHexString(new Date().getTime());
        this.context.turnOffAuthorisationSystem();
        this.provider.saveDOIToObject(this.context, (DSpaceObject)item, doi);
        this.context.restoreAuthSystemState();
        List metadata = this.itemService.getMetadata((DSpaceObject)item, "dc", "identifier", "uri", null);
        boolean result = false;
        for (MetadataValue id : metadata) {
            if (!id.getValue().equals(this.doiService.DOIToExternalForm(doi))) continue;
            result = true;
        }
        Assert.assertTrue((String)"Cannot store DOI as item metadata value.", (boolean)result);
    }

    @Test
    public void testGet_DOI_out_of_item_metadata() throws SQLException, AuthorizeException, IOException, IdentifierException, IllegalAccessException, WorkflowException {
        Item item = this.newItem();
        String doi = "doi:10.5072/dspaceUnitTests-" + Long.toHexString(new Date().getTime());
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "identifier", "uri", null, this.doiService.DOIToExternalForm(doi));
        this.itemService.update(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
        Assert.assertTrue((String)"Failed to recognize DOI in item metadata.", (boolean)doi.equals(this.provider.getDOIOutOfObject((DSpaceObject)item)));
    }

    @Test
    public void testRemove_DOI_from_item_metadata() throws SQLException, AuthorizeException, IOException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = "doi:10.5072/dspaceUnitTests-" + Long.toHexString(new Date().getTime());
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "identifier", "uri", null, this.doiService.DOIToExternalForm(doi));
        this.itemService.update(this.context, (DSpaceObject)item);
        this.provider.removeDOIFromObject(this.context, (DSpaceObject)item, doi);
        this.context.restoreAuthSystemState();
        List metadata = this.itemService.getMetadata((DSpaceObject)item, "dc", "identifier", "uri", null);
        boolean foundDOI = false;
        for (MetadataValue id : metadata) {
            if (!id.getValue().equals(this.doiService.DOIToExternalForm(doi))) continue;
            foundDOI = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI);
    }

    @Test
    public void testGet_DOI_by_DSpaceObject() throws SQLException, AuthorizeException, IOException, IllegalArgumentException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, false);
        String retrievedDOI = this.provider.getDOIByObject(this.context, (DSpaceObject)item);
        Assert.assertNotNull((String)"Failed to load DOI by DSpaceObject.", (Object)retrievedDOI);
        Assert.assertTrue((String)"Loaded wrong DOI by DSpaceObject.", (boolean)doi.equals(retrievedDOI));
    }

    @Test
    public void testGet_DOI_lookup() throws SQLException, AuthorizeException, IOException, IllegalArgumentException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, false);
        String retrievedDOI = this.provider.lookup(this.context, (DSpaceObject)item);
        Assert.assertNotNull((String)"Failed to loookup doi.", (Object)retrievedDOI);
        Assert.assertTrue((String)"Loaded wrong DOI on lookup.", (boolean)doi.equals(retrievedDOI));
    }

    @Test
    public void testGet_DSpaceObject_by_DOI() throws SQLException, AuthorizeException, IOException, IllegalArgumentException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, false);
        DSpaceObject dso = this.provider.getObjectByDOI(this.context, doi);
        Assert.assertNotNull((String)"Failed to load DSpaceObject by DOI.", (Object)dso);
        if (item.getType() != dso.getType() || ObjectUtils.notEqual((Object)item.getID(), (Object)dso.getID())) {
            Assert.fail((String)"Object loaded by DOI was another object then expected!");
        }
    }

    @Test
    public void testResolve_DOI() throws SQLException, AuthorizeException, IOException, IllegalArgumentException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, false);
        DSpaceObject dso = this.provider.resolve(this.context, doi, new String[0]);
        Assert.assertNotNull((String)"Failed to resolve DOI.", (Object)dso);
        if (item.getType() != dso.getType() || ObjectUtils.notEqual((Object)item.getID(), (Object)dso.getID())) {
            Assert.fail((String)"Object return by DOI lookup was another object then expected!");
        }
    }

    @Test
    public void testRemove_two_DOIs_from_item_metadata() throws SQLException, AuthorizeException, IOException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi1 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        String doi2 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        this.context.turnOffAuthorisationSystem();
        this.provider.removeDOIFromObject(this.context, (DSpaceObject)item, doi1);
        this.context.restoreAuthSystemState();
        List metadata = this.itemService.getMetadata((DSpaceObject)item, "dc", "identifier", "uri", null);
        boolean foundDOI1 = false;
        boolean foundDOI2 = false;
        for (MetadataValue id : metadata) {
            if (id.getValue().equals(this.doiService.DOIToExternalForm(doi1))) {
                foundDOI1 = true;
            }
            if (!id.getValue().equals(this.doiService.DOIToExternalForm(doi2))) continue;
            foundDOI2 = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI1);
        Assert.assertTrue((String)"Removed wrong DOI from item metadata.", (boolean)foundDOI2);
        this.context.turnOffAuthorisationSystem();
        this.provider.removeDOIFromObject(this.context, (DSpaceObject)item, doi2);
        this.context.restoreAuthSystemState();
        metadata = this.itemService.getMetadata((DSpaceObject)item, "dc", "identifier", "uri", null);
        foundDOI1 = false;
        foundDOI2 = false;
        for (MetadataValue id : metadata) {
            if (id.getValue().equals(this.doiService.DOIToExternalForm(doi1))) {
                foundDOI1 = true;
            }
            if (!id.getValue().equals(this.doiService.DOIToExternalForm(doi2))) continue;
            foundDOI2 = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI1);
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI2);
    }

    @Test
    public void testMintDOI() throws SQLException, AuthorizeException, IOException, IllegalAccessException, IdentifierException, WorkflowException {
        Item item = this.newItem();
        String doi = null;
        try {
            doi = this.provider.mint(this.context, (DSpaceObject)item);
        }
        catch (IdentifierException e) {
            e.printStackTrace();
            Assert.fail((String)("Got an IdentifierException: " + e.getMessage()));
        }
        Assert.assertNotNull((String)"Minted DOI is null!", (Object)doi);
        Assert.assertFalse((String)"Minted DOI is empty!", (boolean)doi.isEmpty());
        try {
            this.doiService.formatIdentifier(doi);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Minted an unrecognizable DOI: " + e.getMessage()));
        }
    }

    @Test
    public void testMint_returns_existing_DOI() throws SQLException, AuthorizeException, IOException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = this.createDOI(item, null, true);
        String retrievedDOI = this.provider.mint(this.context, (DSpaceObject)item);
        Assert.assertNotNull((String)"Minted DOI is null?!", (Object)retrievedDOI);
        Assert.assertEquals((String)"Mint did not returned an existing DOI!", (Object)doi, (Object)retrievedDOI);
    }

    @Test
    public void testReserve_DOI() throws SQLException, SQLException, AuthorizeException, IOException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = this.createDOI(item, null, true);
        this.provider.reserve(this.context, (DSpaceObject)item, doi);
        DOI doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow});
        Assert.assertTrue((String)"Reservation of DOI did not set the corret DOI status.", (boolean)DOIIdentifierProvider.TO_BE_RESERVED.equals(doiRow.getStatus()));
    }

    @Test
    public void testRegister_unreserved_DOI() throws SQLException, SQLException, AuthorizeException, IOException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = this.createDOI(item, null, true);
        this.provider.register(this.context, (DSpaceObject)item, doi);
        DOI doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow});
        Assert.assertTrue((String)"Registration of DOI did not set the corret DOI status.", (boolean)DOIIdentifierProvider.TO_BE_REGISTERED.equals(doiRow.getStatus()));
    }

    @Test
    public void testRegister_reserved_DOI() throws SQLException, SQLException, AuthorizeException, IOException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = this.createDOI(item, DOIIdentifierProvider.IS_RESERVED, true);
        this.provider.register(this.context, (DSpaceObject)item, doi);
        DOI doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow});
        Assert.assertTrue((String)"Registration of DOI did not set the corret DOI status.", (boolean)DOIIdentifierProvider.TO_BE_REGISTERED.equals(doiRow.getStatus()));
    }

    @Test
    public void testCreate_and_Register_DOI() throws SQLException, SQLException, AuthorizeException, IOException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi = this.provider.register(this.context, (DSpaceObject)item);
        String formated_doi = this.doiService.formatIdentifier(doi);
        Assert.assertTrue((String)"DOI was not in the expected format!", (boolean)doi.equals(formated_doi));
        DOI doiRow = this.doiService.findByDoi(this.context, doi.substring("doi:".length()));
        Assert.assertNotNull((String)"Created DOI was not stored in database.", (Object)doiRow);
        Assert.assertTrue((String)"Registration of DOI did not set the corret DOI status.", (boolean)DOIIdentifierProvider.TO_BE_REGISTERED.equals(doiRow.getStatus()));
    }

    @Test
    public void testDelete_specified_DOI() throws SQLException, AuthorizeException, IOException, IdentifierException, WorkflowException, IllegalAccessException {
        Item item = this.newItem();
        String doi1 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        String doi2 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        this.context.turnOffAuthorisationSystem();
        this.provider.delete(this.context, (DSpaceObject)item, doi1);
        this.context.restoreAuthSystemState();
        List metadata = this.itemService.getMetadata((DSpaceObject)item, "dc", "identifier", "uri", null);
        boolean foundDOI1 = false;
        boolean foundDOI2 = false;
        for (MetadataValue id : metadata) {
            if (id.getValue().equals(this.doiService.DOIToExternalForm(doi1))) {
                foundDOI1 = true;
            }
            if (!id.getValue().equals(this.doiService.DOIToExternalForm(doi2))) continue;
            foundDOI2 = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI1);
        Assert.assertTrue((String)"Removed wrong DOI from item metadata.", (boolean)foundDOI2);
        DOI doiRow1 = this.doiService.findByDoi(this.context, doi1.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow1});
        Assert.assertTrue((String)"Status of deleted DOI was not set correctly.", (boolean)DOIIdentifierProvider.TO_BE_DELETED.equals(doiRow1.getStatus()));
        DOI doiRow2 = this.doiService.findByDoi(this.context, doi2.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow2});
        Assert.assertTrue((String)"While deleting a DOI the status of another changed.", (boolean)DOIIdentifierProvider.IS_REGISTERED.equals(doiRow2.getStatus()));
    }

    @Test
    public void testDelete_all_DOIs() throws SQLException, AuthorizeException, IOException, IdentifierException, IllegalAccessException, WorkflowException {
        Item item = this.newItem();
        String doi1 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        String doi2 = this.createDOI(item, DOIIdentifierProvider.IS_REGISTERED, true);
        this.context.turnOffAuthorisationSystem();
        this.provider.delete(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
        List metadata = this.itemService.getMetadata((DSpaceObject)item, "dc", "identifier", "uri", null);
        boolean foundDOI1 = false;
        boolean foundDOI2 = false;
        for (MetadataValue id : metadata) {
            if (id.getValue().equals(this.doiService.DOIToExternalForm(doi1))) {
                foundDOI1 = true;
            }
            if (!id.getValue().equals(this.doiService.DOIToExternalForm(doi2))) continue;
            foundDOI2 = true;
        }
        Assert.assertFalse((String)"Cannot remove DOI from item metadata.", (boolean)foundDOI1);
        Assert.assertFalse((String)"Did not removed all DOIs from item metadata.", (boolean)foundDOI2);
        DOI doiRow1 = this.doiService.findByDoi(this.context, doi1.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow1});
        Assert.assertTrue((String)"Status of deleted DOI was not set correctly.", (boolean)DOIIdentifierProvider.TO_BE_DELETED.equals(doiRow1.getStatus()));
        DOI doiRow2 = this.doiService.findByDoi(this.context, doi1.substring("doi:".length()));
        Assume.assumeNotNull((Object[])new Object[]{doiRow2});
        Assert.assertTrue((String)"Did not set the status of all deleted DOIs as expected.", (boolean)DOIIdentifierProvider.TO_BE_DELETED.equals(doiRow2.getStatus()));
    }
}

