/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.service.impl;

import javax.servlet.http.HttpServletRequest;
import org.dspace.AbstractDSpaceTest;
import org.dspace.service.ClientInfoService;
import org.dspace.service.impl.ClientInfoServiceImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.util.DummyHttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientInfoServiceImplTest
extends AbstractDSpaceTest {
    private ClientInfoService clientInfoService;
    private ConfigurationService configurationService;

    @Before
    public void init() {
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    }

    @Test
    public void getClientIpFromRequest() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"127.0.0");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress("127.0.0.1");
        req.addHeader("X-Forwarded-For", "192.168.1.24");
        Assert.assertEquals((Object)"192.168.1.24", (Object)this.clientInfoService.getClientIp((HttpServletRequest)req));
    }

    @Test
    public void getClientIpWithTrustedProxy() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"127.0.0");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "127.0.0.1";
        String xForwardedFor = "192.168.1.24";
        Assert.assertEquals((Object)"192.168.1.24", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
    }

    @Test
    public void getClientIpWithUntrustedProxy() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"192.168.1.1");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "10.24.64.14";
        String xForwardedFor = "192.168.1.24";
        Assert.assertEquals((Object)"10.24.64.14", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
    }

    @Test
    public void getClientIpWithMultipleTrustedProxies() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"127.0.0,192.168.1");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "127.0.0.1";
        String xForwardedFor = "10.24.64.14,192.168.1.24";
        Assert.assertEquals((Object)"10.24.64.14", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
        xForwardedFor = "192.168.1.24,10.24.64.14";
        Assert.assertEquals((Object)"10.24.64.14", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
    }

    @Test
    public void getClientIpWithoutTrustedProxies() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "127.0.0.1";
        String xForwardedFor = "10.24.64.14";
        Assert.assertEquals((Object)"10.24.64.14", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
        xForwardedFor = "127.0.0.1,10.24.64.14";
        Assert.assertEquals((Object)"10.24.64.14", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
        xForwardedFor = "10.24.64.14,127.0.0.1";
        Assert.assertEquals((Object)"10.24.64.14", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
    }

    @Test
    public void getClientIpWithoutUseProxies() {
        this.configurationService.setProperty("useProxies", (Object)false);
        this.configurationService.setProperty("proxies.trusted.ipranges", (Object)"");
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        String remoteIp = "127.0.0.1";
        String xForwardedFor = "10.24.64.14";
        Assert.assertEquals((Object)"127.0.0.1", (Object)this.clientInfoService.getClientIp(remoteIp, xForwardedFor));
        Assert.assertEquals((Object)"127.0.0.1", (Object)this.clientInfoService.getClientIp(remoteIp, null));
        Assert.assertEquals((Object)"127.0.0.1", (Object)this.clientInfoService.getClientIp(remoteIp, ""));
    }

    @Test
    public void isUseProxiesEnabledTrue() {
        this.configurationService.setProperty("useProxies", (Object)true);
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        Assert.assertTrue((boolean)this.clientInfoService.isUseProxiesEnabled());
    }

    @Test
    public void isUseProxiesEnabledFalse() {
        this.configurationService.setProperty("useProxies", (Object)false);
        this.clientInfoService = new ClientInfoServiceImpl(this.configurationService);
        Assert.assertFalse((boolean)this.clientInfoService.isUseProxiesEnabled());
    }
}

