/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.solr;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.dspace.AbstractDSpaceIntegrationTest;

public class MockSolrServer {
    private static final Logger log = LogManager.getLogger();
    private static final ConcurrentMap<String, SolrClient> loadedCores = new ConcurrentHashMap<String, SolrClient>();
    private static final ConcurrentMap<String, AtomicLong> usersPerCore = new ConcurrentHashMap<String, AtomicLong>();
    private static CoreContainer container = null;
    private final String coreName;
    private SolrClient solrServer = null;

    public MockSolrServer(String coreName) throws Exception {
        this.coreName = coreName;
        this.initSolrServer();
    }

    public SolrClient getSolrServer() {
        return this.solrServer;
    }

    protected void initSolrServer() throws Exception {
        this.solrServer = (SolrClient)loadedCores.get(this.coreName);
        if (this.solrServer == null) {
            this.solrServer = MockSolrServer.initSolrServerForCore(this.coreName);
        }
        usersPerCore.putIfAbsent(this.coreName, new AtomicLong(0L));
        ((AtomicLong)usersPerCore.get(this.coreName)).incrementAndGet();
    }

    private static synchronized SolrClient initSolrServerForCore(String coreName) {
        SolrClient server = (SolrClient)loadedCores.get(coreName);
        if (server == null) {
            MockSolrServer.initSolrContainer();
            server = new EmbeddedSolrServer(container, coreName);
            try {
                server.deleteByQuery("*:*");
                server.commit();
            }
            catch (IOException | SolrServerException e) {
                log.error("Failed to empty Solr index:  {}", (Object)e.getMessage(), (Object)e);
            }
            loadedCores.put(coreName, server);
            log.info("SOLR Server for core " + coreName + " initialized");
        }
        return server;
    }

    public void reset() {
        try {
            this.solrServer.deleteByQuery("*:*");
        }
        catch (IOException | SolrServerException ex) {
            log.warn("Exception while clearing '{}' core", (Object)this.coreName, (Object)ex);
        }
    }

    public void destroy() throws Exception {
        if (this.solrServer != null) {
            long remainingUsers = ((AtomicLong)usersPerCore.get(this.coreName)).decrementAndGet();
            if (remainingUsers <= 0L) {
                this.solrServer.close();
                usersPerCore.remove(this.coreName);
                loadedCores.remove(this.coreName);
                log.info("SOLR Server for core " + this.coreName + " destroyed");
            }
            if (usersPerCore.isEmpty()) {
                MockSolrServer.destroyContainer();
            }
        }
    }

    private static synchronized void initSolrContainer() {
        if (container == null) {
            String solrDir = AbstractDSpaceIntegrationTest.getDspaceDir() + File.separator + "solr";
            log.info("Initializing SOLR CoreContainer with directory " + solrDir);
            container = new CoreContainer(solrDir);
            container.load();
            log.info("SOLR CoreContainer initialized");
        }
    }

    private static synchronized void destroyContainer() {
        container = null;
        log.info("SOLR CoreContainer destroyed");
    }
}

