/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.AbstractIntegrationTest;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.export.OpenURLTracker;
import org.dspace.statistics.export.factory.OpenURLTrackerLoggerServiceFactory;
import org.dspace.statistics.export.service.FailedOpenURLTrackerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ITRetryFailedOpenUrlTracker
extends AbstractIntegrationTest {
    private static Logger log = Logger.getLogger(ITRetryFailedOpenUrlTracker.class);
    protected FailedOpenURLTrackerService failedOpenURLTrackerService = OpenURLTrackerLoggerServiceFactory.getInstance().getOpenUrlTrackerLoggerService();
    protected ArrayList testProcessedUrls = (ArrayList)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("testProcessedUrls", ArrayList.class);
    private ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void destroy() {
        try {
            this.context.turnOffAuthorisationSystem();
            List all = this.failedOpenURLTrackerService.findAll(this.context);
            for (OpenURLTracker tracker : all) {
                this.failedOpenURLTrackerService.remove(this.context, tracker);
            }
            this.testProcessedUrls.clear();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.context.complete();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
        super.destroy();
    }

    @Test
    public void testAddNewFailedUrl() throws Exception {
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptConfiguration retryOpenUrlTrackerConfig = this.scriptService.getScriptConfiguration("retry-tracker");
        DSpaceRunnable retryOpenUrlTracker = this.scriptService.createDSpaceRunnableForScriptConfiguration(retryOpenUrlTrackerConfig);
        String urlToAdd = "test-failed-url";
        String[] args = new String[]{"-a", urlToAdd};
        retryOpenUrlTracker.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, this.eperson);
        retryOpenUrlTracker.internalRun();
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        Assert.assertEquals((long)0L, (long)this.testProcessedUrls.size());
        Assert.assertEquals((long)1L, (long)all.size());
        Assert.assertEquals((Object)urlToAdd, (Object)((OpenURLTracker)all.get(0)).getUrl());
    }

    @Test
    public void testReprocessAllUrls() throws Exception {
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptConfiguration retryOpenUrlTrackerConfig = this.scriptService.getScriptConfiguration("retry-tracker");
        DSpaceRunnable retryOpenUrlTracker = this.scriptService.createDSpaceRunnableForScriptConfiguration(retryOpenUrlTrackerConfig);
        String[] args = new String[]{"-r"};
        OpenURLTracker tracker1 = this.failedOpenURLTrackerService.create(this.context);
        tracker1.setUrl("test-url-1");
        OpenURLTracker tracker2 = this.failedOpenURLTrackerService.create(this.context);
        tracker2.setUrl("test-url-2");
        OpenURLTracker tracker3 = this.failedOpenURLTrackerService.create(this.context);
        tracker3.setUrl("test-url-3");
        retryOpenUrlTracker.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, this.eperson);
        retryOpenUrlTracker.internalRun();
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        Assert.assertEquals((long)3L, (long)this.testProcessedUrls.size());
        Assert.assertEquals((Object)true, (Object)this.testProcessedUrls.contains("test-url-1"));
        Assert.assertEquals((Object)true, (Object)this.testProcessedUrls.contains("test-url-2"));
        Assert.assertEquals((Object)true, (Object)this.testProcessedUrls.contains("test-url-3"));
        Assert.assertEquals((long)0L, (long)all.size());
    }

    @Test
    public void testReprocessPartOfUrls() throws Exception {
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptConfiguration retryOpenUrlTrackerConfig = this.scriptService.getScriptConfiguration("retry-tracker");
        DSpaceRunnable retryOpenUrlTracker = this.scriptService.createDSpaceRunnableForScriptConfiguration(retryOpenUrlTrackerConfig);
        String[] args = new String[]{"-r"};
        OpenURLTracker tracker1 = this.failedOpenURLTrackerService.create(this.context);
        tracker1.setUrl("test-url-1");
        OpenURLTracker tracker2 = this.failedOpenURLTrackerService.create(this.context);
        tracker2.setUrl("test-url-2-fail");
        OpenURLTracker tracker3 = this.failedOpenURLTrackerService.create(this.context);
        tracker3.setUrl("test-url-3-fail");
        OpenURLTracker tracker4 = this.failedOpenURLTrackerService.create(this.context);
        tracker4.setUrl("test-url-4-fail");
        OpenURLTracker tracker5 = this.failedOpenURLTrackerService.create(this.context);
        tracker5.setUrl("test-url-5");
        retryOpenUrlTracker.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, this.eperson);
        retryOpenUrlTracker.internalRun();
        List all = this.failedOpenURLTrackerService.findAll(this.context);
        ArrayList<String> storedTrackerUrls = new ArrayList<String>();
        for (OpenURLTracker tracker : all) {
            storedTrackerUrls.add(tracker.getUrl());
        }
        Assert.assertEquals((long)2L, (long)this.testProcessedUrls.size());
        Assert.assertEquals((Object)true, (Object)this.testProcessedUrls.contains("test-url-1"));
        Assert.assertEquals((Object)true, (Object)this.testProcessedUrls.contains("test-url-5"));
        Assert.assertEquals((long)3L, (long)all.size());
        Assert.assertEquals((Object)true, (Object)storedTrackerUrls.contains("test-url-2-fail"));
        Assert.assertEquals((Object)true, (Object)storedTrackerUrls.contains("test-url-3-fail"));
        Assert.assertEquals((Object)true, (Object)storedTrackerUrls.contains("test-url-4-fail"));
    }
}

