/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import javax.servlet.http.HttpServletRequest;
import org.dspace.AbstractDSpaceTest;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.util.DummyHttpServletRequest;
import org.dspace.statistics.util.SpiderDetector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpiderDetectorTest
extends AbstractDSpaceTest {
    private static final String NOT_A_BOT_ADDRESS = "192.168.0.1";

    @Before
    public void init() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        configurationService.setProperty("useProxies", (Object)false);
    }

    @Test
    public void testReadPatterns() {
    }

    @Test
    public void testGetSpiderIpAddresses() {
    }

    @Test
    public void testIsSpiderHttpServletRequest() {
        DummyHttpServletRequest req = new DummyHttpServletRequest();
        req.setAddress(NOT_A_BOT_ADDRESS);
        req.setRemoteHost("notabot.example.com");
        req.setAgent("Firefox");
        req.setAgent("msnbot is watching you");
        Assert.assertTrue((String)"'msnbot' did not match any pattern", (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        req.setAgent("Firefox");
        Assert.assertFalse((String)"'Firefox' matched a pattern", (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        String candidate = "192.168.2.1";
        req.setAddress(candidate);
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        req.setAddress(NOT_A_BOT_ADDRESS);
        Assert.assertFalse((String)"192.168.0.1 matched IP patterns", (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        candidate = "baiduspider-dspace-test.crawl.baidu.com";
        req.setRemoteHost(candidate);
        Assert.assertTrue((String)(candidate + " did not match DNS patterns"), (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
        candidate = "wiki.dspace.org";
        req.setRemoteHost(candidate);
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)SpiderDetector.isSpider((HttpServletRequest)req));
    }

    @Test
    public void testIsSpiderStringStringStringString() {
        String candidate = "192.168.2.1";
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)SpiderDetector.isSpider((String)candidate, null, null, null));
        candidate = NOT_A_BOT_ADDRESS;
        Assert.assertFalse((String)(candidate + " matched IP patterns"), (boolean)SpiderDetector.isSpider((String)candidate, null, null, null));
        candidate = "baiduspider-dspace-test.crawl.baidu.com";
        Assert.assertTrue((String)(candidate + " did not match DNS patterns"), (boolean)SpiderDetector.isSpider((String)NOT_A_BOT_ADDRESS, null, (String)candidate, null));
        candidate = "wiki.dspace.org";
        Assert.assertFalse((String)(candidate + " matched DNS patterns"), (boolean)SpiderDetector.isSpider((String)NOT_A_BOT_ADDRESS, null, (String)candidate, null));
        candidate = "msnbot is watching you";
        Assert.assertTrue((String)("'" + candidate + "' did not match agent patterns"), (boolean)SpiderDetector.isSpider((String)NOT_A_BOT_ADDRESS, null, null, (String)candidate));
        candidate = "Firefox";
        Assert.assertFalse((String)("'" + candidate + "' matched agent patterns"), (boolean)SpiderDetector.isSpider((String)NOT_A_BOT_ADDRESS, null, null, (String)candidate));
    }

    @Test
    public void testIsSpiderString() {
        String candidate = "192.168.2.1";
        Assert.assertTrue((String)(candidate + " did not match IP patterns"), (boolean)SpiderDetector.isSpider((String)candidate, null, null, null));
        candidate = NOT_A_BOT_ADDRESS;
        Assert.assertFalse((String)(candidate + " matched IP patterns"), (boolean)SpiderDetector.isSpider((String)candidate, null, null, null));
    }
}

