/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.sql.SQLException;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExportScriptConfiguration;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataDSpaceCsvExportService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.utils.DSpace;

public class MetadataExport
extends DSpaceRunnable<MetadataExportScriptConfiguration> {
    private boolean help = false;
    private String filename = null;
    private String handle = null;
    private boolean exportAllMetadata = false;
    private boolean exportAllItems = false;
    private static final String EXPORT_CSV = "exportCSV";
    private MetadataDSpaceCsvExportService metadataDSpaceCsvExportService = (MetadataDSpaceCsvExportService)new DSpace().getServiceManager().getServicesByType(MetadataDSpaceCsvExportService.class).get(0);
    private EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    @Override
    public void internalRun() throws Exception {
        if (this.help) {
            this.logHelpInfo();
            this.printHelp();
            return;
        }
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        try {
            context.setCurrentUser((EPerson)this.ePersonService.find(context, this.getEpersonIdentifier()));
        }
        catch (SQLException e) {
            this.handler.handleException(e);
        }
        DSpaceCSV dSpaceCSV = this.metadataDSpaceCsvExportService.handleExport(context, this.exportAllItems, this.exportAllMetadata, this.handle, this.handler);
        this.handler.writeFilestream(context, this.filename, dSpaceCSV.getInputStream(), EXPORT_CSV);
        context.restoreAuthSystemState();
        context.complete();
    }

    protected void logHelpInfo() {
        this.handler.logInfo("\nfull export: metadata-export");
        this.handler.logInfo("partial export: metadata-export -i handle");
    }

    @Override
    public MetadataExportScriptConfiguration getScriptConfiguration() {
        return (MetadataExportScriptConfiguration)new DSpace().getServiceManager().getServiceByName("metadata-export", MetadataExportScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        if (this.commandLine.hasOption('h')) {
            this.help = true;
            return;
        }
        if (!this.commandLine.hasOption('i')) {
            this.exportAllItems = true;
        }
        this.handle = this.commandLine.getOptionValue('i');
        this.filename = this.getFileNameForExportFile();
        this.exportAllMetadata = this.commandLine.hasOption('a');
    }

    protected String getFileNameForExportFile() throws ParseException {
        Context context = new Context();
        try {
            DSpaceObject dso = null;
            dso = StringUtils.isNotBlank((CharSequence)this.handle) ? HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, this.handle) : ContentServiceFactory.getInstance().getSiteService().findSite(context);
            if (dso == null) {
                throw new ParseException("A handle got given that wasn't able to be parsed to a DSpaceObject");
            }
            return dso.getID().toString() + ".csv";
        }
        catch (SQLException e) {
            this.handler.handleException("Something went wrong trying to retrieve DSO for handle: " + this.handle, e);
            return null;
        }
    }
}

