/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.dspace.authority.AuthorityTypes;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.service.AuthorityValueService;
import org.dspace.content.authority.SolrAuthority;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthorityValueServiceImpl
implements AuthorityValueService {
    private final Logger log = LogManager.getLogger(AuthorityValueServiceImpl.class);
    @Autowired(required=true)
    protected AuthorityTypes authorityTypes;

    protected AuthorityValueServiceImpl() {
    }

    @Override
    public AuthorityValue generate(Context context, String authorityKey, String content, String field) {
        AuthorityValue nextValue = null;
        nextValue = this.generateRaw(authorityKey, content, field);
        if (nextValue != null) {
            if (StringUtils.isBlank((CharSequence)authorityKey)) {
                List<AuthorityValue> byValue = this.findByExactValue(context, field, content);
                authorityKey = byValue != null && !byValue.isEmpty() ? byValue.get(0).getId() : UUID.randomUUID().toString();
            } else if (StringUtils.startsWith((CharSequence)authorityKey, (CharSequence)"will be generated::")) {
                authorityKey = UUID.randomUUID().toString();
            }
            nextValue.setId(authorityKey);
            nextValue.updateLastModifiedDate();
            nextValue.setCreationDate(new Date());
            nextValue.setField(field);
        }
        return nextValue;
    }

    protected AuthorityValue generateRaw(String authorityKey, String content, String field) {
        AuthorityValue nextValue;
        if (authorityKey != null && authorityKey.startsWith("will be generated::")) {
            String[] split = StringUtils.split((String)authorityKey, (String)"::");
            String type = null;
            String info = null;
            if (split.length > 0) {
                type = split[1];
                if (split.length > 1) {
                    info = split[2];
                }
            }
            AuthorityValue authorityType = this.authorityTypes.getEmptyAuthorityValue(type);
            nextValue = authorityType.newInstance(info);
        } else {
            Map<String, AuthorityValue> fieldDefaults = this.authorityTypes.getFieldDefaults();
            nextValue = fieldDefaults.get(field).newInstance(null);
            if (nextValue == null) {
                nextValue = new AuthorityValue();
            }
            nextValue.setValue(content);
        }
        return nextValue;
    }

    @Override
    public AuthorityValue update(AuthorityValue value) {
        AuthorityValue updated = this.generateRaw(value.generateString(), value.getValue(), value.getField());
        if (updated != null) {
            updated.setId(value.getId());
            updated.setCreationDate(value.getCreationDate());
            updated.setField(value.getField());
            if (updated.hasTheSameInformationAs(value)) {
                updated.setLastModified(value.getLastModified());
            } else {
                updated.updateLastModifiedDate();
            }
        }
        return updated;
    }

    @Override
    public AuthorityValue findByUID(Context context, String authorityID) {
        String queryString = "id:\"" + authorityID + "\"";
        List<AuthorityValue> findings = this.find(context, queryString);
        return findings.size() > 0 ? findings.get(0) : null;
    }

    @Override
    public List<AuthorityValue> findByValue(Context context, String field, String value) {
        String queryString = "value:" + value + " AND field:" + field;
        return this.find(context, queryString);
    }

    @Override
    public AuthorityValue findByOrcidID(Context context, String orcid_id) {
        String queryString = "orcid_id:" + orcid_id;
        List<AuthorityValue> findings = this.find(context, queryString);
        return findings.size() > 0 ? findings.get(0) : null;
    }

    @Override
    public List<AuthorityValue> findByExactValue(Context context, String field, String value) {
        String queryString = "value:\"" + value + "\" AND field:" + field;
        return this.find(context, queryString);
    }

    @Override
    public List<AuthorityValue> findByValue(Context context, String schema, String element, String qualifier, String value) {
        String field = this.fieldParameter(schema, element, qualifier);
        return this.findByValue(context, field, value);
    }

    @Override
    public List<AuthorityValue> findByName(Context context, String schema, String element, String qualifier, String name) {
        String field = this.fieldParameter(schema, element, qualifier);
        String queryString = "first_name:" + name + " OR last_name:" + name + " OR name_variant:" + name + " AND field:" + field;
        return this.find(context, queryString);
    }

    @Override
    public List<AuthorityValue> findByAuthorityMetadata(Context context, String schema, String element, String qualifier, String value) {
        String field = this.fieldParameter(schema, element, qualifier);
        String queryString = "all_Labels:" + value + " AND field:" + field;
        return this.find(context, queryString);
    }

    @Override
    public List<AuthorityValue> findOrcidHolders(Context context) {
        String queryString = "orcid_id:*";
        return this.find(context, queryString);
    }

    @Override
    public List<AuthorityValue> findAll(Context context) {
        String queryString = "*:*";
        return this.find(context, queryString);
    }

    @Override
    public AuthorityValue fromSolr(SolrDocument solrDocument) {
        String type = (String)solrDocument.getFieldValue("authority_type");
        AuthorityValue value = this.authorityTypes.getEmptyAuthorityValue(type);
        value.setValues(solrDocument);
        return value;
    }

    @Override
    public AuthorityValue getAuthorityValueType(String metadataString) {
        AuthorityValue fromAuthority = null;
        for (AuthorityValue type : this.authorityTypes.getTypes()) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)metadataString, (CharSequence)type.getAuthorityType())) continue;
            fromAuthority = type;
        }
        return fromAuthority;
    }

    protected List<AuthorityValue> find(Context context, String queryString) {
        ArrayList<AuthorityValue> findings = new ArrayList<AuthorityValue>();
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(this.filtered(queryString));
            this.log.debug("AuthorityValueFinder makes the query: " + queryString);
            QueryResponse queryResponse = SolrAuthority.getSearchService().search(solrQuery);
            if (queryResponse != null && queryResponse.getResults() != null && 0L < queryResponse.getResults().getNumFound()) {
                for (SolrDocument document : queryResponse.getResults()) {
                    AuthorityValue authorityValue = this.fromSolr(document);
                    findings.add(authorityValue);
                    this.log.debug("AuthorityValueFinder found: " + authorityValue.getValue());
                }
            }
        }
        catch (Exception e) {
            this.log.error(org.dspace.core.LogManager.getHeader(context, "Error while retrieving AuthorityValue from solr", "query: " + queryString), (Throwable)e);
        }
        return findings;
    }

    protected String filtered(String queryString) throws InstantiationException, IllegalAccessException {
        String instanceFilter = "-deleted:true";
        if (StringUtils.isNotBlank((CharSequence)instanceFilter)) {
            queryString = (String)queryString + " AND " + instanceFilter;
        }
        return queryString;
    }

    protected String fieldParameter(String schema, String element, String qualifier) {
        return schema + "_" + element + (String)(qualifier != null ? "_" + qualifier : "");
    }
}

