/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.factory.AuthorityServiceFactory;
import org.dspace.authority.service.AuthorityValueService;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class UpdateAuthorities {
    private static Logger log = LogManager.getLogger(UpdateAuthorities.class);
    protected PrintWriter print = new PrintWriter(System.out);
    private Context context;
    private List<String> selectedIDs;
    protected final ItemService itemService;
    protected final AuthorityValueService authorityValueService;

    public UpdateAuthorities(Context context) {
        this.context = context;
        this.authorityValueService = AuthorityServiceFactory.getInstance().getAuthorityValueService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
    }

    public static void main(String[] args) throws ParseException {
        Context c = null;
        try {
            c = new Context();
            UpdateAuthorities UpdateAuthorities2 = new UpdateAuthorities(c);
            if (UpdateAuthorities.processArgs(args, UpdateAuthorities2) == 0) {
                System.exit(0);
            }
            UpdateAuthorities2.run();
        }
        finally {
            if (c != null) {
                c.abort();
            }
        }
    }

    protected static int processArgs(String[] args, UpdateAuthorities UpdateAuthorities2) throws ParseException {
        PosixParser parser = new PosixParser();
        Options options = UpdateAuthorities.createCommandLineOptions();
        CommandLine line = parser.parse(options, args);
        HelpFormatter helpFormatter = new HelpFormatter();
        if (line.hasOption("h")) {
            helpFormatter.printHelp("dsrun " + UpdateAuthorities.class.getCanonicalName(), options);
            return 0;
        }
        if (line.hasOption("i")) {
            UpdateAuthorities2.setSelectedIDs(line.getOptionValue("i"));
        }
        UpdateAuthorities2.setPrint(new PrintWriter(System.out, true));
        return 1;
    }

    private void setSelectedIDs(String b) {
        String[] orcids;
        this.selectedIDs = new ArrayList<String>();
        for (String orcid : orcids = b.split(",")) {
            this.selectedIDs.add(orcid.trim());
        }
    }

    protected static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "help");
        options.addOption("i", "id", true, "Import and/or update specific solr records with the given ids (comma-separated)");
        return options;
    }

    public void run() {
        List<AuthorityValue> authorities;
        if (this.selectedIDs != null && !this.selectedIDs.isEmpty()) {
            authorities = new ArrayList<AuthorityValue>();
            for (String selectedID : this.selectedIDs) {
                AuthorityValue byUID = this.authorityValueService.findByUID(this.context, selectedID);
                authorities.add(byUID);
            }
        } else {
            authorities = this.authorityValueService.findAll(this.context);
        }
        if (authorities != null) {
            this.print.println(authorities.size() + " authorities found.");
            for (AuthorityValue authority : authorities) {
                AuthorityValue updated = this.authorityValueService.update(authority);
                if (updated.getLastModified().equals(authority.getLastModified())) continue;
                this.followUp(updated);
            }
        }
    }

    protected void followUp(AuthorityValue authority) {
        this.print.println("Updated: " + authority.getValue() + " - " + authority.getId());
        boolean updateItems = ConfigurationManager.getBooleanProperty("solrauthority", "auto-update-items");
        if (updateItems) {
            this.updateItems(authority);
        }
    }

    protected void updateItems(AuthorityValue authority) {
        try {
            Iterator<Item> itemIterator = this.itemService.findByMetadataFieldAuthority(this.context, authority.getField(), authority.getId());
            while (itemIterator.hasNext()) {
                Item next = itemIterator.next();
                List<MetadataValue> metadata = this.itemService.getMetadata(next, authority.getField(), authority.getId());
                authority.updateItem(this.context, next, metadata.get(0));
                List<MetadataValue> metadataAfter = this.itemService.getMetadata(next, authority.getField(), authority.getId());
                if (metadata.get(0).getValue().equals(metadataAfter.get(0).getValue())) continue;
                this.print.println("Updated item with handle " + next.getHandle());
            }
        }
        catch (Exception e) {
            log.error("Error updating item", (Throwable)e);
            this.print.println("Error updating item. " + Arrays.toString(e.getStackTrace()));
        }
    }

    public PrintWriter getPrint() {
        return this.print;
    }

    public void setPrint(PrintWriter print) {
        this.print = print;
    }
}

