/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.core.I18nUtil;
import org.dspace.core.SelfNamedPlugin;

public class DCInputAuthority
extends SelfNamedPlugin
implements ChoiceAuthority {
    private static Logger log = LogManager.getLogger(DCInputAuthority.class);
    private Map<String, String[]> values = null;
    private Map<String, String[]> labels = null;
    private static Map<Locale, DCInputsReader> dcis = null;
    private static String[] pluginNames = null;

    @Override
    public boolean storeAuthorityInMetadata() {
        return false;
    }

    public static void reset() {
        pluginNames = null;
    }

    public static String[] getPluginNames() {
        if (pluginNames == null) {
            DCInputAuthority.initPluginNames();
        }
        return (String[])ArrayUtils.clone((Object[])pluginNames);
    }

    private static synchronized void initPluginNames() {
        Locale[] locales = I18nUtil.getSupportedLocales();
        HashSet<String> names = new HashSet<String>();
        if (pluginNames == null) {
            try {
                dcis = new HashMap<Locale, DCInputsReader>();
                for (Locale locale : locales) {
                    dcis.put(locale, new DCInputsReader(I18nUtil.getInputFormsFileName(locale)));
                }
                for (Locale l : locales) {
                    Iterator<String> pi = dcis.get(l).getPairsNameIterator();
                    while (pi.hasNext()) {
                        names.add(pi.next());
                    }
                }
                DCInputsReader dcirDefault = new DCInputsReader();
                Iterator<String> pi = dcirDefault.getPairsNameIterator();
                while (pi.hasNext()) {
                    names.add(pi.next());
                }
            }
            catch (DCInputsReaderException e) {
                log.error("Failed reading DCInputs initialization: ", (Throwable)e);
            }
            pluginNames = names.toArray(new String[names.size()]);
            log.debug("Got plugin names = " + Arrays.deepToString(pluginNames));
        }
    }

    private void init() {
        if (this.values == null) {
            this.values = new HashMap<String, String[]>();
            this.labels = new HashMap<String, String[]>();
            String pname = this.getPluginInstanceName();
            for (Locale l : dcis.keySet()) {
                DCInputsReader dci = dcis.get(l);
                List<String> pairs = dci.getPairs(pname);
                if (pairs != null) {
                    String[] valuesLocale = new String[pairs.size() / 2];
                    String[] labelsLocale = new String[pairs.size() / 2];
                    for (int i = 0; i < pairs.size(); i += 2) {
                        labelsLocale[i / 2] = pairs.get(i);
                        valuesLocale[i / 2] = pairs.get(i + 1);
                    }
                    this.values.put(l.getLanguage(), valuesLocale);
                    this.labels.put(l.getLanguage(), labelsLocale);
                    log.debug("Found pairs for name=" + pname + ",locale=" + l);
                    continue;
                }
                log.error("Failed to find any pairs for name=" + pname, (Throwable)new IllegalStateException());
            }
        }
    }

    @Override
    public Choices getMatches(String query, int start, int limit, String locale) {
        this.init();
        Locale currentLocale = I18nUtil.getSupportedLocale(locale);
        String[] valuesLocale = this.values.get(currentLocale.getLanguage());
        String[] labelsLocale = this.labels.get(currentLocale.getLanguage());
        int dflt = -1;
        int found = 0;
        ArrayList<Choice> v = new ArrayList<Choice>();
        for (int i = 0; i < valuesLocale.length; ++i) {
            if (query != null && !StringUtils.containsIgnoreCase((CharSequence)valuesLocale[i], (CharSequence)query)) continue;
            if (found >= start && v.size() < limit) {
                v.add(new Choice(null, valuesLocale[i], labelsLocale[i]));
                if (valuesLocale[i].equalsIgnoreCase(query)) {
                    dflt = i;
                }
            }
            ++found;
        }
        Choice[] vArray = new Choice[v.size()];
        return new Choices(v.toArray(vArray), start, found, 400, false, dflt);
    }

    @Override
    public Choices getBestMatch(String text, String locale) {
        this.init();
        Locale currentLocale = I18nUtil.getSupportedLocale(locale);
        String[] valuesLocale = this.values.get(currentLocale.getLanguage());
        String[] labelsLocale = this.labels.get(currentLocale.getLanguage());
        for (int i = 0; i < valuesLocale.length; ++i) {
            if (!text.equalsIgnoreCase(valuesLocale[i])) continue;
            Choice[] v = new Choice[]{new Choice(String.valueOf(i), valuesLocale[i], labelsLocale[i])};
            return new Choices(v, 0, v.length, 500, false, 0);
        }
        return new Choices(300);
    }

    @Override
    public String getLabel(String key, String locale) {
        this.init();
        if (StringUtils.isBlank((CharSequence)locale)) {
            locale = I18nUtil.getDefaultLocale().getLanguage();
        }
        String[] labelsLocale = this.labels.get(locale);
        int pos = -1;
        for (int i = 0; i < labelsLocale.length; ++i) {
            if (!labelsLocale[i].equals(key)) continue;
            pos = i;
            break;
        }
        if (pos != -1) {
            return labelsLocale[pos];
        }
        return "UNKNOWN KEY " + key;
    }

    @Override
    public boolean isScrollable() {
        return true;
    }
}

