/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexClientOptions;
import org.dspace.discovery.IndexDiscoveryScriptConfiguration;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.discovery.indexobject.factory.IndexObjectFactoryFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;

public class IndexClient
extends DSpaceRunnable<IndexDiscoveryScriptConfiguration> {
    private Context context;
    private IndexingService indexer = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
    private IndexClientOptions indexClientOptions;

    @Override
    public void internalRun() throws Exception {
        if (this.indexClientOptions == IndexClientOptions.HELP) {
            this.printHelp();
            return;
        }
        if (this.indexClientOptions == IndexClientOptions.REMOVE) {
            this.handler.logInfo("Removing " + this.commandLine.getOptionValue("r") + " from Index");
            this.indexer.unIndexContent(this.context, this.commandLine.getOptionValue("r"));
        } else if (this.indexClientOptions == IndexClientOptions.CLEAN) {
            this.handler.logInfo("Cleaning Index");
            this.indexer.cleanIndex(false);
        } else if (this.indexClientOptions == IndexClientOptions.FORCECLEAN) {
            this.handler.logInfo("Cleaning Index");
            this.indexer.cleanIndex(true);
        } else if (this.indexClientOptions == IndexClientOptions.BUILD || this.indexClientOptions == IndexClientOptions.BUILDANDSPELLCHECK) {
            this.handler.logInfo("(Re)building index from scratch.");
            this.indexer.createIndex(this.context);
            if (this.indexClientOptions == IndexClientOptions.BUILDANDSPELLCHECK) {
                this.checkRebuildSpellCheck(this.commandLine, this.indexer);
            }
        } else if (this.indexClientOptions == IndexClientOptions.OPTIMIZE) {
            this.handler.logInfo("Optimizing search core.");
            this.indexer.optimize();
        } else if (this.indexClientOptions == IndexClientOptions.SPELLCHECK) {
            this.checkRebuildSpellCheck(this.commandLine, this.indexer);
        } else if (this.indexClientOptions == IndexClientOptions.INDEX) {
            String param = this.commandLine.getOptionValue('i');
            UUID uuid = null;
            try {
                uuid = UUID.fromString(param);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Optional<Object> indexableObject = Optional.empty();
            if (uuid != null) {
                Item item = (Item)ContentServiceFactory.getInstance().getItemService().find(this.context, uuid);
                if (item != null) {
                    indexableObject = Optional.of(new IndexableItem(item));
                } else {
                    Community community = (Community)ContentServiceFactory.getInstance().getCommunityService().find(this.context, uuid);
                    if (community != null) {
                        indexableObject = Optional.of(new IndexableCommunity(community));
                    } else {
                        Collection collection = (Collection)ContentServiceFactory.getInstance().getCollectionService().find(this.context, uuid);
                        if (collection != null) {
                            indexableObject = Optional.of(new IndexableCollection(collection));
                        }
                    }
                }
            } else {
                DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(this.context, param);
                if (dso != null) {
                    IndexFactory indexableObjectService = IndexObjectFactoryFactory.getInstance().getIndexFactoryByType(String.valueOf(dso.getType()));
                    indexableObject = indexableObjectService.findIndexableObject(this.context, dso.getID().toString());
                }
            }
            if (!indexableObject.isPresent()) {
                throw new IllegalArgumentException("Cannot resolve " + param + " to a DSpace object");
            }
            this.handler.logInfo("Indexing " + param + " force " + this.commandLine.hasOption("f"));
            long startTimeMillis = System.currentTimeMillis();
            long count = IndexClient.indexAll(this.indexer, ContentServiceFactory.getInstance().getItemService(), this.context, (IndexableObject)indexableObject.get());
            long seconds = (System.currentTimeMillis() - startTimeMillis) / 1000L;
            this.handler.logInfo("Indexed " + count + " object" + (count > 1L ? "s" : "") + " in " + seconds + " seconds");
        } else if (this.indexClientOptions == IndexClientOptions.UPDATE || this.indexClientOptions == IndexClientOptions.UPDATEANDSPELLCHECK) {
            this.handler.logInfo("Updating and Cleaning Index");
            this.indexer.cleanIndex(false);
            this.indexer.updateIndex(this.context, false);
            if (this.indexClientOptions == IndexClientOptions.UPDATEANDSPELLCHECK) {
                this.checkRebuildSpellCheck(this.commandLine, this.indexer);
            }
        } else if (this.indexClientOptions == IndexClientOptions.FORCEUPDATE || this.indexClientOptions == IndexClientOptions.FORCEUPDATEANDSPELLCHECK) {
            this.handler.logInfo("Updating and Cleaning Index");
            this.indexer.cleanIndex(true);
            this.indexer.updateIndex(this.context, true);
            if (this.indexClientOptions == IndexClientOptions.FORCEUPDATEANDSPELLCHECK) {
                this.checkRebuildSpellCheck(this.commandLine, this.indexer);
            }
        }
        this.handler.logInfo("Done with indexing");
    }

    @Override
    public IndexDiscoveryScriptConfiguration getScriptConfiguration() {
        return (IndexDiscoveryScriptConfiguration)new DSpace().getServiceManager().getServiceByName("index-discovery", IndexDiscoveryScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        try {
            this.context = new Context(Context.Mode.READ_ONLY);
            this.context.turnOffAuthorisationSystem();
        }
        catch (Exception e) {
            throw new ParseException("Unable to create a new DSpace Context: " + e.getMessage());
        }
        this.indexClientOptions = IndexClientOptions.getIndexClientOption(this.commandLine);
    }

    private static long indexAll(IndexingService indexingService, ItemService itemService, Context context, IndexableObject dso) throws IOException, SearchServiceException, SQLException {
        long count = 0L;
        indexingService.indexContent(context, dso, true, true);
        ++count;
        if (dso.getIndexedObject() instanceof Community) {
            Community community = (Community)((Object)dso);
            String communityHandle = community.getHandle();
            for (Community subcommunity : community.getSubcommunities()) {
                count += IndexClient.indexAll(indexingService, itemService, context, new IndexableCommunity(subcommunity));
                context.uncacheEntity(subcommunity);
            }
            Community reloadedCommunity = (Community)HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, communityHandle);
            for (Collection collection : reloadedCommunity.getCollections()) {
                ++count;
                indexingService.indexContent(context, new IndexableCollection(collection), true, true);
                count += IndexClient.indexItems(indexingService, itemService, context, collection);
                context.uncacheEntity(collection);
            }
        } else if (dso instanceof IndexableCollection) {
            count += IndexClient.indexItems(indexingService, itemService, context, (Collection)dso.getIndexedObject());
        }
        return count;
    }

    private static long indexItems(IndexingService indexingService, ItemService itemService, Context context, Collection collection) throws IOException, SearchServiceException, SQLException {
        long count = 0L;
        Iterator<Item> itemIterator = itemService.findByCollection(context, collection);
        while (itemIterator.hasNext()) {
            Item item = itemIterator.next();
            indexingService.indexContent(context, new IndexableItem(item), true, false);
            ++count;
            context.uncacheEntity(item);
        }
        indexingService.commit();
        return count;
    }

    protected void checkRebuildSpellCheck(CommandLine line, IndexingService indexer) throws SearchServiceException, IOException {
        this.handler.logInfo("Rebuilding spell checker.");
        indexer.buildSpellCheck();
    }
}

