/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import gr.ekt.bte.core.DataLoader;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.Value;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.submit.listener.MetadataListener;
import org.dspace.submit.lookup.SubmissionLookupDataLoader;

public class MetadataStep
extends AbstractProcessingStep {
    private static Logger log = Logger.getLogger(MetadataStep.class);
    protected List<MetadataListener> listeners = DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(MetadataListener.class);
    protected Map<String, List<MetadataValue>> metadataMap = new HashMap<String, List<MetadataValue>>();
    private Map<String, Set<String>> results = new HashMap<String, Set<String>>();
    private Map<String, String> mappingIdentifier = new HashMap<String, String>();

    @Override
    public void doPreProcessing(Context context, InProgressSubmission wsi) {
        for (MetadataListener listener : this.listeners) {
            for (String metadata : listener.getMetadata().keySet()) {
                String[] tokenized = Utils.tokenize(metadata);
                List<MetadataValue> mm = this.itemService.getMetadata(wsi.getItem(), tokenized[0], tokenized[1], tokenized[2], "*");
                if (mm != null && !mm.isEmpty()) {
                    this.metadataMap.put(metadata, mm);
                } else {
                    this.metadataMap.put(metadata, new ArrayList());
                }
                this.mappingIdentifier.put(metadata, listener.getMetadata().get(metadata));
            }
        }
    }

    @Override
    public void doPostProcessing(Context context, InProgressSubmission wsi) {
        for (String metadata : this.metadataMap.keySet()) {
            String[] tokenized = Utils.tokenize(metadata);
            List<MetadataValue> currents = this.itemService.getMetadata(wsi.getItem(), tokenized[0], tokenized[1], tokenized[2], "*");
            if (currents == null || currents.isEmpty()) continue;
            List<MetadataValue> olds = this.metadataMap.get(metadata);
            if (olds.isEmpty()) {
                this.process(context, metadata, currents);
                continue;
            }
            for (MetadataValue current : currents) {
                boolean found = false;
                for (MetadataValue old : olds) {
                    if (!old.getValue().equals(current.getValue())) continue;
                    found = true;
                }
                if (found) continue;
                this.process(context, metadata, current);
            }
        }
        if (!this.results.isEmpty()) {
            for (MetadataListener listener : this.listeners) {
                for (DataLoader dataLoader : listener.getDataloadersMap().values()) {
                    SubmissionLookupDataLoader submissionLookupDataLoader = (SubmissionLookupDataLoader)dataLoader;
                    try {
                        List<Record> recordSet = submissionLookupDataLoader.getByIdentifier(context, this.results);
                        List<Record> resultSet = this.convertFields(recordSet, this.bteBatchImportService.getOutputMap());
                        this.enrichItem(context, resultSet, wsi.getItem());
                    }
                    catch (IOException | SQLException | HttpException | AuthorizeException e) {
                        log.error((Object)e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected void enrichItem(Context context, List<Record> rset, Item item) throws SQLException, AuthorizeException {
        for (Record record : rset) {
            for (String field : record.getFields()) {
                try {
                    String[] tfield = Utils.tokenize(field);
                    List<MetadataValue> mdvs = this.itemService.getMetadata(item, tfield[0], tfield[1], tfield[2], "*");
                    if (mdvs == null || mdvs.isEmpty()) {
                        for (Value value : record.getValues(field)) {
                            this.itemService.addMetadata(context, item, tfield[0], tfield[1], tfield[2], null, value.getAsString());
                        }
                        continue;
                    }
                    block5: for (Value value : record.getValues(field)) {
                        boolean found = false;
                        for (MetadataValue mdv : mdvs) {
                            if (!mdv.getValue().equals(value.getAsString())) continue;
                            found = true;
                            continue block5;
                        }
                        if (found) continue;
                        this.itemService.addMetadata(context, item, tfield[0], tfield[1], tfield[2], null, value.getAsString());
                    }
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.itemService.update(context, item);
    }

    private void process(Context context, String metadata, List<MetadataValue> currents) {
        for (MetadataValue current : currents) {
            this.process(context, metadata, current);
        }
    }

    private void process(Context context, String metadata, MetadataValue current) {
        String key = this.mappingIdentifier.get(metadata);
        Set<String> identifiers = null;
        identifiers = !this.results.containsKey(key) ? new HashSet<String>() : this.results.get(key);
        identifiers.add(current.getValue());
        this.results.put(key, identifiers);
    }

    public List<Record> convertFields(List<Record> recordSet, Map<String, String> fieldMap) {
        ArrayList<Record> result = new ArrayList<Record>();
        for (Record publication : recordSet) {
            for (String fieldName : fieldMap.keySet()) {
                String md = null;
                if (fieldMap != null) {
                    md = fieldMap.get(fieldName);
                }
                if (StringUtils.isBlank(md)) continue;
                md = md.trim();
                if (!publication.isMutable()) continue;
                List values = publication.getValues(md);
                publication.makeMutable().removeField(md);
                publication.makeMutable().addField(fieldName, values);
            }
            result.add(publication);
        }
        return result;
    }
}

