/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic;

import java.sql.SQLException;
import java.util.List;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.TaskListItem;
import org.dspace.workflowbasic.dao.TaskListItemDAO;
import org.dspace.workflowbasic.service.TaskListItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskListItemServiceImpl
implements TaskListItemService {
    @Autowired(required=true)
    protected TaskListItemDAO taskListItemDAO;

    protected TaskListItemServiceImpl() {
    }

    @Override
    public TaskListItem create(Context context, BasicWorkflowItem workflowItem, EPerson ePerson) throws SQLException {
        TaskListItem taskListItem = this.taskListItemDAO.create(context, new TaskListItem());
        taskListItem.setWorkflowItem(workflowItem);
        taskListItem.setEPerson(ePerson);
        this.update(context, taskListItem);
        return taskListItem;
    }

    @Override
    public void deleteByWorkflowItem(Context context, BasicWorkflowItem workflowItem) throws SQLException {
        this.taskListItemDAO.deleteByWorkflowItem(context, workflowItem);
    }

    @Override
    public void deleteByWorkflowItemAndEPerson(Context context, BasicWorkflowItem workflowItem, EPerson ePerson) throws SQLException {
        this.taskListItemDAO.deleteByWorkflowItemAndEPerson(context, workflowItem, ePerson);
    }

    @Override
    public void deleteByEPerson(Context context, EPerson ePerson) throws SQLException {
        this.taskListItemDAO.deleteByEPerson(context, ePerson);
    }

    @Override
    public void update(Context context, TaskListItem taskListItem) throws SQLException {
        this.taskListItemDAO.save(context, taskListItem);
    }

    @Override
    public List<TaskListItem> findByEPerson(Context context, EPerson ePerson) throws SQLException {
        return this.taskListItemDAO.findByEPerson(context, ePerson);
    }
}

