/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflowbasic.dao.impl;

import java.sql.SQLException;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.workflowbasic.BasicWorkflowItem;
import org.dspace.workflowbasic.TaskListItem;
import org.dspace.workflowbasic.TaskListItem_;
import org.dspace.workflowbasic.dao.TaskListItemDAO;

public class TaskListItemDAOImpl
extends AbstractHibernateDAO<TaskListItem>
implements TaskListItemDAO {
    protected TaskListItemDAOImpl() {
    }

    @Override
    public void deleteByWorkflowItem(Context context, BasicWorkflowItem workflowItem) throws SQLException {
        String queryString = "delete from TaskListItem where workflowItem = :workflowItem";
        Query query = this.createQuery(context, queryString);
        query.setParameter("workflowItem", (Object)workflowItem);
        query.executeUpdate();
    }

    @Override
    public void deleteByWorkflowItemAndEPerson(Context context, BasicWorkflowItem workflowItem, EPerson ePerson) throws SQLException {
        String queryString = "delete from TaskListItem where workflowItem = :workflowItem AND ePerson = :ePerson";
        Query query = this.createQuery(context, queryString);
        query.setParameter("workflowItem", (Object)workflowItem);
        query.setParameter("ePerson", (Object)ePerson);
        query.executeUpdate();
    }

    @Override
    public void deleteByEPerson(Context context, EPerson ePerson) throws SQLException {
        String queryString = "delete from TaskListItem where ePerson = :ePerson";
        Query query = this.createQuery(context, queryString);
        query.setParameter("ePerson", (Object)ePerson);
        query.executeUpdate();
    }

    @Override
    public List<TaskListItem> findByEPerson(Context context, EPerson ePerson) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<TaskListItem> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, TaskListItem.class);
        Root taskListItemRoot = criteriaQuery.from(TaskListItem.class);
        criteriaQuery.select((Selection)taskListItemRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)taskListItemRoot.get(TaskListItem_.ePerson), (Object)ePerson));
        return this.list(context, criteriaQuery, false, TaskListItem.class, -1, -1);
    }
}

