/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractDSpaceObjectBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class CollectionBuilder
extends AbstractDSpaceObjectBuilder<Collection> {
    private Collection collection;

    protected CollectionBuilder(Context context) {
        super(context);
    }

    public static CollectionBuilder createCollection(Context context, Community parent) {
        CollectionBuilder builder = new CollectionBuilder(context);
        return builder.create(parent);
    }

    public static CollectionBuilder createCollection(Context context, Community parent, String handle) {
        CollectionBuilder builder = new CollectionBuilder(context);
        return builder.create(parent, handle);
    }

    private CollectionBuilder create(Community parent) {
        try {
            this.collection = collectionService.create(this.context, parent);
        }
        catch (Exception e) {
            return (CollectionBuilder)this.handleException(e);
        }
        return this;
    }

    private CollectionBuilder create(Community parent, String handle) {
        try {
            for (Collection collection : collectionService.findAll(this.context)) {
                if (!collection.getHandle().equalsIgnoreCase(handle)) continue;
                this.collection = collection;
            }
            this.collection = collectionService.create(this.context, parent, handle);
        }
        catch (Exception e) {
            return (CollectionBuilder)this.handleException(e);
        }
        return this;
    }

    public CollectionBuilder withName(String name) {
        return (CollectionBuilder)this.setMetadataSingleValue(this.collection, MetadataSchemaEnum.DC.getName(), "title", null, name);
    }

    public CollectionBuilder withNameForLanguage(String name, String language) {
        return (CollectionBuilder)this.addMetadataValue(this.collection, MetadataSchemaEnum.DC.getName(), "title", null, language, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionBuilder withLogo(String content) throws AuthorizeException, IOException, SQLException {
        try (InputStream is = IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8);){
            collectionService.setLogo(this.context, this.collection, is);
            CollectionBuilder collectionBuilder = this;
            return collectionBuilder;
        }
    }

    public CollectionBuilder withProvenance(String provenance) {
        return (CollectionBuilder)this.addMetadataValue(this.collection, MetadataSchemaEnum.DC.getName(), "description", "provenance", provenance);
    }

    public CollectionBuilder withTemplateItem() throws SQLException, AuthorizeException {
        collectionService.createTemplateItem(this.context, this.collection);
        return this;
    }

    public CollectionBuilder withSubmitterGroup(EPerson ... members) throws SQLException, AuthorizeException {
        Group g = collectionService.createSubmitters(this.context, this.collection);
        for (EPerson e : members) {
            groupService.addMember(this.context, g, e);
        }
        groupService.update(this.context, (DSpaceObject)g);
        return this;
    }

    public CollectionBuilder withWorkflowGroup(int step, EPerson ... members) throws SQLException, AuthorizeException {
        Group g = collectionService.createWorkflowGroup(this.context, this.collection, step);
        for (EPerson e : members) {
            groupService.addMember(this.context, g, e);
        }
        groupService.update(this.context, (DSpaceObject)g);
        return this;
    }

    public CollectionBuilder withAdminGroup(EPerson ... members) throws SQLException, AuthorizeException {
        Group g = collectionService.createAdministrators(this.context, this.collection);
        for (EPerson e : members) {
            groupService.addMember(this.context, g, e);
        }
        groupService.update(this.context, (DSpaceObject)g);
        return this;
    }

    @Override
    public Collection build() {
        try {
            collectionService.update(this.context, (DSpaceObject)this.collection);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            return (Collection)this.handleException(e);
        }
        return this.collection;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.collection = (Collection)c.reloadEntity((ReloadableEntity)this.collection);
            if (this.collection != null) {
                this.deleteAdminGroup(c);
                this.deleteItemTemplate(c);
                this.deleteDefaultReadGroups(c, this.collection);
                this.deleteWorkflowGroups(c, this.collection);
                this.delete(c, this.collection);
                c.complete();
            }
        }
    }

    private void deleteAdminGroup(Context c) throws SQLException, AuthorizeException, IOException {
        Group group = this.collection.getAdministrators();
        if (group != null) {
            collectionService.removeAdministrators(c, this.collection);
            groupService.delete(c, (DSpaceObject)group);
        }
    }

    private void deleteItemTemplate(Context c) throws SQLException, AuthorizeException, IOException {
        if (this.collection.getTemplateItem() != null) {
            collectionService.removeTemplateItem(c, this.collection);
        }
    }

    public void deleteWorkflowGroups(Context c, Collection collection) throws Exception {
        for (int i = 1; i <= 3; ++i) {
            Group group = collectionService.getWorkflowGroup(c, collection, i);
            if (group == null) continue;
            collectionService.setWorkflowGroup(c, collection, i, null);
            groupService.delete(c, (DSpaceObject)group);
        }
    }

    public void deleteDefaultReadGroups(Context c, Collection collection) throws Exception {
        Group defaultItemReadGroup = groupService.findByName(c, "COLLECTION_" + collection.getID().toString() + "_ITEM_DEFAULT_READ");
        Group defaultBitstreamReadGroup = groupService.findByName(c, "COLLECTION_" + collection.getID().toString() + "_BITSTREAM_DEFAULT_READ");
        if (defaultItemReadGroup != null) {
            groupService.delete(c, (DSpaceObject)defaultItemReadGroup);
        }
        if (defaultBitstreamReadGroup != null) {
            groupService.delete(c, (DSpaceObject)defaultBitstreamReadGroup);
        }
    }

    public static void deleteCollection(UUID uuid) throws SQLException, IOException, SearchServiceException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            Collection collection = (Collection)collectionService.find(c, uuid);
            if (collection != null) {
                try {
                    collectionService.delete(c, (DSpaceObject)collection);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    protected DSpaceObjectService<Collection> getService() {
        return collectionService;
    }
}

