/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.InputStream;
import java.util.Locale;
import org.dspace.builder.AbstractBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.LicenseUtils;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;

public class PoolTaskBuilder
extends AbstractBuilder<PoolTask, PoolTaskService> {
    private WorkspaceItem workspaceItem;
    private XmlWorkflowItem workflowItem;
    private PoolTask poolTask;
    private EPerson user;

    protected PoolTaskBuilder(Context context) {
        super(context);
    }

    public static PoolTaskBuilder createPoolTask(Context context, Collection col, EPerson user) {
        PoolTaskBuilder builder = new PoolTaskBuilder(context);
        return builder.create(context, col, user);
    }

    private PoolTaskBuilder create(Context context, Collection col, EPerson user) {
        this.context = context;
        this.user = user;
        try {
            this.workspaceItem = workspaceItemService.create(context, col, false);
        }
        catch (Exception e) {
            return (PoolTaskBuilder)this.handleException(e);
        }
        return this;
    }

    @Override
    public PoolTask build() {
        try {
            this.workflowItem = (XmlWorkflowItem)workflowService.start(this.context, this.workspaceItem);
            this.workspaceItem = null;
            this.poolTask = this.getService().findByWorkflowIdAndEPerson(this.context, this.workflowItem, this.user);
            this.context.dispatchEvents();
            indexingService.commit();
            return this.poolTask;
        }
        catch (Exception e) {
            return (PoolTask)this.handleException(e);
        }
    }

    @Override
    public void delete(Context c, PoolTask poolTask) throws Exception {
        if (poolTask != null) {
            WorkflowItemBuilder.deleteWorkflowItem(poolTask.getWorkflowItem().getID());
        }
    }

    private void deleteWsi(Context c, WorkspaceItem dso) throws Exception {
        if (dso != null) {
            workspaceItemService.deleteAll(c, dso);
        }
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.workspaceItem = (WorkspaceItem)c.reloadEntity((ReloadableEntity)this.workspaceItem);
            if (this.workspaceItem != null) {
                this.deleteWsi(c, this.workspaceItem);
            }
            if (this.workflowItem != null) {
                WorkflowItemBuilder.deleteWorkflowItem(this.workflowItem.getID());
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    protected PoolTaskService getService() {
        return poolTaskService;
    }

    protected PoolTaskBuilder addMetadataValue(String schema, String element, String qualifier, String value) {
        try {
            itemService.addMetadata(this.context, (DSpaceObject)this.workspaceItem.getItem(), schema, element, qualifier, "*", value);
        }
        catch (Exception e) {
            return (PoolTaskBuilder)this.handleException(e);
        }
        return this;
    }

    protected PoolTaskBuilder setMetadataSingleValue(String schema, String element, String qualifier, String value) {
        try {
            itemService.setMetadataSingleValue(this.context, (DSpaceObject)this.workspaceItem.getItem(), schema, element, qualifier, "*", value);
        }
        catch (Exception e) {
            return (PoolTaskBuilder)this.handleException(e);
        }
        return this;
    }

    public PoolTaskBuilder withTitle(String title) {
        return this.setMetadataSingleValue(MetadataSchemaEnum.DC.getName(), "title", null, title);
    }

    public PoolTaskBuilder withIssueDate(String issueDate) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "date", "issued", new DCDate(issueDate).toString());
    }

    public PoolTaskBuilder withAuthor(String authorName) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "contributor", "author", authorName);
    }

    public PoolTaskBuilder withSubject(String subject) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "subject", null, subject);
    }

    public PoolTaskBuilder grantLicense() {
        Item item = this.workspaceItem.getItem();
        try {
            EPerson submitter = this.workspaceItem.getSubmitter();
            submitter = (EPerson)this.context.reloadEntity((ReloadableEntity)submitter);
            String license = LicenseUtils.getLicenseText((Locale)this.context.getCurrentLocale(), (Collection)this.workspaceItem.getCollection(), (Item)item, (EPerson)submitter);
            LicenseUtils.grantLicense((Context)this.context, (Item)item, (String)license, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }

    public PoolTaskBuilder withFulltext(String name, String source, InputStream is) {
        try {
            Item item = this.workspaceItem.getItem();
            Bitstream b = itemService.createSingleBitstream(this.context, is, item);
            b.setName(this.context, name);
            b.setSource(this.context, source);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }
}

