/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.EntityType;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;

public class RelationshipTypeBuilder
extends AbstractBuilder<RelationshipType, RelationshipTypeService> {
    private static final Logger log = LogManager.getLogger();
    private RelationshipType relationshipType;

    protected RelationshipTypeBuilder(Context context) {
        super(context);
    }

    @Override
    protected RelationshipTypeService getService() {
        return relationshipTypeService;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.relationshipType = (RelationshipType)c.reloadEntity((ReloadableEntity)this.relationshipType);
            List byRelationshipType = relationshipService.findByRelationshipType(c, this.relationshipType);
            for (Relationship relationship : byRelationshipType) {
                relationshipService.delete(c, (Object)relationship);
            }
            if (this.relationshipType != null) {
                this.delete(c, this.relationshipType);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, RelationshipType dso) throws Exception {
        if (dso != null) {
            this.getService().delete(c, (Object)dso);
        }
    }

    @Override
    public RelationshipType build() {
        try {
            relationshipTypeService.update(this.context, (Object)this.relationshipType);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (SQLException | AuthorizeException | SearchServiceException e) {
            log.error((Object)e);
        }
        return this.relationshipType;
    }

    public void delete(RelationshipType relationshipType) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            RelationshipType attachedRelationShipType = (RelationshipType)c.reloadEntity((ReloadableEntity)relationshipType);
            if (attachedRelationShipType != null) {
                this.getService().delete(c, (Object)attachedRelationShipType);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static RelationshipTypeBuilder createRelationshipTypeBuilder(Context context, EntityType leftType, EntityType rightType, String leftwardType, String rightwardType, Integer leftCardinalityMin, Integer leftCardinalityMax, Integer rightCardinalityMin, Integer rightCardinalityMax) {
        RelationshipTypeBuilder relationshipBuilder = new RelationshipTypeBuilder(context);
        return relationshipBuilder.create(context, leftType, rightType, leftwardType, rightwardType, leftCardinalityMin, leftCardinalityMax, rightCardinalityMin, rightCardinalityMax);
    }

    private RelationshipTypeBuilder create(Context context, EntityType leftEntityType, EntityType rightEntityType, String leftwardType, String rightwardType, Integer leftCardinalityMin, Integer leftCardinalityMax, Integer rightCardinalityMin, Integer rightCardinalityMax) {
        try {
            this.context = context;
            this.relationshipType = relationshipTypeService.create(context, leftEntityType, rightEntityType, leftwardType, rightwardType, leftCardinalityMin, leftCardinalityMax, rightCardinalityMin, rightCardinalityMax);
        }
        catch (SQLException | AuthorizeException e) {
            log.error("Failed to create RelationshipType", e);
        }
        return this;
    }

    public RelationshipTypeBuilder withCopyToLeft(boolean copyToLeft) throws SQLException {
        this.relationshipType.setCopyToLeft(copyToLeft);
        return this;
    }

    public RelationshipTypeBuilder withCopyToRight(boolean copyToRight) throws SQLException {
        this.relationshipType.setCopyToRight(copyToRight);
        return this;
    }
}

