/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Locale;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.LicenseUtils;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class WorkspaceItemBuilder
extends AbstractBuilder<WorkspaceItem, WorkspaceItemService> {
    private Item item;
    private WorkspaceItem workspaceItem;

    protected WorkspaceItemBuilder(Context context) {
        super(context);
    }

    public static WorkspaceItemBuilder createWorkspaceItem(Context context, Collection col) {
        WorkspaceItemBuilder builder = new WorkspaceItemBuilder(context);
        return builder.create(context, col);
    }

    private WorkspaceItemBuilder create(Context context, Collection col) {
        this.context = context;
        try {
            this.workspaceItem = workspaceItemService.create(context, col, false);
            this.item = this.workspaceItem.getItem();
        }
        catch (Exception e) {
            return (WorkspaceItemBuilder)this.handleException(e);
        }
        return this;
    }

    @Override
    public WorkspaceItem build() {
        try {
            this.context.dispatchEvents();
            indexingService.commit();
            return this.workspaceItem;
        }
        catch (Exception e) {
            return (WorkspaceItem)this.handleException(e);
        }
    }

    private void deleteItem(Context c, Item dso) throws Exception {
        if (dso != null) {
            itemService.delete(c, (DSpaceObject)dso);
        }
    }

    @Override
    public void delete(Context c, WorkspaceItem dso) throws Exception {
        if (dso != null) {
            this.getService().deleteAll(c, dso);
        }
    }

    public static void deleteWorkspaceItem(Integer id) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            WorkspaceItem workspaceItem = workspaceItemService.find(c, id.intValue());
            if (workspaceItem != null) {
                try {
                    workspaceItemService.deleteAll(c, workspaceItem);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e);
                }
            }
            c.complete();
        }
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.workspaceItem = (WorkspaceItem)c.reloadEntity((ReloadableEntity)this.workspaceItem);
            if (this.workspaceItem != null) {
                this.delete(c, this.workspaceItem);
            } else {
                this.item = (Item)c.reloadEntity((ReloadableEntity)this.item);
                XmlWorkflowItem wfi = (XmlWorkflowItem)workflowItemService.findByItem(c, this.item);
                if (wfi != null) {
                    workflowItemService.delete(c, (WorkflowItem)wfi);
                }
            }
            this.item = (Item)c.reloadEntity((ReloadableEntity)this.item);
            if (this.item != null) {
                this.deleteItem(c, this.item);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    protected WorkspaceItemService getService() {
        return workspaceItemService;
    }

    protected WorkspaceItemBuilder addMetadataValue(String schema, String element, String qualifier, String value) {
        try {
            itemService.addMetadata(this.context, (DSpaceObject)this.workspaceItem.getItem(), schema, element, qualifier, "*", value);
        }
        catch (Exception e) {
            return (WorkspaceItemBuilder)this.handleException(e);
        }
        return this;
    }

    public WorkspaceItemBuilder withSubmitter(EPerson ePerson) {
        this.workspaceItem.getItem().setSubmitter(ePerson);
        return this;
    }

    protected WorkspaceItemBuilder setMetadataSingleValue(String schema, String element, String qualifier, String value) {
        try {
            itemService.setMetadataSingleValue(this.context, (DSpaceObject)this.workspaceItem.getItem(), schema, element, qualifier, "*", value);
        }
        catch (Exception e) {
            return (WorkspaceItemBuilder)this.handleException(e);
        }
        return this;
    }

    public WorkspaceItemBuilder withTitle(String title) {
        return this.setMetadataSingleValue(MetadataSchemaEnum.DC.getName(), "title", null, title);
    }

    public WorkspaceItemBuilder withIssueDate(String issueDate) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "date", "issued", new DCDate(issueDate).toString());
    }

    public WorkspaceItemBuilder withAuthor(String authorName) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "contributor", "author", authorName);
    }

    public WorkspaceItemBuilder withSubject(String subject) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "subject", null, subject);
    }

    public WorkspaceItemBuilder withAbstract(String subject) {
        return this.addMetadataValue(MetadataSchemaEnum.DC.getName(), "description", "abstract", subject);
    }

    public WorkspaceItemBuilder withEntityType(String entityType) {
        return this.addMetadataValue("dspace", "entity", "type", entityType);
    }

    public WorkspaceItemBuilder grantLicense() {
        Item item = this.workspaceItem.getItem();
        try {
            EPerson submitter = this.workspaceItem.getSubmitter();
            submitter = (EPerson)this.context.reloadEntity((ReloadableEntity)submitter);
            String license = LicenseUtils.getLicenseText((Locale)this.context.getCurrentLocale(), (Collection)this.workspaceItem.getCollection(), (Item)item, (EPerson)submitter);
            LicenseUtils.grantLicense((Context)this.context, (Item)item, (String)license, null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }

    public WorkspaceItemBuilder withFulltext(String name, String source, InputStream is) {
        try {
            Item item = this.workspaceItem.getItem();
            Bitstream b = itemService.createSingleBitstream(this.context, is, item);
            b.setName(this.context, name);
            b.setSource(this.context, source);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }
}

