/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import org.dspace.content.MetadataFieldName;
import org.junit.Assert;
import org.junit.Test;

public class MetadataFieldNameTest {
    private static final String STRING_NAME_3 = "one.two.three";
    private static final String STRING_NAME_2 = "one.two";

    @Test
    public void testConstruct3() {
        MetadataFieldName instance = new MetadataFieldName("one", "two", "three");
        Assert.assertEquals((String)"Incorrect schema", (Object)"one", (Object)instance.SCHEMA);
        Assert.assertEquals((String)"Incorrect element", (Object)"two", (Object)instance.ELEMENT);
        Assert.assertEquals((String)"Incorrect qualifier", (Object)"three", (Object)instance.QUALIFIER);
    }

    @Test
    public void testConstruct2() {
        MetadataFieldName instance = new MetadataFieldName("one", "two");
        Assert.assertEquals((String)"Incorrect schema", (Object)"one", (Object)instance.SCHEMA);
        Assert.assertEquals((String)"Incorrect element", (Object)"two", (Object)instance.ELEMENT);
        Assert.assertNull((String)"Incorrect qualifier", (Object)instance.QUALIFIER);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructNull() {
        MetadataFieldName instance = new MetadataFieldName("one", null);
    }

    @Test
    public void testParse3() {
        String[] results = MetadataFieldName.parse((String)STRING_NAME_3);
        Assert.assertEquals((String)STRING_NAME_3, (Object)"one", (Object)results[0]);
        Assert.assertEquals((String)STRING_NAME_3, (Object)"two", (Object)results[1]);
        Assert.assertEquals((String)STRING_NAME_3, (Object)"three", (Object)results[2]);
    }

    @Test
    public void TestParse2() {
        String[] results = MetadataFieldName.parse((String)STRING_NAME_2);
        Assert.assertEquals((String)STRING_NAME_2, (Object)"one", (Object)results[0]);
        Assert.assertEquals((String)STRING_NAME_2, (Object)"two", (Object)results[1]);
        Assert.assertNull((String)STRING_NAME_2, (Object)results[2]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void TestParse1() {
        String[] results = MetadataFieldName.parse((String)"one");
    }

    @Test(expected=IllegalArgumentException.class)
    public void TestParse0() {
        String[] results = MetadataFieldName.parse((String)"");
    }

    @Test(expected=NullPointerException.class)
    public void TestParseNull() {
        String[] results = MetadataFieldName.parse(null);
    }

    @Test
    public void testToString3() {
        MetadataFieldName instance = new MetadataFieldName("one", "two", "three");
        String name = instance.toString();
        Assert.assertEquals((String)"Stringified name not assembled correctly", (Object)STRING_NAME_3, (Object)name);
    }

    @Test
    public void testToString2() {
        MetadataFieldName instance = new MetadataFieldName("one", "two");
        String name = instance.toString();
        Assert.assertEquals((String)"Stringified name not assembled correctly", (Object)STRING_NAME_2, (Object)name);
    }
}

