/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RelationshipServiceImplPlaceTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(RelationshipServiceImplPlaceTest.class);
    protected RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    protected RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
    protected EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
    Community community;
    Collection col;
    Item item;
    Item authorItem;
    RelationshipType isAuthorOfPublication;
    EntityType publicationEntityType;
    EntityType authorEntityType;
    String authorQualifier = "author";
    String contributorElement = "contributor";
    String dcSchema = "dc";

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.community = this.communityService.create(null, this.context);
            this.col = this.collectionService.create(this.context, this.community);
            WorkspaceItem is = this.workspaceItemService.create(this.context, this.col, false);
            WorkspaceItem authorIs = this.workspaceItemService.create(this.context, this.col, false);
            this.item = this.installItemService.installItem(this.context, (InProgressSubmission)is);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.item, "dspace", "entity", "type", null, "Publication");
            this.authorItem = this.installItemService.installItem(this.context, (InProgressSubmission)authorIs);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.authorItem, "dspace", "entity", "type", null, "Person");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.authorItem, "person", "familyName", null, null, "familyName");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.authorItem, "person", "givenName", null, null, "firstName");
            this.publicationEntityType = this.entityTypeService.create(this.context, "Publication");
            this.authorEntityType = this.entityTypeService.create(this.context, "Person");
            this.isAuthorOfPublication = this.relationshipTypeService.create(this.context, this.publicationEntityType, this.authorEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.abort();
        super.destroy();
    }

    @Test
    public void addMetadataAndRelationshipTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        Relationship relationship = this.relationshipService.create(this.context, this.item, this.authorItem, this.isAuthorOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 2, (MetadataValue)list.get(2));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four");
        WorkspaceItem authorIs = this.workspaceItemService.create(this.context, this.col, false);
        Item secondAuthorItem = this.installItemService.installItem(this.context, (InProgressSubmission)authorIs);
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "dspace", "entity", "type", null, "Person");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "familyName", null, null, "familyNameTwo");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "givenName", null, null, "firstNameTwo");
        Relationship relationshipTwo = this.relationshipService.create(this.context, this.item, secondAuthorItem, this.isAuthorOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 2, (MetadataValue)list.get(2));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list.get(3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 4, (MetadataValue)list.get(4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyNameTwo, firstNameTwo", "virtual::" + relationshipTwo.getID(), 5, (MetadataValue)list.get(5));
        MatcherAssert.assertThat((Object)relationshipTwo.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void AddMetadataAndRelationshipWithSpecificPlaceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        Relationship relationship = this.relationshipService.create(this.context, this.item, this.authorItem, this.isAuthorOfPublication, 2, -1);
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 2, (MetadataValue)list.get(2));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four");
        WorkspaceItem authorIs = this.workspaceItemService.create(this.context, this.col, false);
        Item secondAuthorItem = this.installItemService.installItem(this.context, (InProgressSubmission)authorIs);
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "dspace", "entity", "type", null, "Person");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "familyName", null, null, "familyNameTwo");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "givenName", null, null, "firstNameTwo");
        Relationship relationshipTwo = this.relationshipService.create(this.context, this.item, secondAuthorItem, this.isAuthorOfPublication, 5, -1);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 2, (MetadataValue)list.get(2));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list.get(3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 4, (MetadataValue)list.get(4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyNameTwo, firstNameTwo", "virtual::" + relationshipTwo.getID(), 5, (MetadataValue)list.get(5));
        MatcherAssert.assertThat((Object)relationshipTwo.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void AddAndRemoveMetadataAndRelationshipsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        MetadataValue metadataValueToRemove = (MetadataValue)this.itemService.getMetadata((DSpaceObject)this.item, "dc", "contributor", "author", "*").get(1);
        this.item.removeMetadata(metadataValueToRemove);
        this.metadataValueService.delete(this.context, metadataValueToRemove);
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(1));
        this.context.turnOffAuthorisationSystem();
        Relationship relationship = this.relationshipService.create(this.context, this.item, this.authorItem, this.isAuthorOfPublication, 1, -1);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 1, (MetadataValue)list.get(1));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, five");
        metadataValueToRemove = (MetadataValue)this.itemService.getMetadata((DSpaceObject)this.item, "dc", "contributor", "author", "*").get(3);
        this.item.removeMetadata(metadataValueToRemove);
        this.metadataValueService.delete(this.context, metadataValueToRemove);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 1, (MetadataValue)list.get(1));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, five", null, 4, (MetadataValue)list.get(3));
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem authorIs = this.workspaceItemService.create(this.context, this.col, false);
        Item secondAuthorItem = this.installItemService.installItem(this.context, (InProgressSubmission)authorIs);
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "dspace", "entity", "type", null, "Person");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "familyName", null, null, "familyNameTwo");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "givenName", null, null, "firstNameTwo");
        Relationship relationshipTwo = this.relationshipService.create(this.context, this.item, secondAuthorItem, this.isAuthorOfPublication, 3, -1);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 1, (MetadataValue)list.get(1));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyNameTwo, firstNameTwo", "virtual::" + relationshipTwo.getID(), 3, (MetadataValue)list.get(3));
        MatcherAssert.assertThat((Object)relationshipTwo.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, five", null, 4, (MetadataValue)list.get(4));
    }

    @Test
    public void AddAndUpdateMetadataAndRelationshipsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        Relationship relationship = this.relationshipService.create(this.context, this.item, this.authorItem, this.isAuthorOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 3, (MetadataValue)list.get(3));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.context.turnOffAuthorisationSystem();
        MetadataValue metadataValueToUpdate = (MetadataValue)this.itemService.getMetadata((DSpaceObject)this.item, "dc", "contributor", "author", "*").get(1);
        metadataValueToUpdate.setPlace(3);
        this.metadataValueService.update(this.context, metadataValueToUpdate);
        relationship.setLeftPlace(1);
        this.relationshipService.update(this.context, (Object)relationship);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 3, (MetadataValue)list.get(3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 1, (MetadataValue)list.get(1));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    private void assertMetadataValue(String authorQualifier, String contributorElement, String dcSchema, String value, String authority, int place, MetadataValue metadataValue) {
        MatcherAssert.assertThat((Object)metadataValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
        MatcherAssert.assertThat((Object)metadataValue.getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)dcSchema));
        MatcherAssert.assertThat((Object)metadataValue.getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)contributorElement));
        MatcherAssert.assertThat((Object)metadataValue.getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)authorQualifier));
        MatcherAssert.assertThat((Object)metadataValue.getAuthority(), (Matcher)CoreMatchers.equalTo((Object)authority));
        MatcherAssert.assertThat((Object)metadataValue.getPlace(), (Matcher)CoreMatchers.equalTo((Object)place));
    }
}

