/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.List;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.RelationshipMetadataServiceIT;
import org.dspace.content.RelationshipMetadataValue;
import org.dspace.content.RelationshipType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class RightTiltedRelationshipMetadataServiceIT
extends RelationshipMetadataServiceIT {
    @Override
    protected void initJournalVolumeIssue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EntityType journalIssueEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "JournalIssue").build();
        EntityType publicationVolumeEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "JournalVolume").build();
        this.leftItem = ItemBuilder.createItem(this.context, this.col).withEntityType("JournalIssue").withPublicationIssueNumber("2").build();
        this.rightItem = ItemBuilder.createItem(this.context, this.col).withEntityType("JournalVolume").withPublicationVolumeNumber("30").build();
        RelationshipType isIssueOfVolume = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, journalIssueEntityType, publicationVolumeEntityType, "isJournalVolumeOfIssue", "isIssueOfJournalVolume", null, null, null, null).build();
        isIssueOfVolume.setTilted(RelationshipType.Tilted.RIGHT);
        this.relationshipTypeService.update(this.context, (Object)isIssueOfVolume);
        this.relationship = RelationshipBuilder.createRelationshipBuilder(this.context, this.leftItem, this.rightItem, isIssueOfVolume).build();
        this.context.restoreAuthSystemState();
    }

    @Override
    @Test
    public void testGetJournalRelationshipMetadata() throws Exception {
        this.initJournalVolumeIssue();
        List volumeList = this.itemService.getMetadata((DSpaceObject)this.leftItem, "publicationvolume", "volumeNumber", null, "*");
        MatcherAssert.assertThat((Object)volumeList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List issueList = this.itemService.getMetadata((DSpaceObject)this.rightItem, "publicationissue", "issueNumber", null, "*");
        MatcherAssert.assertThat((Object)issueList.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((MetadataValue)issueList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        List issueRelList = this.relationshipMetadataService.getRelationshipMetadata(this.leftItem, true);
        MatcherAssert.assertThat((Object)issueRelList.size(), (Matcher)CoreMatchers.equalTo((Object)0));
        List volumeRelList = this.relationshipMetadataService.getRelationshipMetadata(this.rightItem, true);
        MatcherAssert.assertThat((Object)volumeRelList.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getValue(), (Matcher)CoreMatchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)"publicationissue"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"issueNumber"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo(null));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(0)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getValue(), (Matcher)CoreMatchers.equalTo((Object)String.valueOf(this.leftItem.getID())));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)MetadataSchemaEnum.RELATION.getName()));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)"isIssueOfJournalVolume"));
        MatcherAssert.assertThat((Object)((RelationshipMetadataValue)volumeRelList.get(1)).getAuthority(), (Matcher)CoreMatchers.equalTo((Object)("virtual::" + this.relationship.getID())));
    }
}

