/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.net.Inet6Address;
import java.net.UnknownHostException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.IPMatcherException;

public class IPMatcher {
    private static Logger log = LogManager.getLogger(IPMatcher.class);
    private byte[] network;
    private byte[] netmask;

    public IPMatcher(String ipSpec) throws IPMatcherException {
        block27: {
            String[] parts;
            String ipPart;
            block26: {
                ipPart = ipSpec;
                parts = ipSpec.split("/");
                if (parts[0].indexOf(58) < 0) break block26;
                try {
                    this.network = Inet6Address.getByName(parts[0]).getAddress();
                }
                catch (UnknownHostException e) {
                    throw new IPMatcherException("Malformed IP range specification " + ipSpec, e);
                }
                this.netmask = new byte[16];
                switch (parts.length) {
                    case 2: {
                        int maskBits;
                        try {
                            maskBits = Integer.parseInt(parts[1]);
                        }
                        catch (NumberFormatException nfe) {
                            throw new IPMatcherException("Malformed IP range specification " + ipSpec, nfe);
                        }
                        if (maskBits < 0 || maskBits > 128) {
                            throw new IPMatcherException("Mask bits out of range 0-128 " + ipSpec);
                        }
                        for (int i = 0; i < this.netmask.length; ++i) {
                            this.netmask[i] = maskBits <= 0 ? 0 : (maskBits > 8 ? -1 : (byte)(-1 << 8 - maskBits));
                            maskBits -= 8;
                        }
                        break block27;
                    }
                    case 1: {
                        for (int i = 0; i < this.netmask.length; ++i) {
                            this.netmask[i] = -1;
                        }
                        break block27;
                    }
                    default: {
                        throw new IPMatcherException("Malformed IP range specification " + ipSpec);
                    }
                }
            }
            boolean mustHave4 = false;
            this.network = new byte[4];
            this.netmask = new byte[4];
            switch (parts.length) {
                case 2: {
                    ipPart = parts[0];
                    mustHave4 = true;
                    String[] maskParts = parts[1].split("\\.");
                    if (maskParts.length == 1) {
                        int i;
                        int x;
                        try {
                            x = Integer.parseInt(maskParts[0]);
                        }
                        catch (NumberFormatException nfe) {
                            throw new IPMatcherException("Malformed IP range specification " + ipSpec, nfe);
                        }
                        if (x < 0 || x > 32) {
                            throw new IPMatcherException();
                        }
                        int fullMask = -1 << 32 - x;
                        this.netmask[0] = (byte)((fullMask & 0xFF000000) >>> 24);
                        this.netmask[1] = (byte)((fullMask & 0xFF0000) >>> 16);
                        this.netmask[2] = (byte)((fullMask & 0xFF00) >>> 8);
                        this.netmask[3] = (byte)(fullMask & 0xFF);
                        IPMatcher.ipToBytes(ipPart, this.network, mustHave4);
                        if (!log.isDebugEnabled()) break;
                        log.debug("fullMask: " + fullMask);
                        for (i = 0; i < this.network.length; ++i) {
                            log.debug("network[" + i + "]: " + this.network[i]);
                        }
                        for (i = 0; i < this.netmask.length; ++i) {
                            log.debug("netmask[" + i + "]: " + this.netmask[i]);
                        }
                        break;
                    }
                    IPMatcher.ipToBytes(parts[0], this.network, true);
                    IPMatcher.ipToBytes(parts[1], this.netmask, true);
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.netmask.length; ++i) {
                        this.netmask[i] = -1;
                    }
                    int partCount = IPMatcher.ipToBytes(ipPart, this.network, mustHave4);
                    for (int i = 3; i >= partCount; --i) {
                        this.netmask[i] = 0;
                    }
                    break;
                }
                default: {
                    throw new IPMatcherException("Malformed IP range specification " + ipSpec);
                }
            }
            this.network = IPMatcher.ip4ToIp6(this.network);
            this.netmask = IPMatcher.ip4MaskToIp6(this.netmask);
            if (log.isDebugEnabled()) {
                int i;
                for (i = 0; i < this.network.length; ++i) {
                    log.debug("network[" + i + "]: " + this.network[i]);
                }
                for (i = 0; i < this.netmask.length; ++i) {
                    log.debug("netmask[" + i + "]: " + this.netmask[i]);
                }
            }
        }
    }

    private static int ipToBytes(String ip, byte[] bytes, boolean mustHave4) throws IPMatcherException {
        String[] parts = ip.split("\\.");
        if (parts.length > 4 || mustHave4 && parts.length != 4) {
            throw new IPMatcherException("Malformed IP specification " + ip);
        }
        try {
            for (int i = 0; i < parts.length; ++i) {
                int p = Integer.parseInt(parts[i]);
                if (p < 0 || p > 255) {
                    throw new IPMatcherException("Malformed IP specification " + ip);
                }
                bytes[i] = (byte)(p < 128 ? p : p - 256);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IPMatcherException("Malformed IP specification " + ip, nfe);
        }
        return parts.length;
    }

    public boolean match(String ipIn) throws IPMatcherException {
        byte[] candidate;
        log.debug("ipIn: " + ipIn);
        if (ipIn.indexOf(58) < 0) {
            candidate = new byte[4];
            IPMatcher.ipToBytes(ipIn, candidate, true);
            candidate = IPMatcher.ip4ToIp6(candidate);
        } else {
            try {
                candidate = Inet6Address.getByName(ipIn).getAddress();
            }
            catch (UnknownHostException e) {
                throw new IPMatcherException("Malformed IPv6 address ", e);
            }
        }
        for (int i = 0; i < this.netmask.length; ++i) {
            if ((candidate[i] & this.netmask[i]) == (this.network[i] & this.netmask[i])) continue;
            if (log.isDebugEnabled()) {
                log.debug("candidate[i]: " + candidate[i]);
                log.debug("netmask[i]: " + this.netmask[i]);
                log.debug("candidate[i] & netmask[i]: " + (candidate[i] & this.netmask[i]));
                log.debug("network[i]: " + this.network[i]);
                log.debug("network[i] & netmask[i]: " + (this.network[i] & this.netmask[i]));
            }
            return false;
        }
        return true;
    }

    private static byte[] ip4ToIp6(byte[] ip4) {
        int i;
        if (ip4.length != 4) {
            throw new IllegalArgumentException("IPv4 address must be four octets");
        }
        byte[] ip6 = new byte[16];
        for (i = 0; i < 12; ++i) {
            ip6[i] = 0;
        }
        for (i = 0; i < 4; ++i) {
            ip6[12 + i] = ip4[i];
        }
        return ip6;
    }

    private static byte[] ip4MaskToIp6(byte[] ip4) {
        int i;
        if (ip4.length != 4) {
            throw new IllegalArgumentException("IPv4 mask must be four octets");
        }
        byte[] ip6 = new byte[16];
        for (i = 0; i < 12; ++i) {
            ip6[i] = -1;
        }
        for (i = 0; i < 4; ++i) {
            ip6[12 + i] = ip4[i];
        }
        return ip6;
    }
}

